/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.mongodb.DBRefBase;
import com.mongodb.util.MyAsserts;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONEncoder;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class BasicBSONEncoder
implements BSONEncoder {
    static final boolean DEBUG = false;
    protected OutputBuffer _buf;

    public byte[] encode(BSONObject o2) {
        BasicOutputBuffer buf = new BasicOutputBuffer();
        this.set(buf);
        this.putObject(o2);
        this.done();
        return buf.toByteArray();
    }

    public void set(OutputBuffer out) {
        if (this._buf != null) {
            throw new IllegalStateException("in the middle of something");
        }
        this._buf = out;
    }

    public void done() {
        this._buf = null;
    }

    protected boolean handleSpecialObjects(String name, BSONObject o2) {
        return false;
    }

    protected boolean putSpecial(String name, Object o2) {
        return false;
    }

    public int putObject(BSONObject o2) {
        return this.putObject(null, o2);
    }

    protected int putObject(String name, BSONObject o2) {
        boolean rewriteID;
        if (o2 == null) {
            throw new NullPointerException("can't save a null object");
        }
        int start = this._buf.getPosition();
        byte myType = 3;
        if (o2 instanceof List) {
            myType = 4;
        }
        if (this.handleSpecialObjects(name, o2)) {
            return this._buf.getPosition() - start;
        }
        if (name != null) {
            this._put(myType, name);
        }
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        List transientFields = null;
        boolean bl = rewriteID = myType == 3 && name == null;
        if (myType == 3) {
            Object temp;
            if (rewriteID && o2.containsField("_id")) {
                this._putObjectField("_id", o2.get("_id"));
            }
            if ((temp = o2.get("_transientFields")) instanceof List) {
                transientFields = (List)temp;
            }
        }
        if (o2 instanceof Map) {
            for (Map.Entry entry : ((Map)((Object)o2)).entrySet()) {
                if (rewriteID && ((String)entry.getKey()).equals("_id") || transientFields != null && transientFields.contains(entry.getKey())) continue;
                this._putObjectField((String)entry.getKey(), entry.getValue());
            }
        } else {
            for (String string : o2.keySet()) {
                if (rewriteID && string.equals("_id") || transientFields != null && transientFields.contains(string)) continue;
                Object val = o2.get(string);
                this._putObjectField(string, val);
            }
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
        return this._buf.getPosition() - start;
    }

    protected void _putObjectField(String name, Object val) {
        if (name.equals("_transientFields")) {
            return;
        }
        if (name.contains("\u0000")) {
            throw new IllegalArgumentException("Document field names can't have a NULL character. (Bad Key: '" + name + "')");
        }
        if (name.equals("$where") && val instanceof String) {
            this._put((byte)13, name);
            this._putValueString(val.toString());
            return;
        }
        if ((val = BSON.applyEncodingHooks(val)) == null) {
            this.putNull(name);
        } else if (val instanceof Date) {
            this.putDate(name, (Date)val);
        } else if (val instanceof Number) {
            this.putNumber(name, (Number)val);
        } else if (val instanceof Character) {
            this.putString(name, val.toString());
        } else if (val instanceof String) {
            this.putString(name, val.toString());
        } else if (val instanceof ObjectId) {
            this.putObjectId(name, (ObjectId)val);
        } else if (val instanceof BSONObject) {
            this.putObject(name, (BSONObject)val);
        } else if (val instanceof Boolean) {
            this.putBoolean(name, (Boolean)val);
        } else if (val instanceof Pattern) {
            this.putPattern(name, (Pattern)val);
        } else if (val instanceof Map) {
            this.putMap(name, (Map)val);
        } else if (val instanceof Iterable) {
            this.putIterable(name, (Iterable)val);
        } else if (val instanceof byte[]) {
            this.putBinary(name, (byte[])val);
        } else if (val instanceof Binary) {
            this.putBinary(name, (Binary)val);
        } else if (val instanceof UUID) {
            this.putUUID(name, (UUID)val);
        } else if (val.getClass().isArray()) {
            this.putArray(name, val);
        } else if (val instanceof Symbol) {
            this.putSymbol(name, (Symbol)val);
        } else if (val instanceof BSONTimestamp) {
            this.putTimestamp(name, (BSONTimestamp)val);
        } else if (val instanceof CodeWScope) {
            this.putCodeWScope(name, (CodeWScope)val);
        } else if (val instanceof Code) {
            this.putCode(name, (Code)val);
        } else if (val instanceof DBRefBase) {
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$ref", (Object)((DBRefBase)val).getRef());
            temp.put("$id", ((DBRefBase)val).getId());
            this.putObject(name, temp);
        } else if (val instanceof MinKey) {
            this.putMinKey(name);
        } else if (val instanceof MaxKey) {
            this.putMaxKey(name);
        } else if (!this.putSpecial(name, val)) {
            throw new IllegalArgumentException("can't serialize " + val.getClass());
        }
    }

    private void putArray(String name, Object array) {
        this._put((byte)4, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        int size = Array.getLength(array);
        for (int i2 = 0; i2 < size; ++i2) {
            this._putObjectField(String.valueOf(i2), Array.get(array, i2));
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    private void putIterable(String name, Iterable l2) {
        this._put((byte)4, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        int i2 = 0;
        for (Object obj : l2) {
            this._putObjectField(String.valueOf(i2), obj);
            ++i2;
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    private void putMap(String name, Map m2) {
        this._put((byte)3, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        for (Map.Entry entry : m2.entrySet()) {
            this._putObjectField(entry.getKey().toString(), entry.getValue());
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    protected void putNull(String name) {
        this._put((byte)10, name);
    }

    protected void putUndefined(String name) {
        this._put((byte)6, name);
    }

    protected void putTimestamp(String name, BSONTimestamp ts) {
        this._put((byte)17, name);
        this._buf.writeInt(ts.getInc());
        this._buf.writeInt(ts.getTime());
    }

    protected void putCodeWScope(String name, CodeWScope code) {
        this._put((byte)15, name);
        int temp = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putValueString(code.getCode());
        this.putObject(code.getScope());
        this._buf.writeInt(temp, this._buf.getPosition() - temp);
    }

    protected void putCode(String name, Code code) {
        this._put((byte)13, name);
        int temp = this._buf.getPosition();
        this._putValueString(code.getCode());
    }

    protected void putBoolean(String name, Boolean b2) {
        this._put((byte)8, name);
        this._buf.write(b2 != false ? 1 : 0);
    }

    protected void putDate(String name, Date d2) {
        this._put((byte)9, name);
        this._buf.writeLong(d2.getTime());
    }

    protected void putNumber(String name, Number n2) {
        if (n2 instanceof Integer || n2 instanceof Short || n2 instanceof Byte || n2 instanceof AtomicInteger) {
            this._put((byte)16, name);
            this._buf.writeInt(n2.intValue());
        } else if (n2 instanceof Long || n2 instanceof AtomicLong) {
            this._put((byte)18, name);
            this._buf.writeLong(n2.longValue());
        } else if (n2 instanceof Float || n2 instanceof Double) {
            this._put((byte)1, name);
            this._buf.writeDouble(n2.doubleValue());
        } else {
            throw new IllegalArgumentException("can't serialize " + n2.getClass());
        }
    }

    protected void putBinary(String name, byte[] data) {
        this.putBinary(name, 0, data);
    }

    protected void putBinary(String name, Binary val) {
        this.putBinary(name, val.getType(), val.getData());
    }

    private void putBinary(String name, int type, byte[] data) {
        this._put((byte)5, name);
        int totalLen = data.length;
        if (type == 2) {
            totalLen += 4;
        }
        this._buf.writeInt(totalLen);
        this._buf.write(type);
        if (type == 2) {
            this._buf.writeInt(totalLen - 4);
        }
        int before = this._buf.getPosition();
        this._buf.write(data);
        int after = this._buf.getPosition();
        MyAsserts.assertEquals(after - before, data.length);
    }

    protected void putUUID(String name, UUID val) {
        this._put((byte)5, name);
        this._buf.writeInt(16);
        this._buf.write(3);
        this._buf.writeLong(val.getMostSignificantBits());
        this._buf.writeLong(val.getLeastSignificantBits());
    }

    protected void putSymbol(String name, Symbol s2) {
        this._putString(name, s2.getSymbol(), (byte)14);
    }

    protected void putString(String name, String s2) {
        this._putString(name, s2, (byte)2);
    }

    private void _putString(String name, String s2, byte type) {
        this._put(type, name);
        this._putValueString(s2);
    }

    protected void putObjectId(String name, ObjectId oid) {
        this._put((byte)7, name);
        this._buf.writeIntBE(oid._time());
        this._buf.writeIntBE(oid._machine());
        this._buf.writeIntBE(oid._inc());
    }

    private void putPattern(String name, Pattern p2) {
        this._put((byte)11, name);
        this._put(p2.pattern());
        this._put(BSON.regexFlags(p2.flags()));
    }

    private void putMinKey(String name) {
        this._put((byte)-1, name);
    }

    private void putMaxKey(String name) {
        this._put((byte)127, name);
    }

    protected void _put(byte type, String name) {
        this._buf.write(type);
        this._put(name);
    }

    protected void _putValueString(String s2) {
        int lenPos = this._buf.getPosition();
        this._buf.writeInt(0);
        int strLen = this._put(s2);
        this._buf.writeInt(lenPos, strLen);
    }

    void _reset(Buffer b2) {
        b2.position(0);
        b2.limit(b2.capacity());
    }

    protected int _put(String str) {
        int c2;
        int len = str.length();
        int total = 0;
        for (int i2 = 0; i2 < len; i2 += Character.charCount(c2)) {
            c2 = Character.codePointAt(str, i2);
            if (c2 == 0) {
                throw new BSONException(String.format("BSON cstring '%s' is not valid because it contains a null character at index %d", str, i2));
            }
            if (c2 < 128) {
                this._buf.write((byte)c2);
                ++total;
                continue;
            }
            if (c2 < 2048) {
                this._buf.write((byte)(192 + (c2 >> 6)));
                this._buf.write((byte)(128 + (c2 & 0x3F)));
                total += 2;
                continue;
            }
            if (c2 < 65536) {
                this._buf.write((byte)(224 + (c2 >> 12)));
                this._buf.write((byte)(128 + (c2 >> 6 & 0x3F)));
                this._buf.write((byte)(128 + (c2 & 0x3F)));
                total += 3;
                continue;
            }
            this._buf.write((byte)(240 + (c2 >> 18)));
            this._buf.write((byte)(128 + (c2 >> 12 & 0x3F)));
            this._buf.write((byte)(128 + (c2 >> 6 & 0x3F)));
            this._buf.write((byte)(128 + (c2 & 0x3F)));
            total += 4;
        }
        this._buf.write(0);
        return ++total;
    }

    public void writeInt(int x2) {
        this._buf.writeInt(x2);
    }

    public void writeLong(long x2) {
        this._buf.writeLong(x2);
    }

    public void writeCString(String s2) {
        this._put(s2);
    }
}

