/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.QualityUtils;
import org.broadinstitute.gatk.utils.pairhmm.N2MemoryPairHMM;
import org.broadinstitute.gatk.utils.pairhmm.PairHMMModel;

public class Log10PairHMM
extends N2MemoryPairHMM {
    private final boolean doExactLog10;
    protected static final double log10_3 = Math.log10(3.0);

    public Log10PairHMM(boolean doExactLog10) {
        this.doExactLog10 = doExactLog10;
    }

    public boolean isDoingExactLog10Calculations() {
        return this.doExactLog10;
    }

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        for (int iii = 0; iii < this.paddedMaxReadLength; ++iii) {
            Arrays.fill(this.matchMatrix[iii], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.insertionMatrix[iii], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.deletionMatrix[iii], Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues, int nextHapStartIndex) {
        if (!this.constantsAreInitialized || recacheReadValues) {
            this.initializeProbabilities(insertionGOP, deletionGOP, overallGCP);
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        if (this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length) {
            this.initializeMatrixValues(haplotypeBases);
        }
        for (int i2 = 1; i2 < this.paddedReadLength; ++i2) {
            for (int j2 = hapStartIndex + 1; j2 < this.paddedHaplotypeLength; ++j2) {
                this.updateCell(i2, j2, this.prior[i2][j2], this.transition[i2]);
            }
        }
        return this.finalLikelihoodCalculation();
    }

    protected void initializeMatrixValues(byte[] haplotypeBases) {
        double initialValue = Math.log10(1.0 / (double)haplotypeBases.length);
        for (int j2 = 0; j2 < this.paddedHaplotypeLength; ++j2) {
            this.deletionMatrix[0][j2] = initialValue;
        }
    }

    protected double finalLikelihoodCalculation() {
        int endI = this.paddedReadLength - 1;
        double finalSumProbabilities = this.myLog10SumLog10(new double[]{this.matchMatrix[endI][1], this.insertionMatrix[endI][1]});
        for (int j2 = 2; j2 < this.paddedHaplotypeLength; ++j2) {
            finalSumProbabilities = this.myLog10SumLog10(new double[]{finalSumProbabilities, this.matchMatrix[endI][j2], this.insertionMatrix[endI][j2]});
        }
        return finalSumProbabilities;
    }

    public void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i2 = 0; i2 < readBases.length; ++i2) {
            byte x2 = readBases[i2];
            byte qual = readQuals[i2];
            for (int j2 = startIndex; j2 < haplotypeBases.length; ++j2) {
                byte y = haplotypeBases[j2];
                this.prior[i2 + 1][j2 + 1] = x2 == y || x2 == 78 || y == 78 ? QualityUtils.qualToProbLog10(qual) : QualityUtils.qualToErrorProbLog10(qual) - (this.doNotUseTristateCorrection ? 0.0 : log10_3);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    protected void initializeProbabilities(byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        PairHMMModel.qualToTransProbsLog10(this.transition, insertionGOP, deletionGOP, overallGCP);
        this.constantsAreInitialized = true;
    }

    @Requires(value={"values != null"})
    protected double myLog10SumLog10(double[] values) {
        return this.doExactLog10 ? MathUtils.log10sumLog10(values) : MathUtils.approximateLog10SumLog10(values);
    }

    protected void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior + this.myLog10SumLog10(new double[]{this.matchMatrix[indI - 1][indJ - 1] + transition[0], this.insertionMatrix[indI - 1][indJ - 1] + transition[1], this.deletionMatrix[indI - 1][indJ - 1] + transition[1]});
        this.insertionMatrix[indI][indJ] = this.myLog10SumLog10(new double[]{this.matchMatrix[indI - 1][indJ] + transition[2], this.insertionMatrix[indI - 1][indJ] + transition[3]});
        this.deletionMatrix[indI][indJ] = this.myLog10SumLog10(new double[]{this.matchMatrix[indI][indJ - 1] + transition[4], this.deletionMatrix[indI][indJ - 1] + transition[5]});
    }
}

