/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import htsjdk.samtools.util.ftp.FTPClient;
import htsjdk.samtools.util.ftp.FTPReply;
import htsjdk.tribble.readers.AsciiLineReader;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.renderer.ArcRenderer;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.GenotypeRenderer;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.UserPasswordInputImpl;
import org.broad.igv.util.ftp.FTPUtils;

public class ParsingUtils {
    private static Logger log = Logger.getLogger(ParsingUtils.class);
    public static final Pattern TAB_PATTERN = Pattern.compile("\t");
    public static final Pattern COMMA_PATTERN = Pattern.compile(",");
    public static final Pattern SEMI_COLON_PATTERN = Pattern.compile(";");
    public static final Pattern EQ_PATTERN = Pattern.compile("=");
    public static final Pattern PERIOD_PATTERN = Pattern.compile("\\.");
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final String codeFilePath = "resources/iupac_regex_table.txt";
    private static final DateFormat ftpDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public static BufferedReader openBufferedReader(String pathOrUrl) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(pathOrUrl)));
        return reader;
    }

    public static BufferedReader openBufferedReader(ResourceLocator locator) throws IOException {
        InputStream stream = ParsingUtils.openInputStreamGZ(locator);
        return new BufferedReader(new InputStreamReader(stream));
    }

    public static AsciiLineReader openAsciiReader(ResourceLocator locator) throws IOException {
        InputStream stream = ParsingUtils.openInputStreamGZ(locator);
        return new AsciiLineReader(stream);
    }

    public static InputStream openInputStream(String path) throws IOException {
        return ParsingUtils.openInputStreamGZ(new ResourceLocator(path));
    }

    public static InputStream openInputStreamGZ(ResourceLocator locator) throws IOException {
        InputStream inputStream = null;
        if (HttpUtils.isRemoteURL(locator.getPath())) {
            URL url = new URL(locator.getPath());
            inputStream = HttpUtils.getInstance().openConnectionStream(url);
        } else {
            String path = locator.getPath();
            if (path.startsWith("file://")) {
                path = path.substring(7);
            }
            File file = new File(path);
            inputStream = new FileInputStream(file);
        }
        if (locator.getPath().endsWith("gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static int parseInt(String string) {
        return (int)Double.parseDouble(string);
    }

    public static Map<String, String> loadMap(InputStream inputStream) {
        BufferedReader reader = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                String[] tokens = nextLine.split("=");
                if (tokens.length == 2) {
                    map.put(tokens[0], tokens[1]);
                    continue;
                }
                throw new IllegalArgumentException("Incorrect number of tokens at line: " + nextLine);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), ex);
            }
        }
        return map;
    }

    public static Map<String, String> loadIUPACMap() {
        return ParsingUtils.loadMap(ParsingUtils.class.getResourceAsStream(codeFilePath));
    }

    public static long getLastModified(String path) {
        if (HttpUtils.isRemoteURL(path)) {
            String resp = null;
            try {
                URL url = new URL(path);
                if (path.startsWith("ftp:")) {
                    String host = url.getHost();
                    FTPClient ftp = FTPUtils.connect(host, url.getUserInfo(), new UserPasswordInputImpl());
                    ftp.pasv();
                    FTPReply reply = ftp.executeCommand("MDTM " + url.getPath());
                    resp = reply.getReplyString();
                    return ftpDateFormat.parse(resp).getTime();
                }
                return HttpUtils.getInstance().getLastModified(url);
            }
            catch (MalformedURLException e2) {
                log.error("Malformed url " + path, e2);
            }
            catch (IOException e3) {
                log.error("Error getting modified date for " + path, e3);
            }
            catch (ParseException e4) {
                log.error("Error parsing Last-Modified " + resp, e4);
            }
            catch (NumberFormatException e5) {
                log.error("Error parsing Last-Modified " + resp, e5);
            }
            return 0L;
        }
        File f2 = new File(path);
        return f2.exists() ? f2.lastModified() : 0L;
    }

    public static long getContentLength(String path) {
        try {
            long contentLength = -1L;
            if (path.startsWith("http:") || path.startsWith("https:")) {
                URL url = new URL(path);
                contentLength = HttpUtils.getInstance().getContentLength(url);
            } else if (path.startsWith("ftp:")) {
                URL url = new URL(path);
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(Globals.CONNECT_TIMEOUT);
                contentLength = connection.getInputStream().available();
            } else {
                contentLength = new File(path).length();
            }
            return contentLength;
        }
        catch (IOException e2) {
            log.error("Error getting content length for: " + path, e2);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int estimateLineCount(String path) {
        AsciiLineReader reader = null;
        try {
            int nLines;
            String nextLine;
            int defaultLength = 100000;
            long fileLength = ParsingUtils.getContentLength(path);
            if (fileLength <= 0L) {
                int n2 = 100000;
                return n2;
            }
            reader = ParsingUtils.openAsciiReader(new ResourceLocator(path));
            int lines = 0;
            int nSkip = 10;
            while (nSkip-- > 0 && reader.readLine() != null) {
            }
            long startPos = reader.getPosition();
            while ((nextLine = reader.readLine()) != null & lines < 100) {
                ++lines;
            }
            if (lines == 0) {
                int n3 = 100000;
                return n3;
            }
            double bytesPerLine = (reader.getPosition() - startPos) / (long)lines;
            int n4 = nLines = (int)((double)fileLength / bytesPerLine);
            return n4;
        }
        catch (Exception e2) {
            log.error("Error estimating line count", e2);
            int n5 = 1000;
            return n5;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<String> loadRegions(File file) {
        try {
            String nextLine;
            FileInputStream fileInput = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInput));
            ArrayList<String> features = new ArrayList<String>();
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                try {
                    if (!nextLine.startsWith("chr")) continue;
                    String[] tokens = nextLine.split("\t");
                    String region = tokens[0] + ":" + tokens[1] + "-" + tokens[2];
                    features.add(region);
                }
                catch (NumberFormatException e2) {
                    log.error("Error parsing numer in line: " + nextLine);
                }
            }
            reader.close();
            return features;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static boolean parseTrackLine(String nextLine, TrackProperties trackProperties) throws NumberFormatException {
        boolean foundProperties = false;
        try {
            trackProperties.setTrackLine(nextLine);
            List<String> tokens = StringUtils.breakQuotedString(nextLine, ' ');
            for (String pair : tokens) {
                List<String> kv = StringUtils.breakQuotedString(pair, '=');
                if (kv.size() != 2) continue;
                foundProperties = true;
                String key = kv.get(0).toLowerCase().trim();
                String value = kv.get(1).replaceAll("\"", "");
                if (key.equals("coords")) {
                    if (value.equals("0")) {
                        trackProperties.setBaseCoord(TrackProperties.BaseCoord.ZERO);
                    } else if (value.equals("1")) {
                        trackProperties.setBaseCoord(TrackProperties.BaseCoord.ONE);
                    }
                }
                if (key.equals("name")) {
                    trackProperties.setName(value);
                    if (!value.equals("junctions")) continue;
                    trackProperties.setRendererClass(SpliceJunctionRenderer.class);
                    trackProperties.setHeight(60);
                    continue;
                }
                if (key.equals("description")) {
                    trackProperties.setDescription(value);
                    continue;
                }
                String valueLowerCase = value.toLowerCase();
                if (key.equals("itemrgb")) {
                    trackProperties.setItemRGB(valueLowerCase.equals("on") || value.equals("1"));
                    continue;
                }
                if (key.equals("usescore")) {
                    trackProperties.setUseScore(value.equals("1"));
                    continue;
                }
                if (key.equals("color")) {
                    Color color = ColorUtilities.stringToColor(value);
                    trackProperties.setColor(color);
                    continue;
                }
                if (key.equals("altcolor")) {
                    Color color = ColorUtilities.stringToColor(value);
                    trackProperties.setAltColor(color);
                    continue;
                }
                if (key.equals("midcolor")) {
                    Color color = ColorUtilities.stringToColor(value);
                    trackProperties.setMidColor(color);
                    continue;
                }
                if (key.equals("autoscale")) {
                    boolean autoscale = value.equals("on");
                    trackProperties.setAutoScale(autoscale);
                    continue;
                }
                if (key.equals("maxheightpixels")) {
                    try {
                        String[] maxDefMin = value.split(":");
                        if (maxDefMin.length >= 2) {
                            int defIDX = maxDefMin.length == 2 ? 0 : 1;
                            trackProperties.setHeight(Integer.parseInt(maxDefMin[defIDX].trim()));
                            trackProperties.setMinHeight(Integer.parseInt(maxDefMin[defIDX + 1].trim()));
                            continue;
                        }
                        trackProperties.setHeight(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e2) {
                        log.error("height must be an integer: " + value);
                    }
                    continue;
                }
                if ("height".equals(key)) {
                    try {
                        trackProperties.setHeight(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e3) {
                        log.error("height must be an integer: " + value);
                    }
                    continue;
                }
                if (key.equals("url")) {
                    trackProperties.setUrl(value);
                    continue;
                }
                if (key.equals("graphtype")) {
                    if (value.equals("bar")) {
                        trackProperties.setRendererClass(BarChartRenderer.class);
                        continue;
                    }
                    if (value.equals("points")) {
                        trackProperties.setRendererClass(PointsRenderer.class);
                        trackProperties.setWindowingFunction(WindowFunction.none);
                        continue;
                    }
                    if (value.equals("line")) {
                        trackProperties.setRendererClass(LineplotRenderer.class);
                        continue;
                    }
                    if (value.equals("heatmap")) {
                        trackProperties.setRendererClass(HeatmapRenderer.class);
                        continue;
                    }
                    if (value.equals("junctions")) {
                        trackProperties.setRendererClass(SpliceJunctionRenderer.class);
                        continue;
                    }
                    if (value.equals("genotype")) {
                        trackProperties.setRendererClass(GenotypeRenderer.class);
                        continue;
                    }
                    if (!"arc".equals(value)) continue;
                    trackProperties.setRendererClass(ArcRenderer.class);
                    continue;
                }
                if (key.toLowerCase().equals("viewlimits")) {
                    String[] limits = value.split(":");
                    if (limits.length != 2) continue;
                    try {
                        float min = Float.parseFloat(limits[0].trim());
                        float max = Float.parseFloat(limits[1].trim());
                        trackProperties.setMinValue(min);
                        trackProperties.setMaxValue(max);
                    }
                    catch (NumberFormatException e4) {
                        log.error("viewLimits values must be numeric: " + value);
                    }
                    continue;
                }
                if (key.equals("midrange")) {
                    String[] limits = value.split(":");
                    if (limits.length != 2) continue;
                    try {
                        float from = Float.parseFloat(limits[0].trim());
                        float to = Float.parseFloat(limits[1].trim());
                        trackProperties.setNeutralFromValue(from);
                        trackProperties.setNeutralToValue(to);
                    }
                    catch (NumberFormatException e5) {
                        log.error("midrange values must be numeric: " + value);
                    }
                    continue;
                }
                if (key.equals("ylinemark")) {
                    try {
                        float yLine = Float.parseFloat(value);
                        trackProperties.setyLine(yLine);
                    }
                    catch (NumberFormatException e6) {
                        log.error("Number format exception in track line (ylinemark): " + nextLine);
                    }
                    continue;
                }
                if (key.equals("ylineonoff")) {
                    trackProperties.setDrawYLine(value.equals("on"));
                    continue;
                }
                if (key.equals("windowingfunction")) {
                    WindowFunction wf = WindowFunction.getWindowFunction(value);
                    trackProperties.setWindowingFunction(wf);
                    continue;
                }
                if (key.equals("maxfeaturewindow") || key.equals("featurevisibilitywindow") || key.equals("visibilitywindow")) {
                    try {
                        int windowSize = Integer.parseInt(value);
                        trackProperties.setFeatureVisibilityWindow(windowSize);
                    }
                    catch (NumberFormatException e7) {
                        log.error(key + " must be numeric: " + nextLine);
                    }
                    continue;
                }
                if (key.equals("scaletype")) {
                    if (!value.equals("log")) continue;
                    trackProperties.setLogScale(true);
                    continue;
                }
                if (key.equals("gfftags")) {
                    boolean gffTags = !value.equals("0") && !valueLowerCase.equals("off");
                    trackProperties.setGffTags(gffTags);
                    continue;
                }
                if (key.equals("sortable")) {
                    boolean sortable = value.equals("1") || valueLowerCase.equals("true");
                    trackProperties.setSortable(sortable);
                    continue;
                }
                if (key.equals("alternateexoncolor")) {
                    trackProperties.setAlternateExonColor(valueLowerCase.equals("on") || value.equals("1"));
                    continue;
                }
                if (key.equals("visibility")) {
                    if (valueLowerCase.equals("1") || valueLowerCase.equals("dense") || valueLowerCase.equals("collapsed")) {
                        trackProperties.setDisplayMode(Track.DisplayMode.COLLAPSED);
                        continue;
                    }
                    if (valueLowerCase.equals("2") || valueLowerCase.equals("3") || valueLowerCase.equals("pack") || valueLowerCase.equals("expanded")) {
                        trackProperties.setDisplayMode(Track.DisplayMode.EXPANDED);
                        continue;
                    }
                    if (!valueLowerCase.equals("4") && !valueLowerCase.equals("squish") && !valueLowerCase.equals("squished")) continue;
                    trackProperties.setDisplayMode(Track.DisplayMode.SQUISHED);
                    continue;
                }
                if (key.equals("genome") || key.equals("db")) {
                    trackProperties.setGenome(value);
                    continue;
                }
                if (key.equals("bigdataurl") || key.equals("dataurl")) {
                    trackProperties.setDataURL(value);
                    continue;
                }
                if (key.equals("indexurl")) {
                    trackProperties.setIndexURL(value);
                    continue;
                }
                if (key.equals("coverageurl")) {
                    trackProperties.setCoverageURL(value);
                    continue;
                }
                if (!key.equals("meta")) continue;
                trackProperties.setMetaData(value);
            }
        }
        catch (Exception exception) {
            MessageUtils.showMessage("Error parsing track line: " + nextLine + " (" + exception.getMessage() + ")");
        }
        return foundProperties;
    }

    public static boolean pathExists(String covPath) {
        if (covPath == null) {
            return false;
        }
        try {
            return new File(covPath).exists() || HttpUtils.isRemoteURL(covPath) && HttpUtils.getInstance().resourceAvailable(new URL(covPath));
        }
        catch (MalformedURLException e2) {
            log.error(e2.getMessage(), e2);
            return false;
        }
    }

    public static String getIGVExtension(String path) {
        int idx;
        if (path.endsWith(".gz")) {
            path = path.substring(0, path.length() - 3);
        }
        if (path.endsWith(".txt") || path.endsWith(".xls")) {
            path = path.substring(0, path.length() - 4);
        }
        return (idx = path.lastIndexOf(46)) < 0 ? path : path.substring(idx + 1, path.length());
    }
}

