/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentBlockImpl;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SpliceGap;
import org.broad.igv.track.WindowFunction;

public abstract class SAMAlignment
implements Alignment {
    private static Logger log = Logger.getLogger(SAMAlignment.class);
    public static final char DELETE_CHAR = '-';
    public static final char SKIP_CHAR = '=';
    public static final char MATCH = 'M';
    public static final char PERFECT_MATCH = '=';
    public static final char MISMATCH = 'X';
    public static final char INSERTION = 'I';
    public static final char DELETION = 'D';
    public static final char SKIPPED_REGION = 'N';
    public static final char SOFT_CLIP = 'S';
    public static final char HARD_CLIP = 'H';
    public static final char PADDING = 'P';
    public static final char ZERO_GAP = 'O';
    public static final char UNKNOWN = '\u0000';
    public static final String REDUCE_READS_TAG = "RR";
    protected static final char[] NT2COMP = new char[]{'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'T', 'N', 'G', 'N', 'N', 'N', 'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'A', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'T', 'N', 'G', 'N', 'N', 'N', 'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'A', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N'};
    private static final String FLOW_SIGNAL_TAG = "ZF";
    protected int alignmentStart;
    protected int alignmentEnd;
    String chr;
    protected int start;
    protected int end;
    protected Color ycColor = null;
    ReadMate mate;
    public AlignmentBlockImpl[] alignmentBlocks;
    public AlignmentBlockImpl[] insertions;
    List<Gap> gaps;
    char[] gapTypes;
    protected String mateSequence = null;
    protected String pairOrientation = "";
    private Strand firstOfPairStrand;
    private Strand secondOfPairStrand;

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    public String getDescription() {
        return this.getReadName();
    }

    @Override
    public ReadMate getMate() {
        return this.mate;
    }

    @Override
    public Color getYcColor() {
        return this.ycColor;
    }

    @Override
    public abstract String getReadName();

    @Override
    public abstract int getMappingQuality();

    @Override
    public abstract int getInferredInsertSize();

    @Override
    public abstract String getCigarString();

    public abstract int getReadLength();

    @Override
    public abstract String getReadSequence();

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return this.alignmentBlocks;
    }

    public AlignmentBlockImpl[] getInsertions() {
        return this.insertions;
    }

    @Override
    public abstract boolean isNegativeStrand();

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public byte getBase(double position) {
        int basePosition = (int)position;
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte base = block.getBase(offset);
            return base;
        }
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        int basePosition = (int)position;
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte qual = block.getQuality(offset);
            return qual;
        }
        return 0;
    }

    protected void setPairStrands() {
        if (this.isPaired()) {
            ReadMate mate;
            this.firstOfPairStrand = this.isFirstOfPair() ? this.getReadStrand() : ((mate = this.getMate()) != null && mate.isMapped() ? mate.getStrand() : Strand.NONE);
            this.secondOfPairStrand = this.isSecondOfPair() ? (this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : ((mate = this.getMate()) != null && mate.isMapped() && this.isProperPair() ? (mate.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : Strand.NONE);
        } else {
            this.firstOfPairStrand = this.getReadStrand();
            this.secondOfPairStrand = Strand.NONE;
        }
    }

    private static boolean operatorIsMatch(boolean showSoftClipped, char operator) {
        return operator == 'M' || operator == '=' || operator == 'X' || showSoftClipped && operator == 'S';
    }

    protected void createAlignmentBlocks(String cigarString, byte[] readBases, byte[] readBaseQualities) {
        if (cigarString.equals("*")) {
            this.alignmentBlocks = new AlignmentBlockImpl[1];
            this.alignmentBlocks[0] = new AlignmentBlockImpl(this.getStart(), readBases, readBaseQualities);
            return;
        }
        List<CigarOperator> operators = SAMAlignment.buildOperators(cigarString);
        boolean showSoftClipped = PreferencesManager.getPreferences().getAsBoolean("SAM.SHOW_SOFT_CLIPPED");
        int nInsertions = 0;
        int nBlocks = 0;
        boolean firstOperator = true;
        int softClippedBaseCount = 0;
        int nGaps = 0;
        int nRealGaps = 0;
        char prevOp = '\u0000';
        for (CigarOperator operator : operators) {
            char op = operator.operator;
            if (op == 'H') continue;
            int nBases = operator.nBases;
            if (SAMAlignment.operatorIsMatch(showSoftClipped, op)) {
                ++nBlocks;
                if (SAMAlignment.operatorIsMatch(showSoftClipped, prevOp)) {
                    ++nGaps;
                }
            } else if (op == 'D' || op == 'N') {
                ++nGaps;
                ++nRealGaps;
            } else if (op == 'I') {
                ++nInsertions;
                ++nGaps;
            }
            if (firstOperator && op == 'S') {
                softClippedBaseCount += nBases;
            }
            if (op != 'S') {
                firstOperator = false;
            }
            prevOp = op;
        }
        this.alignmentBlocks = new AlignmentBlockImpl[nBlocks];
        this.insertions = new AlignmentBlockImpl[nInsertions];
        if (nGaps > 0) {
            this.gapTypes = new char[nGaps];
        }
        if (nRealGaps > 0) {
            this.gaps = new ArrayList<Gap>();
        }
        if (showSoftClipped) {
            this.start -= softClippedBaseCount;
        }
        int fromIdx = showSoftClipped ? 0 : softClippedBaseCount;
        int blockStart = this.start;
        int blockIdx = 0;
        int insertionIdx = 0;
        int gapIdx = 0;
        int padding = 0;
        prevOp = '\u0000';
        for (int i2 = 0; i2 < operators.size(); ++i2) {
            CigarOperator op = operators.get(i2);
            try {
                AlignmentBlockImpl block;
                if (op.operator == 'H') continue;
                if (SAMAlignment.operatorIsMatch(showSoftClipped, op.operator)) {
                    block = SAMAlignment.buildAlignmentBlock(readBases, readBaseQualities, blockStart, fromIdx, op.nBases, true);
                    if (op.operator == 'S') {
                        block.setSoftClipped(true);
                    }
                    this.alignmentBlocks[blockIdx++] = block;
                    fromIdx += op.nBases;
                    blockStart += op.nBases;
                    if (SAMAlignment.operatorIsMatch(showSoftClipped, prevOp)) {
                        this.gapTypes[gapIdx++] = 79;
                    }
                } else if (op.operator == 'D') {
                    this.gaps.add(new Gap(blockStart, op.nBases, op.operator));
                    blockStart += op.nBases;
                    this.gapTypes[gapIdx++] = op.operator;
                } else if (op.operator == 'N') {
                    int flankingLeft = 0;
                    int flankingRight = 0;
                    if (i2 > 0) {
                        flankingLeft = operators.get((int)(i2 - 1)).nBases;
                    }
                    if (i2 < operators.size() - 1) {
                        flankingRight = operators.get((int)(i2 + 1)).nBases;
                    }
                    this.gaps.add(new SpliceGap(blockStart, op.nBases, op.operator, flankingLeft, flankingRight));
                    blockStart += op.nBases;
                    this.gapTypes[gapIdx++] = op.operator;
                } else if (op.operator == 'I') {
                    this.gapTypes[gapIdx++] = 79;
                    block = SAMAlignment.buildAlignmentBlock(readBases, readBaseQualities, blockStart, fromIdx, op.nBases, false);
                    block.setPadding(padding);
                    this.insertions[insertionIdx++] = block;
                    fromIdx += op.nBases;
                    padding = 0;
                } else if (op.operator == 'P') {
                    padding += op.nBases;
                }
            }
            catch (Exception e2) {
                log.error("Error processing CIGAR string", e2);
            }
            prevOp = op.operator;
        }
        if (showSoftClipped && operators.size() > 0) {
            CigarOperator last = operators.get(operators.size() - 1);
            if (last.operator == 'S') {
                this.end += last.nBases;
            }
        }
    }

    public static List<CigarOperator> buildOperators(String cigarString) {
        ArrayList<CigarOperator> operators = new ArrayList<CigarOperator>();
        StringBuilder buffer = new StringBuilder(4);
        CigarOperator prevOp = null;
        for (int i2 = 0; i2 < cigarString.length(); ++i2) {
            char next = cigarString.charAt(i2);
            if (Character.isDigit(next)) {
                buffer.append(next);
                continue;
            }
            char op = next;
            int nBases = Integer.parseInt(buffer.toString());
            buffer.setLength(0);
            if (prevOp != null && prevOp.operator == op) {
                prevOp.nBases += nBases;
                continue;
            }
            prevOp = new CigarOperator(nBases, op);
            operators.add(prevOp);
        }
        return operators;
    }

    private static AlignmentBlockImpl buildAlignmentBlock(byte[] readBases, byte[] readBaseQualities, int blockStart, int fromIdx, int nBases, boolean checkNBasesAvailable) {
        byte[] blockBases = new byte[nBases];
        byte[] blockQualities = new byte[nBases];
        int nBasesAvailable = nBases;
        if (checkNBasesAvailable) {
            nBasesAvailable = readBases.length - fromIdx;
        }
        if (readBases == null || readBases.length == 0) {
            Arrays.fill(blockBases, (byte)61);
        } else if (nBasesAvailable < nBases) {
            Arrays.fill(blockBases, (byte)63);
        } else {
            System.arraycopy(readBases, fromIdx, blockBases, 0, nBases);
        }
        nBasesAvailable = nBases;
        if (checkNBasesAvailable) {
            nBasesAvailable = readBaseQualities.length - fromIdx;
        }
        if (readBaseQualities == null || readBaseQualities.length == 0 || nBasesAvailable < nBases) {
            Arrays.fill(blockQualities, (byte)126);
        } else {
            System.arraycopy(readBaseQualities, fromIdx, blockQualities, 0, nBases);
        }
        AlignmentBlockImpl block = new AlignmentBlockImpl(blockStart, blockBases, blockQualities);
        return block;
    }

    @Override
    public String getClipboardString(double location, int mouseX) {
        return this.getValueStringImpl(location, mouseX, false);
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        return this.getValueStringImpl(position, mouseX, true);
    }

    private String getValueStringImpl(double position, int mouseX, boolean truncate) {
        String attributeString;
        Object suppAlignment;
        String readGroup;
        String library;
        int basePosition = (int)position;
        StringBuffer buf = new StringBuffer();
        if (this.insertions != null) {
            for (AlignmentBlockImpl block : this.insertions) {
                if (!block.containsPixel(mouseX)) continue;
                byte[] bases = block.getBases();
                if (bases == null) {
                    buf.append("Insertion: " + block.getLength() + " bases");
                } else if (bases.length < 50) {
                    buf.append("Insertion (" + bases.length + " bases): " + new String(bases));
                } else {
                    int len = bases.length;
                    buf.append("Insertion (" + bases.length + " bases): " + new String(Arrays.copyOfRange(bases, 0, 25)) + "..." + new String(Arrays.copyOfRange(bases, len - 25, len)));
                }
                return buf.toString();
            }
        }
        buf.append("Read name = " + this.getReadName() + "<br>");
        String sample = this.getSample();
        if (sample != null) {
            buf.append("Sample = " + sample + "<br>");
        }
        if ((library = this.getLibrary()) != null) {
            buf.append("Library = " + library + "<br>");
        }
        if ((readGroup = this.getReadGroup()) != null) {
            buf.append("Read group = " + readGroup + "<br>");
        }
        buf.append("Read length = " + Globals.DECIMAL_FORMAT.format(this.getReadLength()) + "bp<br>");
        String cigarString = this.getCigarString();
        int maxCigarStringLength = 60;
        if (cigarString.length() > maxCigarStringLength) {
            Matcher lMatcher = Pattern.compile("^(.{1," + Integer.toString(maxCigarStringLength / 2 - 1) + "}[A-Z])").matcher(cigarString);
            Matcher rMatcher = Pattern.compile("[A-Z](.{1," + Integer.toString(maxCigarStringLength / 2) + "})$").matcher(cigarString);
            cigarString = (lMatcher.find() ? lMatcher.group(1) : "") + "..." + (rMatcher.find() ? rMatcher.group(1) : "");
        }
        buf.append("----------------------<br>");
        buf.append("Mapping = " + (this.isPrimary() ? (this.isSupplementary() ? "Supplementary" : "Primary") : "Secondary") + (this.isDuplicate() ? " Duplicate" : "") + (this.isVendorFailedRead() ? " Failed QC" : "") + " @ MAPQ " + Globals.DECIMAL_FORMAT.format(this.getMappingQuality()) + "<br>");
        buf.append("Reference span = " + this.getChr() + ":" + Globals.DECIMAL_FORMAT.format(this.getAlignmentStart() + 1) + "-" + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd()) + " (" + (this.isNegativeStrand() ? "-" : "+") + ") = " + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd() - this.getAlignmentStart()) + "bp<br>");
        buf.append("Cigar = " + cigarString + "<br>");
        buf.append("Clipping = ");
        Matcher lclipMatcher = Pattern.compile("^(([0-9]+)H)?(([0-9]+)S)?").matcher(cigarString);
        Matcher rclipMatcher = Pattern.compile("(([0-9]+)S)?(([0-9]+)H)?$").matcher(cigarString);
        int lclipHard = 0;
        int lclipSoft = 0;
        int rclipHard = 0;
        int rclipSoft = 0;
        if (lclipMatcher.find()) {
            lclipHard = lclipMatcher.group(2) == null ? 0 : Integer.parseInt(lclipMatcher.group(2), 10);
            int n2 = lclipSoft = lclipMatcher.group(4) == null ? 0 : Integer.parseInt(lclipMatcher.group(4), 10);
        }
        if (rclipMatcher.find()) {
            rclipHard = rclipMatcher.group(4) == null ? 0 : Integer.parseInt(rclipMatcher.group(4), 10);
            int n3 = rclipSoft = rclipMatcher.group(2) == null ? 0 : Integer.parseInt(rclipMatcher.group(2), 10);
        }
        if (lclipHard + lclipSoft + rclipHard + rclipSoft == 0) {
            buf.append("None");
        } else {
            if (lclipHard + lclipSoft > 0) {
                buf.append("Left");
                if (lclipHard > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(lclipHard) + " hard");
                }
                if (lclipSoft > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(lclipSoft) + " soft");
                }
            }
            if (rclipHard + rclipSoft > 0) {
                buf.append((lclipHard + lclipSoft > 0 ? "; " : "") + "Right");
                if (rclipHard > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(rclipHard) + " hard");
                }
                if (rclipSoft > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(rclipSoft) + " soft");
                }
            }
        }
        buf.append("<br>");
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (this.isPaired()) {
            buf.append("----------------------<br>");
            buf.append("Mate is mapped = " + (this.getMate().isMapped() ? "yes" : "no") + "<br>");
            if (this.getMate().isMapped()) {
                buf.append("Mate start = " + this.getMate().positionString() + "<br>");
                if (this.getChr().equals(this.getMate().getChr())) {
                    buf.append("Insert size = " + this.getInferredInsertSize() + "<br>");
                }
            }
            if (this.isFirstOfPair()) {
                buf.append("First in pair<br>");
            }
            if (this.isSecondOfPair()) {
                buf.append("Second in pair<br>");
            }
            if (this.getPairOrientation().length() > 0) {
                buf.append("Pair orientation = " + this.getPairOrientation() + "<br>");
            }
        }
        if ((suppAlignment = this.getAttribute("SA")) != null) {
            buf.append("----------------------<br>");
            buf.append(this.getSupplAlignmentString(suppAlignment.toString()));
            buf.append("<br>");
        }
        if ((attributeString = this.getAttributeString(truncate)) != null && attributeString.length() > 0) {
            buf.append("----------------------");
            buf.append(this.getAttributeString(truncate));
        }
        if (this.mateSequence != null) {
            buf.append("----------------------<br>");
            buf.append("Mate sequence: " + this.mateSequence);
        }
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            buf.append("<hr>");
            int offset = basePosition - block.getStart();
            byte base = block.getBase(offset);
            if (base == 0 && this.getReadSequence().equals("=") && !block.isSoftClipped() && genome != null) {
                base = genome.getReference(this.chr, basePosition);
            }
            byte quality = block.getQuality(offset);
            buf.append("Location = " + this.getChr() + ":" + Globals.DECIMAL_FORMAT.format(1L + (long)position) + "<br>");
            buf.append("Base = " + (char)base + " @ QV " + Globals.DECIMAL_FORMAT.format(quality) + "<br>");
            break;
        }
        return buf.toString();
    }

    private String getSupplAlignmentString(String sa) {
        String[] records;
        StringBuffer buf = new StringBuffer();
        buf.append("SupplementaryAlignments");
        for (String rec : records = Globals.semicolonPattern.split(sa)) {
            SupplementaryAlignment a2 = new SupplementaryAlignment(rec);
            buf.append("<br>" + a2.printString());
        }
        return buf.toString();
    }

    protected abstract String getAttributeString(boolean var1);

    @Override
    public abstract boolean isFirstOfPair();

    @Override
    public abstract boolean isSecondOfPair();

    @Override
    public abstract boolean isDuplicate();

    @Override
    public abstract boolean isMapped();

    @Override
    public abstract boolean isPaired();

    @Override
    public abstract boolean isProperPair();

    @Override
    public abstract boolean isSupplementary();

    @Override
    public abstract boolean isVendorFailedRead();

    @Override
    public abstract boolean isPrimary();

    @Override
    public abstract int getAlignmentStart();

    @Override
    public abstract int getAlignmentEnd();

    @Override
    public float getScore() {
        return this.getMappingQuality();
    }

    public void setMate(ReadMate mate) {
        this.mate = mate;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public abstract Object getAttribute(String var1);

    @Override
    public List<Gap> getGaps() {
        return this.gaps;
    }

    @Override
    public void finish() {
    }

    @Override
    public AlignmentBlock getInsertionAt(int position) {
        for (AlignmentBlockImpl block : this.insertions) {
            if (block.getStart() == position) {
                return block;
            }
            if (block.getStart() <= position) continue;
            return null;
        }
        return null;
    }

    @Override
    public Strand getReadStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public String getPairOrientation() {
        return this.pairOrientation;
    }

    @Override
    public void setMateSequence(String sequence) {
        this.mateSequence = sequence;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.firstOfPairStrand;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return this.secondOfPairStrand;
    }

    public int getFlowSignalsStart() {
        Object attribute = this.getAttribute(FLOW_SIGNAL_TAG);
        int toRet = -1;
        if (attribute != null && attribute instanceof Integer) {
            toRet = (Integer)attribute;
        }
        return toRet;
    }

    protected void setPairOrientation() {
        if (this.isPaired() && this.isMapped() && this.mate != null && this.mate.isMapped() && this.getChr().equals(this.mate.getChr())) {
            int s1 = this.isNegativeStrand() ? 82 : 70;
            int s2 = this.mate.isNegativeStrand() ? 82 : 70;
            int o1 = 32;
            int o2 = 32;
            if (this.isFirstOfPair()) {
                o1 = 49;
                o2 = 50;
            } else if (this.isSecondOfPair()) {
                o1 = 50;
                o2 = 49;
            }
            char[] tmp = new char[4];
            int isize = this.getInferredInsertSize();
            int estReadLen = this.getAlignmentEnd() - this.getAlignmentStart();
            if (isize == 0) {
                int estMateEnd = this.getAlignmentStart() < this.mate.getStart() ? this.getMate().getStart() + estReadLen : this.mate.getStart() - estReadLen;
                isize = estMateEnd - this.getAlignmentStart();
            }
            if (isize > 0) {
                tmp[0] = s1;
                tmp[1] = o1;
                tmp[2] = s2;
                tmp[3] = o2;
            } else {
                tmp[2] = s1;
                tmp[3] = o1;
                tmp[0] = s2;
                tmp[1] = o2;
            }
            this.pairOrientation = new String(tmp);
        }
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public String getSynopsisString() {
        char st = this.isNegativeStrand() ? (char)'-' : '+';
        Object nm = this.getAttribute("NM");
        String numMismatches = nm == null ? "?" : nm.toString();
        int lenOnRef = this.getAlignmentEnd() - this.getAlignmentStart();
        int[] clipping = SAMAlignment.getClipping(this.getCigarString());
        String clippingString = "";
        if (clipping[0] + clipping[1] + clipping[2] + clipping[3] > 0) {
            if (clipping[0] > 0) {
                clippingString = clippingString + clipping[0] + "H";
            }
            if (clipping[1] > 0) {
                clippingString = clippingString + clipping[1] + "S";
            }
            clippingString = clippingString + " ... ";
            if (clipping[3] > 0) {
                clippingString = clippingString + clipping[3] + "S";
            }
            if (clipping[2] > 0) {
                clippingString = clippingString + clipping[2] + "H";
            }
        }
        return this.chr + ":" + Globals.DECIMAL_FORMAT.format(this.getAlignmentStart()) + "-" + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd()) + " (" + st + ") = " + Globals.DECIMAL_FORMAT.format(lenOnRef) + "BP  @MAPQ=" + this.getMappingQuality() + " NM=" + numMismatches + " CLIPPING=" + clippingString;
    }

    public static int[] getClipping(String cigarString) {
        Matcher lclipMatcher = Pattern.compile("^(([0-9]+)H)?(([0-9]+)S)?").matcher(cigarString);
        Matcher rclipMatcher = Pattern.compile("(([0-9]+)S)?(([0-9]+)H)?$").matcher(cigarString);
        int lclipHard = 0;
        int lclipSoft = 0;
        int rclipHard = 0;
        int rclipSoft = 0;
        if (lclipMatcher.find()) {
            lclipHard = lclipMatcher.group(2) == null ? 0 : Integer.parseInt(lclipMatcher.group(2), 10);
            int n2 = lclipSoft = lclipMatcher.group(4) == null ? 0 : Integer.parseInt(lclipMatcher.group(4), 10);
        }
        if (rclipMatcher.find()) {
            rclipHard = rclipMatcher.group(4) == null ? 0 : Integer.parseInt(rclipMatcher.group(4), 10);
            rclipSoft = rclipMatcher.group(2) == null ? 0 : Integer.parseInt(rclipMatcher.group(2), 10);
        }
        return new int[]{lclipHard, lclipSoft, rclipHard, rclipSoft};
    }

    public static class SupplementaryAlignment {
        public String chr;
        public int start;
        public char strand;
        public int mapQ;
        public int numMismatches;
        public int lenOnRef;

        public SupplementaryAlignment(String rec) {
            String[] tokens = Globals.commaPattern.split(rec);
            this.chr = tokens[0];
            this.start = Integer.parseInt(tokens[1]);
            this.strand = tokens[2].charAt(0);
            this.mapQ = Integer.parseInt(tokens[4]);
            this.numMismatches = Integer.parseInt(tokens[5]);
            this.lenOnRef = this.computeLengthOnReference(tokens[3]);
        }

        public String printString() {
            return this.chr + ":" + Globals.DECIMAL_FORMAT.format(this.start) + "-" + Globals.DECIMAL_FORMAT.format(this.start + this.lenOnRef) + " (" + this.strand + ") = " + Globals.DECIMAL_FORMAT.format(this.lenOnRef) + "bp  @MAPQ " + this.mapQ + " NM" + this.numMismatches;
        }

        int computeLengthOnReference(String cigarString) {
            int len = 0;
            StringBuffer buf = new StringBuffer();
            for (char c2 : cigarString.toCharArray()) {
                if (c2 > '/' && c2 < ':') {
                    buf.append(c2);
                    continue;
                }
                switch (c2) {
                    case '=': 
                    case 'D': 
                    case 'M': 
                    case 'N': 
                    case 'X': {
                        len += Integer.parseInt(buf.toString());
                    }
                }
                buf.setLength(0);
            }
            return len;
        }
    }

    static class CigarOperator {
        int nBases;
        char operator;

        public CigarOperator(int nBases, char operator) {
            this.nBases = nBases;
            this.operator = operator;
        }
    }
}

