/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.broad.igv.sam.AlignmentBlock;

public class AlignmentBlockImpl
implements AlignmentBlock {
    private int start;
    private byte[] bases;
    private int basesLength = -1;
    public byte[] qualities;
    private boolean softClipped = false;
    private int pixelStart;
    private int pixelEnd;
    private int padding = 0;

    public AlignmentBlockImpl(int start, byte[] bases, byte[] qualities) {
        this.start = start;
        this.bases = bases;
        this.basesLength = bases.length;
        this.qualities = qualities;
    }

    @Override
    public void setPixelRange(int s2, int e2) {
        this.pixelStart = s2;
        this.pixelEnd = e2;
    }

    @Override
    public boolean containsPixel(int x2) {
        return x2 >= this.pixelStart && x2 <= this.pixelEnd;
    }

    @Override
    public int getPadding() {
        return this.padding;
    }

    @Override
    public boolean contains(int position) {
        int offset = position - this.start;
        return offset >= 0 && offset < this.getLength();
    }

    @Override
    public int getLength() {
        return this.basesLength + this.padding;
    }

    @Override
    public byte getBase(int offset) {
        return this.bases != null && offset < this.bases.length ? this.bases[offset] : (byte)0;
    }

    @Override
    public byte[] getBases() {
        return this.bases;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public byte getQuality(int offset) {
        return this.qualities == null || offset >= this.qualities.length ? (byte)126 : this.qualities[offset];
    }

    @Override
    public byte[] getQualities() {
        return this.qualities;
    }

    @Override
    public int getEnd() {
        return this.start + this.getLength();
    }

    @Override
    public boolean isSoftClipped() {
        return this.softClipped;
    }

    public void setSoftClipped(boolean softClipped) {
        this.softClipped = softClipped;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[block ");
        sb.append(this.isSoftClipped() ? "softClipped " : " ");
        sb.append(this.getStart());
        sb.append("-");
        sb.append(this.getEnd());
        sb.append(" ");
        for (int i2 = 0; i2 < this.bases.length; ++i2) {
            sb.append((char)this.bases[i2]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean hasBases() {
        return this.bases != null;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }
}

