/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.fasta;

import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;
import org.broad.igv.util.LittleEndianInputStream;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class FastaBlockCompressedSequence
extends FastaIndexedSequence {
    Mapping[] gziMappings;
    Mapping zeroMapping = new Mapping(0L, 0L);

    public FastaBlockCompressedSequence(String path) throws IOException {
        super(path);
        String gziPath = path + ".gzi";
        this.readGziMappings(gziPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBytes(long posStart, long posEnd) throws IOException {
        Mapping m1 = this.findBlockContaining(posStart);
        int d1 = (int)(posStart - m1.uncompressedOffset);
        long vp1 = m1.compressedOffset << 16 | (long)d1;
        try (SeekableStream ss = null;){
            int nBytes = (int)(posEnd - posStart);
            int bufferSize = Math.max(512000, nBytes / 8);
            ss = new SeekableBufferedStream(IGVSeekableStreamFactory.getInstance().getStreamFor(this.path), bufferSize);
            BlockCompressedInputStream bis = new BlockCompressedInputStream(ss);
            byte[] bytes = new byte[nBytes];
            bis.seek(vp1);
            this.readFully(bytes, bis);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    protected Mapping findBlockContaining(long uoffset) {
        int ilo = 0;
        int ihi = this.gziMappings.length - 1;
        while (ilo <= ihi) {
            int i2 = (ilo + ihi) / 2;
            Mapping mapping = this.gziMappings[i2];
            if (uoffset < mapping.uncompressedOffset) {
                ihi = i2 - 1;
                continue;
            }
            if (uoffset < mapping.uncompressedOffset) break;
            ilo = i2 + 1;
        }
        return ilo == 0 ? this.zeroMapping : this.gziMappings[ilo - 1];
    }

    private void readGziMappings(String gziPath) throws IOException {
        InputStream is = null;
        LittleEndianInputStream dis = null;
        is = ParsingUtils.openInputStream(gziPath);
        dis = new LittleEndianInputStream(new BufferedInputStream(is));
        int nEntries = (int)dis.readLong();
        this.gziMappings = new Mapping[nEntries];
        for (int i2 = 0; i2 < nEntries; ++i2) {
            this.gziMappings[i2] = new Mapping(dis.readLong(), dis.readLong());
        }
    }

    private void readFully(byte[] b2, InputStream is) throws IOException {
        int count;
        int len = b2.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n2 = 0; n2 < len; n2 += count) {
            count = is.read(b2, n2, len - n2);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static class Mapping {
        long compressedOffset;
        long uncompressedOffset;

        public Mapping(long compressedOffset, long uncompressedOffset) {
            this.compressedOffset = compressedOffset;
            this.uncompressedOffset = uncompressedOffset;
        }
    }
}

