/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.commandbar.GenomeSelectionDialog;
import org.broad.igv.ui.commandbar.JList7;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;

public class ManageGenomesDialog
extends JDialog {
    private static Logger log = Logger.getLogger(ManageGenomesDialog.class);
    private List<GenomeListItem> allListItems;
    private List<GenomeListItem> removedValuesList;
    private List<GenomeListItem> addValuesList;
    private boolean haveLocalSequence = false;
    private static final String LOCAL_SEQUENCE_CHAR = "*";
    private JPanel dialogPane;
    private JTextArea label1;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JList7<GenomeListItem> genomeList;
    private JLabel label2;
    private JPanel panel1;
    private JPanel addRemBar;
    private JButton addButton;
    private JButton removeButton;
    private JSeparator separator1;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public ManageGenomesDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.initData();
        this.genomeList.setCellRenderer(new GenomeCellRenderer());
    }

    private void initData() {
        this.allListItems = new ArrayList<GenomeListItem>(GenomeListManager.getInstance().getGenomeListItems());
        this.removedValuesList = new ArrayList<GenomeListItem>();
        this.addValuesList = new ArrayList<GenomeListItem>();
        for (GenomeListItem item : this.allListItems) {
            if (GenomeManager.getInstance().getLocalFasta(item.getId()) == null) continue;
            this.haveLocalSequence = true;
            break;
        }
        this.buildList();
        this.genomeList.setTransferHandler(new SimpleTransferHandler());
        this.addButton.setEnabled(!GenomeManager.getInstance().isServerGenomeListUnreachable());
        this.label2.setVisible(this.haveLocalSequence);
    }

    private void buildList() {
        this.genomeList.setListData((Object[])this.allListItems.toArray());
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    private void saveButtonActionPerformed(ActionEvent event) {
        Runnable runnable = () -> {
            List<GenomeListItem> addValuesList;
            List<GenomeListItem> removedValuesList = this.getRemovedValuesList();
            if (removedValuesList != null && !removedValuesList.isEmpty()) {
                try {
                    this.deleteDownloadedGenomes(removedValuesList);
                }
                catch (IOException e2) {
                    log.error("Error deleting genome files", e2);
                    MessageUtils.showErrorMessage("Error deleting genome files", e2);
                }
                String lastGenomeKey = PreferencesManager.getPreferences().get("DEFAULT_GENOME_KEY");
                for (GenomeListItem item : removedValuesList) {
                    if (!lastGenomeKey.equals(item.getId())) continue;
                    PreferencesManager.getPreferences().remove("DEFAULT_GENOME_KEY");
                    break;
                }
            }
            if ((addValuesList = this.getAddValuesList()).size() > 0) {
                GenomeManager.getInstance().downloadGenomes(addValuesList, false);
                GenomeListManager.getInstance().addServerGenomeItems(addValuesList);
            }
            if (removedValuesList.size() > 0 || addValuesList.size() > 0) {
                IGVEventBus.getInstance().post(new GenomeResetEvent());
            }
            if (addValuesList.size() > 0) {
                try {
                    GenomeManager.getInstance().loadGenomeById(addValuesList.get(0).getId());
                }
                catch (IOException e3) {
                    log.error("Error loading genome: " + addValuesList.get(0).getDisplayableName(), e3);
                }
            }
        };
        LongRunningTask.submit(runnable);
        this.setVisible(false);
    }

    public void deleteDownloadedGenomes(List<GenomeListItem> removedValuesList) throws IOException {
        for (GenomeListItem item : removedValuesList) {
            File localFasta;
            String loc = item.getPath();
            if (!HttpUtils.isRemoteURL(loc)) {
                File genFile = new File(loc);
                genFile.delete();
            }
            if ((localFasta = GenomeManager.getInstance().getLocalFasta(item.getId())) == null) continue;
            GenomeManager.getInstance().removeLocalFasta(item.getId());
            boolean d2 = MessageUtils.confirm("Delete local fasta file (" + localFasta.getName() + ")?");
            if (!d2) continue;
            localFasta.delete();
            new File(localFasta.getAbsolutePath() + ".fai").delete();
            new File(localFasta.getAbsolutePath() + ".gzi").delete();
        }
        GenomeListManager.getInstance().removeAllItems(removedValuesList);
    }

    private void removeSelected() {
        List<GenomeListItem> selectedValuesList = this.genomeList.getSelectedValuesList();
        this.removedValuesList.addAll(selectedValuesList);
        this.allListItems.removeAll(selectedValuesList);
        this.addValuesList.removeAll(selectedValuesList);
        this.buildList();
    }

    public List<GenomeListItem> getRemovedValuesList() {
        return this.removedValuesList;
    }

    public List<GenomeListItem> getAddValuesList() {
        return this.addValuesList;
    }

    private void genomeListKeyReleased(KeyEvent e2) {
        if (e2.getKeyCode() == 127 || e2.getKeyCode() == 8) {
            this.removeSelected();
        }
    }

    private void removeButtonActionPerformed(ActionEvent e2) {
        this.removeSelected();
    }

    private void addButtonActionPerformed(ActionEvent e2) {
        List<GenomeListItem> inputListItems = GenomeListManager.getInstance().getServerGenomeList();
        if (inputListItems == null) {
            IOException exc = new IOException("Unable to reach genome server");
            MessageUtils.showErrorMessage(exc.getMessage(), exc);
            return;
        }
        GenomeSelectionDialog dialog = new GenomeSelectionDialog(null, inputListItems, 2);
        dialog.setVisible(true);
        List<GenomeListItem> selectedValues = dialog.getSelectedValuesList();
        if (selectedValues != null) {
            this.addValuesList.addAll(selectedValues);
            this.allListItems.addAll(selectedValues);
            this.buildList();
        }
    }

    private int findItem(String text) {
        int index = 0;
        for (GenomeListItem item : this.allListItems) {
            if (item.getId().equals(text) || item.getDisplayableName().equals(text)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.label1 = new JTextArea();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.genomeList = new JList7();
        this.label2 = new JLabel();
        this.panel1 = new JPanel();
        this.addRemBar = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.separator1 = new JSeparator();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle("Manage Genome List");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(270, 400));
        this.dialogPane.setLayout(new BorderLayout());
        this.label1.setText("Drag and drop genomes to change their order in the genome list. \nSelect and press delete, or click \"Remove\", to remove them.");
        this.label1.setRows(2);
        this.label1.setEditable(false);
        this.label1.setBackground(UIManager.getColor("Button.background"));
        this.label1.setWrapStyleWord(true);
        this.label1.setLineWrap(true);
        this.dialogPane.add((Component)this.label1, "North");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.genomeList.setMaximumSize(new Dimension(39, 5000));
        this.genomeList.setDropMode(DropMode.INSERT);
        this.genomeList.setDragEnabled(true);
        this.genomeList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                ManageGenomesDialog.this.genomeListKeyReleased(e2);
            }
        });
        this.scrollPane1.setViewportView(this.genomeList);
        this.contentPanel.add(this.scrollPane1);
        this.label2.setText("Sequence on local machine");
        this.label2.setLabelFor(this.genomeList);
        this.label2.setAlignmentX(1.0f);
        this.label2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.label2.setPreferredSize(new Dimension(400, 16));
        this.label2.setMaximumSize(new Dimension(400, 16));
        this.label2.setMinimumSize(new Dimension(100, 16));
        this.label2.setText(LOCAL_SEQUENCE_CHAR + this.label2.getText());
        this.contentPanel.add(this.label2);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.panel1.setLayout(new BoxLayout(this.panel1, 1));
        this.addRemBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.addRemBar.setPreferredSize(new Dimension(196, 51));
        this.addRemBar.setMinimumSize(new Dimension(201, 51));
        this.addRemBar.setLayout(new FlowLayout(4, 1, 5));
        this.addButton.setText("Add From Server");
        this.addButton.addActionListener(e2 -> this.addButtonActionPerformed(e2));
        this.addRemBar.add(this.addButton);
        this.removeButton.setText("Remove");
        this.removeButton.setToolTipText("Remove selected genomes from list");
        this.removeButton.addActionListener(e2 -> this.removeButtonActionPerformed(e2));
        this.addRemBar.add(this.removeButton);
        this.panel1.add(this.addRemBar);
        this.panel1.add(this.separator1);
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setPreferredSize(new Dimension(196, 51));
        this.buttonBar.setLayout(new FlowLayout(4));
        this.okButton.setText("Save");
        this.okButton.setMaximumSize(new Dimension(93, 29));
        this.okButton.setMinimumSize(new Dimension(93, 29));
        this.okButton.setPreferredSize(new Dimension(93, 29));
        this.okButton.addActionListener(e2 -> this.saveButtonActionPerformed(e2));
        this.buttonBar.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(93, 29));
        this.cancelButton.setPreferredSize(new Dimension(93, 29));
        this.cancelButton.setMaximumSize(new Dimension(93, 29));
        this.cancelButton.addActionListener(e2 -> this.cancelButtonActionPerformed(e2));
        this.buttonBar.add(this.cancelButton);
        this.panel1.add(this.buttonBar);
        this.dialogPane.add((Component)this.panel1, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class GenomeCellRenderer
    implements ListCellRenderer {
        private GenomeCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = new JLabel(value.toString());
            GenomeListItem item = (GenomeListItem)value;
            String displayableName = item.getDisplayableName();
            comp.setToolTipText(item.getPath());
            if (isSelected) {
                comp.setBackground(ManageGenomesDialog.this.genomeList.getSelectionBackground());
                comp.setForeground(ManageGenomesDialog.this.genomeList.getSelectionForeground());
                comp.setOpaque(isSelected);
            }
            if (GenomeManager.getInstance().getLocalFasta(item.getId()) != null) {
                displayableName = displayableName + ManageGenomesDialog.LOCAL_SEQUENCE_CHAR;
            }
            comp.setText(displayableName);
            return comp;
        }
    }

    private class SimpleTransferHandler
    extends TransferHandler {
        private SimpleTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c2) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c2) {
            return new StringSelection(IGVPreferences.generateGenomeIdString(ManageGenomesDialog.this.genomeList.getSelectedValuesList()));
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            String[] genomeIds;
            if (!this.canImport(support)) {
                return false;
            }
            JList.DropLocation dropLocation = (JList.DropLocation)support.getDropLocation();
            int toIndex = dropLocation.getIndex();
            try {
                String genomeIdString = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                genomeIds = genomeIdString.split(";");
            }
            catch (UnsupportedFlavorException e2) {
                return false;
            }
            catch (IOException e3) {
                return false;
            }
            if (genomeIds == null || genomeIds.length == 0) {
                return false;
            }
            int numMoved = 0;
            for (String genomeId : genomeIds) {
                int fromIndex = ManageGenomesDialog.this.findItem(genomeId);
                if (fromIndex < 0 || fromIndex >= ManageGenomesDialog.this.allListItems.size() || fromIndex == toIndex) continue;
                if (toIndex > fromIndex) {
                    --toIndex;
                }
                GenomeListItem item = (GenomeListItem)ManageGenomesDialog.this.allListItems.remove(fromIndex);
                ManageGenomesDialog.this.allListItems.add(toIndex, item);
                ++numMoved;
                ++toIndex;
            }
            ManageGenomesDialog.this.buildList();
            return numMoved > 0;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            support.setShowDropLocation(true);
            return support.isDrop();
        }
    }
}

