/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import htsjdk.tribble.Feature;
import java.awt.Color;
import java.util.List;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.MultiMap;

public class UCSCSnpFeature
implements IGVFeature,
Feature {
    String chr;
    int start;
    int end;
    float score;
    Strand strand;
    String name;
    String observed;
    String molType;
    String snpClass;
    String function;
    String submitters;
    String alleles;
    String alleleFreqs;

    public UCSCSnpFeature(String chr, int start, int end, String[] tokens) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.name = tokens[4];
        float f2 = this.score = tokens[5].equals(".") ? 1000.0f : Float.parseFloat(tokens[5]);
        this.strand = tokens[6].equals("+") ? Strand.POSITIVE : (tokens[6].equals("-") ? Strand.NEGATIVE : Strand.NONE);
        this.observed = tokens[9];
        this.molType = tokens[10];
        this.snpClass = tokens[11];
        this.function = tokens[15];
        this.submitters = tokens[20];
        this.alleles = tokens[22];
        this.alleleFreqs = tokens[24];
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        StringBuffer desc = new StringBuffer();
        if (this.end - this.start > 1) {
            desc.append(this.chr + ":" + (this.start + 1) + "-" + this.end);
        } else {
            desc.append(this.chr + ":" + (this.start + 1));
        }
        desc.append("<br><b>Name:</b> " + this.name);
        desc.append("<br><b>Observed:</b> " + this.observed);
        desc.append("<br><b>Mol type:</b> " + this.molType);
        desc.append("<br><b>Class:</b> " + this.snpClass);
        desc.append("<br><b>Function:</b> " + this.function);
        desc.append("<br><b>Alleles:</b> " + this.alleles.replace(",", ", "));
        desc.append("<br><b>Allele freqs:</b> " + this.alleleFreqs.replace(",", ", "));
        desc.append("<br><b>Submitters:</b> " + this.submitters.replace(",", ", "));
        return desc.toString();
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public String getType() {
        return "SNP";
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    @Override
    public Strand getStrand() {
        return this.strand;
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    @Override
    public MultiMap<String, String> getAttributes() {
        return null;
    }

    @Override
    public boolean contains(IGVFeature feature) {
        if (feature == null) {
            return false;
        }
        if (!this.getChr().equals(feature.getChr()) || this.getStrand() != feature.getStrand()) {
            return false;
        }
        return feature.getStart() >= this.getStart() && feature.getEnd() <= this.getEnd();
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.start && location <= (double)this.end;
    }

    @Override
    public List<Exon> getExons() {
        return null;
    }

    @Override
    public Color getColor() {
        return Color.black;
    }

    @Override
    public String getURL() {
        return null;
    }
}

