/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.rnai;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.data.rnai.RNAIHairpinCache;
import org.broad.igv.data.rnai.RNAIHairpinValue;

public class RNAIHairpinParser {
    private static Logger log = Logger.getLogger(RNAIHairpinParser.class);
    private String filename;

    public RNAIHairpinParser(String filename) {
        this.filename = filename;
    }

    public void parse() {
        try (AsciiLineReader reader = null;){
            log.debug("Loading data for: " + this.filename);
            reader = new AsciiLineReader(new FileInputStream(this.filename));
            this.parseAttributes(reader);
            this.parseHeaderRow(reader);
            String nextLine = reader.readLine();
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                int nTokens;
                if (nextLine.startsWith("#") || (nTokens = (tokens = Globals.tabPattern.split(nextLine, -1)).length) <= 11) continue;
                try {
                    String batchId = new String(tokens[0].trim());
                    String hairpinName = new String(tokens[4].trim().toUpperCase());
                    float scoreMean = Float.NaN;
                    try {
                        scoreMean = Float.parseFloat(tokens[8]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    float scoreSTD = 0.0f;
                    try {
                        scoreSTD = Float.parseFloat(tokens[9]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String gene = new String(tokens[13].trim().toUpperCase());
                    RNAIHairpinValue score = new RNAIHairpinValue(hairpinName, scoreMean, scoreSTD);
                    String cond = tokens[2].trim();
                    if (cond.startsWith("*")) continue;
                    if (cond.equals("None") || cond.equals("Standard")) {
                        cond = "";
                    }
                    String batchCond = batchId + "_" + cond;
                    RNAIHairpinCache.getInstance().addHairpinScore(batchCond, gene, score);
                }
                catch (Exception ex) {
                    log.error("Skipping line: " + nextLine, ex);
                }
            }
        }
    }

    private void parseAttributes(AsciiLineReader reader) throws IOException {
    }

    private void parseHeaderRow(AsciiLineReader reader) throws IOException {
    }
}

