/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.util.FastMath;
import org.apache.commons.math.util.MathUtils;

public class MullerSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public MullerSolver(UnivariateRealFunction f2) {
        super(f2, 100, 1.0E-6);
    }

    @Deprecated
    public MullerSolver() {
        super(100, 1.0E-6);
    }

    @Deprecated
    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, min, max);
    }

    @Deprecated
    public double solve(double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, min, max, initial);
    }

    public double solve(int maxEval, UnivariateRealFunction f2, double min, double max, double initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f2, min, max, initial);
    }

    @Deprecated
    public double solve(UnivariateRealFunction f2, double min, double max, double initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        if (f2.value(min) == 0.0) {
            return min;
        }
        if (f2.value(max) == 0.0) {
            return max;
        }
        if (f2.value(initial) == 0.0) {
            return initial;
        }
        this.verifyBracketing(min, max, f2);
        this.verifySequence(min, initial, max);
        if (this.isBracketing(min, initial, f2)) {
            return this.solve(f2, min, initial);
        }
        return this.solve(f2, initial, max);
    }

    public double solve(int maxEval, UnivariateRealFunction f2, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f2, min, max);
    }

    @Deprecated
    public double solve(UnivariateRealFunction f2, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        double x0 = min;
        double y0 = f2.value(x0);
        double x2 = max;
        double y2 = f2.value(x2);
        double x1 = 0.5 * (x0 + x2);
        double y1 = f2.value(x1);
        if (y0 == 0.0) {
            return min;
        }
        if (y2 == 0.0) {
            return max;
        }
        this.verifyBracketing(min, max, f2);
        double oldx = Double.POSITIVE_INFINITY;
        for (int i2 = 1; i2 <= this.maximalIterationCount; ++i2) {
            boolean bisect;
            double d01 = (y1 - y0) / (x1 - x0);
            double d12 = (y2 - y1) / (x2 - x1);
            double d012 = (d12 - d01) / (x2 - x0);
            double c1 = d01 + (x1 - x0) * d012;
            double delta = c1 * c1 - 4.0 * y1 * d012;
            double xplus = x1 + -2.0 * y1 / (c1 + FastMath.sqrt(delta));
            double xminus = x1 + -2.0 * y1 / (c1 - FastMath.sqrt(delta));
            double x3 = this.isSequence(x0, xplus, x2) ? xplus : xminus;
            double y = f2.value(x3);
            double tolerance = FastMath.max(this.relativeAccuracy * FastMath.abs(x3), this.absoluteAccuracy);
            if (FastMath.abs(x3 - oldx) <= tolerance) {
                this.setResult(x3, i2);
                return this.result;
            }
            if (FastMath.abs(y) <= this.functionValueAccuracy) {
                this.setResult(x3, i2);
                return this.result;
            }
            boolean bl = bisect = x3 < x1 && x1 - x0 > 0.95 * (x2 - x0) || x3 > x1 && x2 - x1 > 0.95 * (x2 - x0) || x3 == x1;
            if (!bisect) {
                x0 = x3 < x1 ? x0 : x1;
                y0 = x3 < x1 ? y0 : y1;
                x2 = x3 > x1 ? x2 : x1;
                y2 = x3 > x1 ? y2 : y1;
                x1 = x3;
                y1 = y;
                oldx = x3;
                continue;
            }
            double xm = 0.5 * (x0 + x2);
            double ym = f2.value(xm);
            if (MathUtils.sign(y0) + MathUtils.sign(ym) == 0.0) {
                x2 = xm;
                y2 = ym;
            } else {
                x0 = xm;
                y0 = ym;
            }
            x1 = 0.5 * (x0 + x2);
            y1 = f2.value(x1);
            oldx = Double.POSITIVE_INFINITY;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    @Deprecated
    public double solve2(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve2(this.f, min, max);
    }

    @Deprecated
    public double solve2(UnivariateRealFunction f2, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        double x0 = min;
        double y0 = f2.value(x0);
        double x1 = max;
        double y1 = f2.value(x1);
        double x2 = 0.5 * (x0 + x1);
        double y2 = f2.value(x2);
        if (y0 == 0.0) {
            return min;
        }
        if (y1 == 0.0) {
            return max;
        }
        this.verifyBracketing(min, max, f2);
        double oldx = Double.POSITIVE_INFINITY;
        for (int i2 = 1; i2 <= this.maximalIterationCount; ++i2) {
            double x3;
            double denominator;
            double q2 = (x2 - x1) / (x1 - x0);
            double b2 = (2.0 * q2 + 1.0) * y2 - (1.0 + q2) * (1.0 + q2) * y1 + q2 * q2 * y0;
            double a2 = q2 * (y2 - (1.0 + q2) * y1 + q2 * y0);
            double c2 = (1.0 + q2) * y2;
            double delta = b2 * b2 - 4.0 * a2 * c2;
            if (delta >= 0.0) {
                double dplus = b2 + FastMath.sqrt(delta);
                double dminus = b2 - FastMath.sqrt(delta);
                denominator = FastMath.abs(dplus) > FastMath.abs(dminus) ? dplus : dminus;
            } else {
                denominator = FastMath.sqrt(b2 * b2 - delta);
            }
            if (denominator != 0.0) {
                for (x3 = x2 - 2.0 * c2 * (x2 - x1) / denominator; x3 == x1 || x3 == x2; x3 += this.absoluteAccuracy) {
                }
            } else {
                x3 = min + FastMath.random() * (max - min);
                oldx = Double.POSITIVE_INFINITY;
            }
            double y = f2.value(x3);
            double tolerance = FastMath.max(this.relativeAccuracy * FastMath.abs(x3), this.absoluteAccuracy);
            if (FastMath.abs(x3 - oldx) <= tolerance) {
                this.setResult(x3, i2);
                return this.result;
            }
            if (FastMath.abs(y) <= this.functionValueAccuracy) {
                this.setResult(x3, i2);
                return this.result;
            }
            x0 = x1;
            y0 = y1;
            x1 = x2;
            y1 = y2;
            x2 = x3;
            y2 = y;
            oldx = x3;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

