/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeJEXLContext;
import htsjdk.variant.variantcontext.JexlMissingValueTreatment;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.variantcontext.VariantJEXLContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;

class JEXLMap
implements Map<VariantContextUtils.JexlVCMatchExp, Boolean> {
    public static final JexlMissingValueTreatment DEFAULT_MISSING_VALUE_TREATMENT = JexlMissingValueTreatment.TREAT_AS_MISMATCH;
    private final VariantContext vc;
    private final Genotype g;
    private final JexlMissingValueTreatment howToTreatMissingValues;
    private final Map<VariantContextUtils.JexlVCMatchExp, Boolean> jexl;
    private JexlContext jContext = null;

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> jexlCollection, VariantContext vc, Genotype g2, JexlMissingValueTreatment howToTreatMissingValues) {
        this.jexl = JEXLMap.initializeMap(jexlCollection);
        this.vc = vc;
        this.g = g2;
        this.howToTreatMissingValues = howToTreatMissingValues;
    }

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> jexlCollection, VariantContext vc, Genotype g2) {
        this(jexlCollection, vc, g2, DEFAULT_MISSING_VALUE_TREATMENT);
    }

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> jexlCollection, VariantContext vc) {
        this(jexlCollection, vc, null, DEFAULT_MISSING_VALUE_TREATMENT);
    }

    @Override
    public Boolean get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Query key is null");
        }
        Boolean value = this.jexl.get(key);
        if (this.jexl.containsKey(key) && value != null) {
            return value;
        }
        VariantContextUtils.JexlVCMatchExp exp = (VariantContextUtils.JexlVCMatchExp)key;
        boolean matches = this.evaluateExpression(exp);
        this.jexl.put(exp, matches);
        return matches;
    }

    @Override
    public boolean containsKey(Object o2) {
        return this.jexl.containsKey(o2);
    }

    @Override
    public Set<VariantContextUtils.JexlVCMatchExp> keySet() {
        return this.jexl.keySet();
    }

    @Override
    public Collection<Boolean> values() {
        for (VariantContextUtils.JexlVCMatchExp exp : this.jexl.keySet()) {
            this.jexl.computeIfAbsent(exp, k2 -> this.evaluateExpression(exp));
        }
        return this.jexl.values();
    }

    @Override
    public int size() {
        return this.jexl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jexl.isEmpty();
    }

    @Override
    public Boolean put(VariantContextUtils.JexlVCMatchExp jexlVCMatchExp, Boolean aBoolean) {
        return this.jexl.put(jexlVCMatchExp, aBoolean);
    }

    @Override
    public void putAll(Map<? extends VariantContextUtils.JexlVCMatchExp, ? extends Boolean> map) {
        this.jexl.putAll(map);
    }

    private static Map<VariantContextUtils.JexlVCMatchExp, Boolean> initializeMap(Collection<VariantContextUtils.JexlVCMatchExp> jexlCollection) {
        HashMap<VariantContextUtils.JexlVCMatchExp, Boolean> jexlMap = new HashMap<VariantContextUtils.JexlVCMatchExp, Boolean>(jexlCollection.size());
        for (VariantContextUtils.JexlVCMatchExp exp : jexlCollection) {
            jexlMap.put(exp, null);
        }
        return jexlMap;
    }

    private boolean evaluateExpression(VariantContextUtils.JexlVCMatchExp exp) {
        if (this.jContext == null) {
            this.jContext = this.createContext();
        }
        try {
            Boolean value = (Boolean)exp.exp.evaluate(this.jContext);
            return value == null ? this.howToTreatMissingValues.getMissingValueOrExplode() : value.booleanValue();
        }
        catch (JexlException.Variable e2) {
            return this.howToTreatMissingValues.getMissingValueOrExplode();
        }
        catch (JexlException e3) {
            throw new IllegalArgumentException(String.format("Invalid JEXL expression detected for %s", exp.name), e3);
        }
    }

    private JexlContext createContext() {
        if (this.vc == null) {
            return new MapContext(Collections.emptyMap());
        }
        if (this.g == null) {
            return new VariantJEXLContext(this.vc);
        }
        return new GenotypeJEXLContext(this.vc, this.g);
    }

    @Override
    public boolean containsValue(Object o2) {
        throw new UnsupportedOperationException("containsValue() not supported on a JEXLMap");
    }

    @Override
    public Boolean remove(Object o2) {
        throw new UnsupportedOperationException("remove() not supported on a JEXLMap");
    }

    @Override
    public Set<Map.Entry<VariantContextUtils.JexlVCMatchExp, Boolean>> entrySet() {
        throw new UnsupportedOperationException("entrySet() not supported on a JEXLMap");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear() not supported on a JEXLMap");
    }
}

