/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.TreeSet;

public abstract class Genotype
implements Comparable<Genotype>,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final Collection<String> PRIMARY_KEYS = Arrays.asList("FT", "GT", "GQ", "DP", "AD", "PL");
    public static final String PHASED_ALLELE_SEPARATOR = "|";
    public static final String UNPHASED_ALLELE_SEPARATOR = "/";
    private final String sampleName;
    private GenotypeType type = null;
    private final String filters;

    protected Genotype(String sampleName, String filters) {
        this.sampleName = sampleName;
        this.filters = filters == null || filters.isEmpty() ? null : filters;
    }

    public abstract List<Allele> getAlleles();

    public int countAllele(Allele allele) {
        int c2 = 0;
        for (Allele a2 : this.getAlleles()) {
            if (!a2.equals(allele)) continue;
            ++c2;
        }
        return c2;
    }

    public abstract Allele getAllele(int var1);

    public abstract boolean isPhased();

    public int getPloidy() {
        return this.getAlleles().size();
    }

    public abstract int getDP();

    public abstract int[] getAD();

    public String getSampleName() {
        return this.sampleName;
    }

    public abstract int getGQ();

    public boolean hasPL() {
        return this.getPL() != null;
    }

    public boolean hasAD() {
        return this.getAD() != null;
    }

    public boolean hasGQ() {
        return this.getGQ() != -1;
    }

    public boolean hasDP() {
        return this.getDP() != -1;
    }

    public GenotypeType getType() {
        if (this.type == null) {
            this.type = this.determineType();
        }
        return this.type;
    }

    protected GenotypeType determineType() {
        List<Allele> alleles = this.getAlleles();
        if (alleles.isEmpty()) {
            return GenotypeType.UNAVAILABLE;
        }
        boolean sawNoCall = false;
        boolean sawMultipleAlleles = false;
        Allele observedAllele = null;
        for (Allele allele : alleles) {
            if (allele.isNoCall()) {
                sawNoCall = true;
                continue;
            }
            if (observedAllele == null) {
                observedAllele = allele;
                continue;
            }
            if (allele.equals(observedAllele)) continue;
            sawMultipleAlleles = true;
        }
        if (sawNoCall) {
            if (observedAllele == null) {
                return GenotypeType.NO_CALL;
            }
            return GenotypeType.MIXED;
        }
        if (observedAllele == null) {
            throw new IllegalStateException("BUG: there are no alleles present in this genotype but the alleles list is not null");
        }
        return sawMultipleAlleles ? GenotypeType.HET : (observedAllele.isReference() ? GenotypeType.HOM_REF : GenotypeType.HOM_VAR);
    }

    public boolean isHom() {
        return this.isHomRef() || this.isHomVar();
    }

    public boolean isHomRef() {
        return this.getType() == GenotypeType.HOM_REF;
    }

    public boolean isHomVar() {
        return this.getType() == GenotypeType.HOM_VAR;
    }

    public boolean isHet() {
        return this.getType() == GenotypeType.HET;
    }

    public boolean isHetNonRef() {
        return this.getType() == GenotypeType.HET && this.getAllele(0).isNonReference() && this.getAllele(1).isNonReference();
    }

    public boolean isNoCall() {
        return this.getType() == GenotypeType.NO_CALL;
    }

    public boolean isCalled() {
        return this.getType() != GenotypeType.NO_CALL && this.getType() != GenotypeType.UNAVAILABLE;
    }

    public boolean isMixed() {
        return this.getType() == GenotypeType.MIXED;
    }

    public boolean isAvailable() {
        return this.getType() != GenotypeType.UNAVAILABLE;
    }

    public boolean hasLikelihoods() {
        return this.getPL() != null;
    }

    public String getLikelihoodsString() {
        return this.hasLikelihoods() ? this.getLikelihoods().toString() : ".";
    }

    public GenotypeLikelihoods getLikelihoods() {
        return this.hasLikelihoods() ? GenotypeLikelihoods.fromPLs(this.getPL()) : null;
    }

    public boolean isNonInformative() {
        if (this.getPL() == null) {
            return true;
        }
        for (int PL : this.getPL()) {
            if (PL == 0) continue;
            return false;
        }
        return true;
    }

    public abstract int[] getPL();

    public String getGenotypeString() {
        return this.getGenotypeString(true);
    }

    public String getGenotypeString(boolean ignoreRefState) {
        String separator;
        if (this.getPloidy() == 0) {
            return "NA";
        }
        String string = separator = this.isPhased() ? PHASED_ALLELE_SEPARATOR : UNPHASED_ALLELE_SEPARATOR;
        if (ignoreRefState) {
            return ParsingUtils.join(separator, this.getAlleleStrings());
        }
        List<Allele> alleles = this.isPhased() ? this.getAlleles() : ParsingUtils.sortList(this.getAlleles());
        return ParsingUtils.join(separator, alleles);
    }

    protected List<String> getAlleleStrings() {
        ArrayList<String> al = new ArrayList<String>(this.getPloidy());
        for (Allele a2 : this.getAlleles()) {
            al.add(a2.getBaseString());
        }
        return al;
    }

    public String toString() {
        return String.format("[%s %s%s%s%s%s%s%s]", this.getSampleName(), this.getGenotypeString(false), Genotype.toStringIfExists("GQ", this.getGQ()), Genotype.toStringIfExists("DP", this.getDP()), Genotype.toStringIfExists("AD", this.getAD()), Genotype.toStringIfExists("PL", this.getPL()), Genotype.toStringIfExists("FT", this.getFilters()), Genotype.sortedString(this.getExtendedAttributes()));
    }

    public String toBriefString() {
        return String.format("%s:Q%d", this.getGenotypeString(false), this.getGQ());
    }

    @Override
    public int compareTo(Genotype genotype) {
        return this.getSampleName().compareTo(genotype.getSampleName());
    }

    public boolean sameGenotype(Genotype other) {
        return this.sameGenotype(other, true);
    }

    public boolean sameGenotype(Genotype other, boolean ignorePhase) {
        if (this.getPloidy() != other.getPloidy()) {
            return false;
        }
        SequencedCollection<Allele> thisAlleles = this.getAlleles();
        SequencedCollection<Allele> otherAlleles = other.getAlleles();
        if (ignorePhase) {
            thisAlleles = new TreeSet<Allele>(thisAlleles);
            otherAlleles = new TreeSet<Allele>(otherAlleles);
        }
        return thisAlleles.equals(otherAlleles);
    }

    public abstract Map<String, Object> getExtendedAttributes();

    public boolean hasExtendedAttribute(String key) {
        return this.getExtendedAttributes().containsKey(key);
    }

    public Object getExtendedAttribute(String key, Object defaultValue) {
        return this.hasExtendedAttribute(key) ? this.getExtendedAttributes().get(key) : defaultValue;
    }

    public Object getExtendedAttribute(String key) {
        return this.getExtendedAttribute(key, null);
    }

    public final String getFilters() {
        return this.filters;
    }

    public final boolean isFiltered() {
        return this.getFilters() != null;
    }

    @Deprecated
    public boolean hasLog10PError() {
        return this.hasGQ();
    }

    @Deprecated
    public double getLog10PError() {
        return (double)this.getGQ() / -10.0;
    }

    @Deprecated
    public int getPhredScaledQual() {
        return this.getGQ();
    }

    @Deprecated
    public String getAttributeAsString(String key, String defaultValue) {
        Object x2 = this.getExtendedAttribute(key);
        if (x2 == null) {
            return defaultValue;
        }
        if (x2 instanceof String) {
            return (String)x2;
        }
        return String.valueOf(x2);
    }

    @Deprecated
    public int getAttributeAsInt(String key, int defaultValue) {
        Object x2 = this.getExtendedAttribute(key);
        if (x2 == null || x2 == ".") {
            return defaultValue;
        }
        if (x2 instanceof Integer) {
            return (Integer)x2;
        }
        return Integer.valueOf((String)x2);
    }

    @Deprecated
    public double getAttributeAsDouble(String key, double defaultValue) {
        Object x2 = this.getExtendedAttribute(key);
        if (x2 == null) {
            return defaultValue;
        }
        if (x2 instanceof Double) {
            return (Double)x2;
        }
        return Double.valueOf((String)x2);
    }

    public Object getAnyAttribute(String key) {
        if (key.equals("GT")) {
            return this.getAlleles();
        }
        if (key.equals("GQ")) {
            return this.getGQ();
        }
        if (key.equals("AD")) {
            if (this.hasAD()) {
                ArrayList<Integer> intList = new ArrayList<Integer>(this.getAD().length);
                for (int i2 : this.getAD()) {
                    intList.add(i2);
                }
                return intList;
            }
            return Collections.EMPTY_LIST;
        }
        if (key.equals("PL")) {
            if (this.hasPL()) {
                ArrayList<Integer> intList = new ArrayList<Integer>(this.getPL().length);
                for (int i3 : this.getPL()) {
                    intList.add(i3);
                }
                return intList;
            }
            return Collections.EMPTY_LIST;
        }
        if (key.equals("DP")) {
            return this.getDP();
        }
        if (key.equals("FT")) {
            return this.getFilters();
        }
        return this.getExtendedAttribute(key);
    }

    public boolean hasAnyAttribute(String key) {
        if (key.equals("GT")) {
            return this.isAvailable();
        }
        if (key.equals("GQ")) {
            return this.hasGQ();
        }
        if (key.equals("AD")) {
            return this.hasAD();
        }
        if (key.equals("PL")) {
            return this.hasPL();
        }
        if (key.equals("DP")) {
            return this.hasDP();
        }
        if (key.equals("FT")) {
            return true;
        }
        return this.hasExtendedAttribute(key);
    }

    protected static <T extends Comparable<T>, V> String sortedString(Map<T, V> c2) {
        ArrayList<T> t2 = new ArrayList<T>(c2.keySet());
        Collections.sort(t2);
        ArrayList<String> pairs = new ArrayList<String>();
        for (Comparable k2 : t2) {
            pairs.add(k2 + "=" + c2.get(k2));
        }
        return pairs.isEmpty() ? "" : " {" + ParsingUtils.join(", ", pairs.toArray(new String[pairs.size()])) + "}";
    }

    protected static final String toStringIfExists(String name, int v2) {
        return v2 == -1 ? "" : " " + name + " " + v2;
    }

    protected static final String toStringIfExists(String name, String v2) {
        return v2 == null ? "" : " " + name + " " + v2;
    }

    protected static final String toStringIfExists(String name, int[] vs) {
        if (vs == null) {
            return "";
        }
        StringBuilder b2 = new StringBuilder();
        b2.append(' ').append(name).append(' ');
        for (int i2 = 0; i2 < vs.length; ++i2) {
            if (i2 != 0) {
                b2.append(',');
            }
            b2.append(vs[i2]);
        }
        return b2.toString();
    }

    protected static final boolean hasForbiddenKey(Map<String, Object> attributes) {
        for (String forbidden : PRIMARY_KEYS) {
            if (!attributes.containsKey(forbidden)) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isForbiddenKey(String key) {
        return PRIMARY_KEYS.contains(key);
    }
}

