/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.InputResource;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.function.Supplier;

class FileInputResource
extends InputResource {
    final File fileResource;
    final Lazy<SeekableStream> lazySeekableStream = new Lazy<SeekableStream>(new Supplier<SeekableStream>(){

        @Override
        public SeekableStream get() {
            try {
                return new SeekableFileStream(FileInputResource.this.fileResource);
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeIOException(e2);
            }
        }
    });

    FileInputResource(File fileResource) {
        super(InputResource.Type.FILE);
        this.fileResource = fileResource;
    }

    @Override
    public File asFile() {
        return this.fileResource;
    }

    @Override
    public Path asPath() {
        return this.fileResource.toPath();
    }

    @Override
    public URL asUrl() {
        try {
            return this.asPath().toUri().toURL();
        }
        catch (MalformedURLException e2) {
            return null;
        }
    }

    @Override
    public SeekableStream asUnbufferedSeekableStream() {
        return this.lazySeekableStream.get();
    }

    @Override
    public InputStream asUnbufferedInputStream() {
        return this.asUnbufferedSeekableStream();
    }

    @Override
    public SRAAccession asSRAAccession() {
        return null;
    }
}

