/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public abstract class NavigationComponentHelper {
    private int _rolloverRow = -1;
    private Point _mousePosition = null;

    protected abstract Rectangle getRowBounds(int var1);

    protected abstract int rowAtPoint(Point var1);

    protected abstract int[] getSelectedRows();

    public void mouseMoved(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void focusGained(FocusEvent e2) {
    }

    public void focusLost(FocusEvent e2) {
    }

    public void paint(Graphics g2, JComponent c2) {
        int[] rows;
        if (this._rolloverRow != -1) {
            this.paintRolloverRow(g2, c2, this._rolloverRow);
        }
        if ((rows = this.getSelectedRows()) != null) {
            for (int row : rows) {
                this.paintSelectedRow(g2, c2, row);
            }
        }
    }

    protected void paintSelectedRow(Graphics g2, JComponent c2, int row) {
        Color selectedColor = this.getSelectionColor(c2);
        Rectangle bounds = this.getRowBounds(row);
        --bounds.width;
        --bounds.height;
        this.paintRow(g2, row, bounds, selectedColor, 30, 70, 50, 128);
    }

    protected Color getSelectionColor(JComponent c2) {
        Color selectedColor = UIManager.getColor("NavigationComponent.selectionBackground");
        if (selectedColor == null) {
            selectedColor = UIManager.getColor("Tree.selectionBackground");
        }
        if (!c2.hasFocus() && Color.WHITE.equals(selectedColor = ColorUtils.toGrayscale(selectedColor).brighter())) {
            selectedColor = new Color(202, 202, 202);
        }
        return selectedColor;
    }

    protected void paintRolloverRow(Graphics g2, JComponent c2, int row) {
        Color selectedColor = UIManager.getColor("Tree.selectionBackground");
        Rectangle bounds = this.getRowBounds(row);
        if (bounds == null) {
            return;
        }
        --bounds.width;
        --bounds.height;
        this.paintRow(g2, row, bounds, selectedColor, 10, 40, 20, 100);
    }

    private void paintRow(Graphics g2, int row, Rectangle bounds, Color color, int a1, int a2, int a3, int a4) {
        Object o2 = JideSwingUtilities.setupShapeAntialiasing(g2);
        ((Graphics2D)g2).setPaint(new LinearGradientPaint(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height, new float[]{0.5f, 0.95f, 1.0f}, new Color[]{new Color(color.getRed(), color.getGreen(), color.getBlue(), a1), new Color(color.getRed(), color.getGreen(), color.getBlue(), a2), new Color(color.getRed(), color.getGreen(), color.getBlue(), a3)}, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        int cornerSize = 5;
        g2.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize, cornerSize);
        g2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), a4));
        g2.drawRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize, cornerSize);
        JideSwingUtilities.restoreShapeAntialiasing(g2, o2);
    }

    public void setup(final JComponent c2) {
        MouseInputAdapter inputAdapter = new MouseInputAdapter(){

            public void mouseExited(MouseEvent e2) {
                NavigationComponentHelper.this._mousePosition = null;
                int old = NavigationComponentHelper.this._rolloverRow;
                NavigationComponentHelper.this._rolloverRow = -1;
                if (old != -1) {
                    c2.repaint(NavigationComponentHelper.this.getRowBounds(old));
                }
                NavigationComponentHelper.this.mouseExited(e2);
            }

            public void mouseEntered(MouseEvent e2) {
                NavigationComponentHelper.this.mouseEntered(e2);
            }

            public void mousePressed(MouseEvent e2) {
                NavigationComponentHelper.this.mousePressed(e2);
            }

            public void mouseReleased(MouseEvent e2) {
                NavigationComponentHelper.this.mouseReleased(e2);
            }

            public void mouseClicked(MouseEvent e2) {
                NavigationComponentHelper.this.mouseClicked(e2);
            }

            public void mouseMoved(MouseEvent e2) {
                int row = NavigationComponentHelper.this.rowAtPoint(e2.getPoint());
                if (row != -1) {
                    if (c2 instanceof JTree) {
                        int maxIconSize = NavigationComponentHelper.this.getRowBounds((int)row).height;
                        if (NavigationComponentHelper.this._mousePosition != null) {
                            c2.repaint(new Rectangle(((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.x - maxIconSize, ((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.y - maxIconSize, 2 * maxIconSize, 2 * maxIconSize));
                        }
                        NavigationComponentHelper.this._mousePosition = e2.getPoint();
                        if (NavigationComponentHelper.this._mousePosition != null) {
                            c2.repaint(new Rectangle(((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.x - maxIconSize, ((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.y - maxIconSize, 2 * maxIconSize, 2 * maxIconSize));
                        }
                    }
                    if (NavigationComponentHelper.this._rolloverRow != row) {
                        int old = NavigationComponentHelper.this._rolloverRow;
                        NavigationComponentHelper.this._rolloverRow = row;
                        if (old != -1) {
                            c2.repaint(NavigationComponentHelper.this.getRowBounds(old));
                        }
                        c2.repaint(NavigationComponentHelper.this.getRowBounds(row));
                    }
                } else {
                    int old = NavigationComponentHelper.this._rolloverRow;
                    NavigationComponentHelper.this._rolloverRow = -1;
                    if (old != -1) {
                        c2.repaint(NavigationComponentHelper.this.getRowBounds(old));
                    }
                }
                NavigationComponentHelper.this.mouseMoved(e2);
            }
        };
        c2.addMouseMotionListener(inputAdapter);
        c2.addMouseListener(inputAdapter);
        c2.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e2) {
                NavigationComponentHelper.this.repaintSelections(c2);
                NavigationComponentHelper.this.focusGained(e2);
            }

            public void focusLost(FocusEvent e2) {
                NavigationComponentHelper.this.repaintSelections(c2);
                NavigationComponentHelper.this.focusLost(e2);
            }
        });
    }

    public void repaintSelections(JComponent c2) {
        int[] rows = this.getSelectedRows();
        if (rows != null) {
            for (int row : rows) {
                Rectangle bounds = this.getRowBounds(row);
                bounds.x = 0;
                bounds.width = c2.getWidth();
                c2.repaint(bounds);
            }
        }
        if (this._rolloverRow != -1) {
            c2.repaint(this.getRowBounds(this._rolloverRow));
        }
    }

    public int getRolloverRow() {
        return this._rolloverRow;
    }

    public void setRolloverRow(int rolloverRow) {
        this._rolloverRow = rolloverRow;
    }

    public Point getMousePosition() {
        return this._mousePosition;
    }
}

