/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

public abstract class IntArrayGraphAlgorithm<V, E> {
    protected final List<V> _vertices;
    protected final int[][] _neighbors;
    protected final Map<V, Integer> _vertexToPos;

    public IntArrayGraphAlgorithm(Graph<V, E> graph) {
        int n2 = graph.vertexSet().size();
        this._vertices = new ArrayList<V>(n2);
        this._neighbors = new int[n2][];
        this._vertexToPos = new HashMap<V, Integer>(n2);
        for (V v2 : graph.vertexSet()) {
            this._neighbors[this._vertices.size()] = new int[graph.edgesOf(v2).size()];
            this._vertexToPos.put((Integer)v2, this._vertices.size());
            this._vertices.add(v2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = 0;
            V v3 = this._vertices.get(i2);
            for (E e2 : graph.edgesOf(v3)) {
                this._neighbors[i2][n3++] = this._vertexToPos.get(Graphs.getOppositeVertex(graph, e2, v3));
            }
        }
    }
}

