/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.collections;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiMap<K, V> {
    LinkedHashMap<K, Object> map;
    int size = 0;
    private static final int MAX_CHARS_PER_LINE = 50;

    public MultiMap() {
        this(10);
    }

    public MultiMap(int size) {
        this.map = new LinkedHashMap(size);
    }

    public void put(K key, V value) {
        Object currentValue = this.map.get(key);
        if (currentValue == null) {
            this.map.put(key, value);
        } else if (currentValue instanceof List) {
            ((List)currentValue).add(value);
        } else {
            ArrayList<Object> valueList = new ArrayList<Object>();
            valueList.add(currentValue);
            valueList.add(value);
            this.map.put(key, valueList);
        }
        ++this.size;
    }

    public V get(K key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (V)((List)value).get(0);
        }
        return (V)value;
    }

    public V remove(K key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            this.size -= ((List)value).size();
            this.map.remove(key);
            return (V)((List)value).get(0);
        }
        --this.size;
        this.map.remove(key);
        return (V)value;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public void printHtml(StringBuffer buffer, int max) {
        if (this.map == null || this.map.isEmpty()) {
            return;
        }
        int count = 0;
        buffer.append("<br>");
        for (Map.Entry<K, Object> entry : this.map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                for (Object v2 : (List)value) {
                    buffer.append("<b>" + entry.getKey() + "</b>");
                    buffer.append(":&nbsp;");
                    buffer.append(v2.toString());
                    buffer.append("<br/>");
                    ++count;
                }
            } else {
                buffer.append("<b>" + entry.getKey() + "</b>");
                buffer.append(":&nbsp;");
                String ts = this.lineWrapString(value.toString(), 50);
                buffer.append(ts);
                buffer.append("<br/>");
                ++count;
            }
            if (++count <= max) continue;
            buffer.append("...");
            break;
        }
    }

    private String lineWrapString(String input, int maxCharsPerLine) {
        int lines = input.length() / maxCharsPerLine + 1;
        if (lines == 1) {
            return input;
        }
        String result = input.substring(0, maxCharsPerLine);
        for (int lineNum = 1; lineNum < lines; ++lineNum) {
            int start = lineNum * maxCharsPerLine;
            int end = Math.min(start + maxCharsPerLine, input.length());
            result = result + "<br/>" + input.substring(start, end);
        }
        return result;
    }

    public List<V> values() {
        ArrayList<Object> allValues = new ArrayList<Object>(this.map.size());
        for (Map.Entry<K, Object> entry : this.map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                allValues.addAll((List)value);
                continue;
            }
            allValues.add(value);
        }
        return allValues;
    }

    public void addAll(MultiMap<K, V> attributes) {
        for (K key : attributes.keys()) {
            this.map.put(key, attributes.get(key));
        }
    }
}

