/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.basepair;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.broad.igv.feature.basepair.BasePairData;
import org.broad.igv.feature.basepair.BasePairFileParser;
import org.broad.igv.feature.basepair.BasePairRenderer;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ResourceLocator;

@XmlType(factoryMethod="getNextTrack")
@XmlSeeAlso(value={RenderOptions.class})
public class BasePairTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(BasePairTrack.class);
    private BasePairRenderer basePairRenderer = new BasePairRenderer();
    private BasePairData basePairData = new BasePairData();
    private RenderOptions renderOptions = new RenderOptions();

    public BasePairTrack(ResourceLocator locator, String id, String name, Genome genome) {
        super(locator, id, name);
        BasePairFileParser.loadData(locator, genome, this.basePairData, this.renderOptions);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.basePairRenderer.draw(this.basePairData, context, rect, this.renderOptions);
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    public void changeColor(Color currentColor, String currentLabel, Color newColor) {
        String currentColorString = ColorUtilities.colorToString(currentColor);
        String newColorString = ColorUtilities.colorToString(newColor);
        for (int i2 = 0; i2 < this.renderOptions.getColors().size(); ++i2) {
            String colorString = this.renderOptions.getColors().get(i2);
            String label = this.renderOptions.getColorLabels().get(i2);
            if (!currentColorString.equals(colorString) || !currentLabel.equals(label)) continue;
            this.renderOptions.setColor(i2, newColorString);
        }
    }

    public RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    @XmlElement(name="BPRenderOptions")
    public void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    private static BasePairTrack getNextTrack() {
        return (BasePairTrack)IGVSessionReader.getNextTrack();
    }

    @XmlType(name="BPRenderOptions")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RenderOptions {
        public static final String NAME = "BPRenderOptions";
        @XmlAttribute
        ArcDirection arcDirection = ArcDirection.DOWN;
        @XmlAttribute
        boolean fitHeight = false;
        @XmlElement
        List<String> colors = new ArrayList<String>();
        @XmlElement
        List<String> colorLabels = new ArrayList<String>();

        RenderOptions() {
        }

        public boolean getFitHeight() {
            return this.fitHeight;
        }

        public void setFitHeight(boolean b2) {
            this.fitHeight = b2;
        }

        public ArcDirection getArcDirection() {
            return this.arcDirection;
        }

        public void setArcDirection(ArcDirection d2) {
            this.arcDirection = d2;
        }

        public List<String> getColors() {
            return this.colors;
        }

        public void setColors(List<String> l2) {
            this.colors = l2;
        }

        public List<String> getColorLabels() {
            return this.colorLabels;
        }

        public void setColorLabels(List<String> l2) {
            this.colorLabels = l2;
        }

        public String getColor(int i2) {
            return this.colors.get(i2);
        }

        public void setColor(int i2, String s2) {
            this.colors.set(i2, s2);
        }

        public String getColorLabel(int i2) {
            return this.colorLabels.get(i2);
        }

        public void setColorLabel(int i2, String s2) {
            this.colorLabels.set(i2, s2);
        }
    }

    public static enum ArcDirection {
        UP,
        DOWN;

    }
}

