/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.dev.db.DBReader;

public abstract class DBQueryReader<T>
extends DBReader {
    private static Logger log = Logger.getLogger(DBQueryReader.class);
    protected DBProfile.DBTable table;

    public DBQueryReader(DBProfile.DBTable table) {
        super(table);
        this.table = table;
    }

    protected Iterator loadIterator(PreparedStatement st) {
        try {
            ResultSet rs = st.executeQuery();
            return this.loadIterator(rs);
        }
        catch (SQLException e2) {
            log.error("Database error", e2);
            throw new RuntimeException("Database error", e2);
        }
    }

    protected Iterator loadIterator(ResultSet rs) {
        ArrayList<T> results = new ArrayList<T>();
        try {
            while (rs.next()) {
                results.add(this.processResult(rs));
            }
        }
        catch (SQLException e2) {
            log.error("Database error", e2);
            throw new RuntimeException("Database error", e2);
        }
        finally {
            DBManager.closeAll(rs);
        }
        return results.iterator();
    }

    protected abstract T processResult(ResultSet var1) throws SQLException;
}

