/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalUtils;

public class MetalInternalFrameUI
extends BasicInternalFrameUI {
    private static final PropertyChangeListener metalPropertyChangeListener = new MetalPropertyChangeHandler();
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected static String IS_PALETTE = "JInternalFrame.isPalette";
    private static String IS_PALETTE_KEY = "JInternalFrame.isPalette";
    private static String FRAME_TYPE = "JInternalFrame.frameType";
    private static String NORMAL_FRAME = "normal";
    private static String PALETTE_FRAME = "palette";
    private static String OPTION_DIALOG = "optionDialog";

    public MetalInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalInternalFrameUI((JInternalFrame)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(IS_PALETTE_KEY);
        if (object != null) {
            this.setPalette((Boolean)object);
        }
        Container container = this.frame.getContentPane();
        this.stripContentBorder(container);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        JComponent jComponent2;
        this.frame = (JInternalFrame)jComponent;
        Container container = ((JInternalFrame)jComponent).getContentPane();
        if (container instanceof JComponent && (jComponent2 = (JComponent)container).getBorder() == handyEmptyBorder) {
            jComponent2.setBorder(null);
        }
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(metalPropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(metalPropertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.frame);
        if (actionMap != null) {
            actionMap.remove("showSystemMenu");
        }
    }

    @Override
    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    @Override
    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    private void stripContentBorder(Object object) {
        JComponent jComponent;
        Border border;
        if (object instanceof JComponent && ((border = (jComponent = (JComponent)object).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(handyEmptyBorder);
        }
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        return new MetalInternalFrameTitlePane(jInternalFrame);
    }

    private void setFrameType(String string) {
        if (string.equals(OPTION_DIALOG)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.optionDialogBorder");
            ((MetalInternalFrameTitlePane)this.titlePane).setPalette(false);
        } else if (string.equals(PALETTE_FRAME)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
            ((MetalInternalFrameTitlePane)this.titlePane).setPalette(true);
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
            ((MetalInternalFrameTitlePane)this.titlePane).setPalette(false);
        }
    }

    public void setPalette(boolean bl) {
        if (bl) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        ((MetalInternalFrameTitlePane)this.titlePane).setPalette(bl);
    }

    @Override
    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new BorderListener1();
    }

    private class BorderListener1
    extends BasicInternalFrameUI.BorderListener
    implements SwingConstants {
        private BorderListener1() {
        }

        Rectangle getIconBounds() {
            boolean bl = MetalUtils.isLeftToRight(MetalInternalFrameUI.this.frame);
            int n = bl ? 5 : MetalInternalFrameUI.this.titlePane.getWidth() - 5;
            Rectangle rectangle = null;
            Icon icon = MetalInternalFrameUI.this.frame.getFrameIcon();
            if (icon != null) {
                if (!bl) {
                    n -= icon.getIconWidth();
                }
                int n2 = MetalInternalFrameUI.this.titlePane.getHeight() / 2 - icon.getIconHeight() / 2;
                rectangle = new Rectangle(n, n2, icon.getIconWidth(), icon.getIconHeight());
            }
            return rectangle;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == MetalInternalFrameUI.this.getNorthPane() && MetalInternalFrameUI.this.frame.isClosable() && !MetalInternalFrameUI.this.frame.isIcon()) {
                Rectangle rectangle = this.getIconBounds();
                if (rectangle != null && rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    MetalInternalFrameUI.this.frame.doDefaultCloseAction();
                } else {
                    super.mouseClicked(mouseEvent);
                }
            } else {
                super.mouseClicked(mouseEvent);
            }
        }
    }

    private static class MetalPropertyChangeHandler
    implements PropertyChangeListener {
        private MetalPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            if (!(jInternalFrame.getUI() instanceof MetalInternalFrameUI)) {
                return;
            }
            MetalInternalFrameUI metalInternalFrameUI = (MetalInternalFrameUI)jInternalFrame.getUI();
            if (string.equals(FRAME_TYPE)) {
                if (propertyChangeEvent.getNewValue() instanceof String) {
                    metalInternalFrameUI.setFrameType((String)propertyChangeEvent.getNewValue());
                }
            } else if (string.equals(IS_PALETTE_KEY)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    metalInternalFrameUI.setPalette((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    metalInternalFrameUI.setPalette(false);
                }
            } else if (string.equals("contentPane")) {
                metalInternalFrameUI.stripContentBorder(propertyChangeEvent.getNewValue());
            }
        }
    }
}

