/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class ScaleFreeGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int size;
    private long seed;
    private Random random;

    public ScaleFreeGraphGenerator(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid size: " + n2 + " (must be non-negative)");
        }
        this.size = n2;
        this.random = new Random();
        this.seed = this.random.nextLong();
    }

    public ScaleFreeGraphGenerator(int n2, long l2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid size: " + n2 + " (must be non-negative)");
        }
        this.size = n2;
        this.random = new Random();
        this.seed = l2;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        this.random.setSeed(this.seed);
        ArrayList<V> arrayList = new ArrayList<V>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            V v2 = vertexFactory.createVertex();
            graph.addVertex(v2);
            int n3 = 0;
            while (n3 == 0 && i2 != 0) {
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    if (n2 != 0 && this.random.nextInt(n2) >= (Integer)arrayList2.get(i3)) continue;
                    arrayList2.set(i3, (Integer)arrayList2.get(i3) + 1);
                    ++n3;
                    n2 += 2;
                    if (this.random.nextInt(2) == 0) {
                        graph.addEdge(arrayList.get(i3), v2);
                        continue;
                    }
                    graph.addEdge(v2, arrayList.get(i3));
                }
            }
            arrayList.add(v2);
            arrayList2.add(n3);
        }
    }
}

