/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class StoerWagnerMinimumCut<V, E> {
    final WeightedGraph<Set<V>, DefaultWeightedEdge> workingGraph;
    double bestcutweight = Double.POSITIVE_INFINITY;
    Set<V> bestCut;
    boolean firstRun = true;

    public StoerWagnerMinimumCut(WeightedGraph<V, E> weightedGraph) {
        HashSet hashSet;
        this.workingGraph = new SimpleWeightedGraph<Set<V>, DefaultWeightedEdge>(DefaultWeightedEdge.class);
        HashMap hashMap = new HashMap();
        for (Object object : weightedGraph.vertexSet()) {
            hashSet = new HashSet();
            hashSet.add(object);
            hashMap.put(object, hashSet);
            this.workingGraph.addVertex(hashSet);
        }
        for (Object object : weightedGraph.edgeSet()) {
            hashSet = weightedGraph.getEdgeSource(object);
            Set set = (Set)hashMap.get(hashSet);
            Object v2 = weightedGraph.getEdgeTarget(object);
            Set set2 = (Set)hashMap.get(v2);
            DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.workingGraph.addEdge(set, set2);
            this.workingGraph.setEdgeWeight(defaultWeightedEdge, weightedGraph.getEdgeWeight(object));
        }
        Set set = (Set)this.workingGraph.vertexSet().iterator().next();
        while (this.workingGraph.vertexSet().size() > 2) {
            this.minimumCutPhase(set);
        }
    }

    protected void minimumCutPhase(Set<V> set) {
        Object object2;
        Set set22;
        PriorityQueue<VertexAndWeight> priorityQueue = new PriorityQueue<VertexAndWeight>();
        HashMap<Set, VertexAndWeight> hashMap = new HashMap<Set, VertexAndWeight>();
        for (Set set22 : this.workingGraph.vertexSet()) {
            if (set22 == set) continue;
            Double d2 = -this.workingGraph.getEdgeWeight((DefaultWeightedEdge)this.workingGraph.getEdge(set22, set));
            object2 = new VertexAndWeight(set22, d2);
            priorityQueue.add((VertexAndWeight)object2);
            hashMap.put(set22, (VertexAndWeight)object2);
        }
        ArrayList arrayList = new ArrayList(this.workingGraph.vertexSet().size());
        arrayList.add(set);
        while (!priorityQueue.isEmpty()) {
            set22 = ((VertexAndWeight)priorityQueue.poll()).vertex;
            hashMap.remove(set22);
            arrayList.add(set22);
            for (Object object2 : this.workingGraph.edgesOf(set22)) {
                Set set3 = set22 != this.workingGraph.getEdgeSource((DefaultWeightedEdge)object2) ? (Set)this.workingGraph.getEdgeSource((DefaultWeightedEdge)object2) : (Set)this.workingGraph.getEdgeTarget((DefaultWeightedEdge)object2);
                if (hashMap.get(set3) == null) continue;
                Double d3 = -this.workingGraph.getEdgeWeight((DefaultWeightedEdge)this.workingGraph.getEdge(set22, set3)) + ((VertexAndWeight)hashMap.get((Object)set3)).weight;
                priorityQueue.remove(hashMap.get(set3));
                ((VertexAndWeight)hashMap.get((Object)set3)).weight = d3;
                priorityQueue.add((VertexAndWeight)hashMap.get(set3));
            }
        }
        if (this.firstRun) {
            set22 = (Set)arrayList.get(arrayList.size() - 1);
            double d4 = this.vertexWeight(set22);
            if (d4 < this.bestcutweight) {
                this.bestcutweight = d4;
                this.bestCut = set22;
            }
            this.firstRun = false;
        }
        set22 = (Set)arrayList.get(arrayList.size() - 2);
        Set set4 = (Set)arrayList.get(arrayList.size() - 1);
        object2 = this.mergeVertices(set22, set4);
        if (((VertexAndWeight)object2).weight < this.bestcutweight) {
            this.bestcutweight = ((VertexAndWeight)object2).weight;
            this.bestCut = ((VertexAndWeight)object2).vertex;
        }
    }

    public double minCutWeight() {
        return this.bestcutweight;
    }

    public Set<V> minCut() {
        return this.bestCut;
    }

    protected VertexAndWeight mergeVertices(Set<V> set, Set<V> set2) {
        HashSet<V> hashSet = new HashSet<V>();
        for (V v2 : set) {
            hashSet.add(v2);
        }
        for (V v2 : set2) {
            hashSet.add(v2);
        }
        this.workingGraph.addVertex(hashSet);
        double d2 = 0.0;
        for (Set set3 : this.workingGraph.vertexSet()) {
            if (set == set3 || set2 == set3) continue;
            DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.workingGraph.getEdge(set2, set3);
            DefaultWeightedEdge defaultWeightedEdge2 = (DefaultWeightedEdge)this.workingGraph.getEdge(set, set3);
            double d3 = 0.0;
            double d4 = 0.0;
            if (defaultWeightedEdge != null) {
                d3 = this.workingGraph.getEdgeWeight(defaultWeightedEdge);
            }
            if (defaultWeightedEdge2 != null) {
                d4 = this.workingGraph.getEdgeWeight(defaultWeightedEdge2);
            }
            double d5 = d3 + d4;
            d2 += d5;
            if (d5 == 0.0) continue;
            this.workingGraph.setEdgeWeight((DefaultWeightedEdge)this.workingGraph.addEdge(hashSet, set3), d5);
        }
        this.workingGraph.removeVertex(set2);
        this.workingGraph.removeVertex(set);
        return new VertexAndWeight(hashSet, d2);
    }

    public double vertexWeight(Set<V> set) {
        double d2 = 0.0;
        for (DefaultWeightedEdge defaultWeightedEdge : this.workingGraph.edgesOf(set)) {
            d2 += this.workingGraph.getEdgeWeight(defaultWeightedEdge);
        }
        return d2;
    }

    protected class VertexAndWeight
    implements Comparable<VertexAndWeight> {
        public Set<V> vertex;
        public Double weight;

        public VertexAndWeight(Set<V> set, double d2) {
            this.vertex = set;
            this.weight = d2;
        }

        @Override
        public int compareTo(VertexAndWeight vertexAndWeight) {
            return Double.compare(this.weight, vertexAndWeight.weight);
        }

        public String toString() {
            return "(" + this.vertex + ", " + this.weight + ")";
        }
    }
}

