/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import com.google.java.contract.Ensures;
import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.gatk.utils.NGSPlatform;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.recalibration.EventType;
import org.broadinstitute.gatk.utils.sam.ArtificialSAMUtils;
import org.broadinstitute.gatk.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.gatk.utils.sam.ReadUtils;

public class GATKSAMRecord
extends BAMRecord
implements Cloneable {
    public static final String BQSR_BASE_INSERTION_QUALITIES = "BI";
    public static final String BQSR_BASE_DELETION_QUALITIES = "BD";
    public static final byte DEFAULT_INSERTION_DELETION_QUAL = 45;
    private String mReadString = null;
    private GATKSAMReadGroupRecord mReadGroup = null;
    private static final int UNINITIALIZED = -1;
    private int softStart = -1;
    private int softEnd = -1;
    private Integer adapterBoundary = null;
    private boolean isStrandlessRead = false;
    private boolean retrievedReadGroup = false;
    private Map<Object, Object> temporaryAttributes;

    public GATKSAMRecord(SAMFileHeader header) {
        this(new SAMRecord(header));
    }

    public GATKSAMRecord(SAMRecord read) {
        super(read.getHeader(), read.getMateReferenceIndex(), read.getAlignmentStart(), read.getReadName() != null ? (short)read.getReadNameLength() : (short)0, (short)read.getMappingQuality(), 0, read.getCigarLength(), read.getFlags(), read.getReadLength(), read.getMateReferenceIndex(), read.getMateAlignmentStart(), read.getInferredInsertSize(), null);
        SAMReadGroupRecord samRG = read.getReadGroup();
        this.clearAttributes();
        if (samRG != null) {
            GATKSAMReadGroupRecord rg = new GATKSAMReadGroupRecord(samRG);
            this.setReadGroup(rg);
        }
    }

    public GATKSAMRecord(SAMFileHeader header, int referenceSequenceIndex, int alignmentStart, short readNameLength, short mappingQuality, int indexingBin, int cigarLen, int flags, int readLen, int mateReferenceSequenceIndex, int mateAlignmentStart, int insertSize, byte[] variableLengthBlock) {
        super(header, referenceSequenceIndex, alignmentStart, readNameLength, mappingQuality, indexingBin, cigarLen, flags, readLen, mateReferenceSequenceIndex, mateAlignmentStart, insertSize, variableLengthBlock);
    }

    public static GATKSAMRecord createRandomRead(int length) {
        LinkedList<CigarElement> cigarElements = new LinkedList<CigarElement>();
        cigarElements.add(new CigarElement(length, CigarOperator.M));
        Cigar cigar = new Cigar(cigarElements);
        return ArtificialSAMUtils.createArtificialRead(cigar);
    }

    public boolean isStrandless() {
        return this.isStrandlessRead;
    }

    public void setIsStrandless(boolean isStrandless) {
        this.isStrandlessRead = isStrandless;
    }

    @Override
    public boolean getReadNegativeStrandFlag() {
        return !this.isStrandless() && super.getReadNegativeStrandFlag();
    }

    @Override
    public void setReadNegativeStrandFlag(boolean flag) {
        if (this.isStrandless()) {
            throw new IllegalStateException("Cannot set the strand of a strandless read");
        }
        super.setReadNegativeStrandFlag(flag);
    }

    @Override
    public String getReadString() {
        if (this.mReadString == null) {
            this.mReadString = super.getReadString();
        }
        return this.mReadString;
    }

    @Override
    public void setReadString(String s2) {
        super.setReadString(s2);
        this.mReadString = s2;
    }

    @Override
    public GATKSAMReadGroupRecord getReadGroup() {
        if (!this.retrievedReadGroup) {
            SAMReadGroupRecord rg = super.getReadGroup();
            this.mReadGroup = rg == null ? null : (rg instanceof GATKSAMReadGroupRecord ? (GATKSAMReadGroupRecord)rg : new GATKSAMReadGroupRecord(rg));
            this.retrievedReadGroup = true;
        }
        return this.mReadGroup;
    }

    public void setReadGroup(GATKSAMReadGroupRecord readGroup) {
        this.mReadGroup = readGroup;
        this.retrievedReadGroup = true;
        this.setAttribute("RG", (Object)this.mReadGroup.getId());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof GATKSAMRecord)) {
            return false;
        }
        return super.equals(o2);
    }

    public void setBaseQualities(byte[] quals, EventType errorModel) {
        switch (errorModel) {
            case BASE_SUBSTITUTION: {
                this.setBaseQualities(quals);
                break;
            }
            case BASE_INSERTION: {
                this.setAttribute(BQSR_BASE_INSERTION_QUALITIES, (Object)(quals == null ? null : SAMUtils.phredToFastq(quals)));
                break;
            }
            case BASE_DELETION: {
                this.setAttribute(BQSR_BASE_DELETION_QUALITIES, (Object)(quals == null ? null : SAMUtils.phredToFastq(quals)));
                break;
            }
            default: {
                throw new ReviewedGATKException("Unrecognized Base Recalibration type: " + (Object)((Object)errorModel));
            }
        }
    }

    public byte[] getBaseQualities(EventType errorModel) {
        switch (errorModel) {
            case BASE_SUBSTITUTION: {
                return this.getBaseQualities();
            }
            case BASE_INSERTION: {
                return this.getBaseInsertionQualities();
            }
            case BASE_DELETION: {
                return this.getBaseDeletionQualities();
            }
        }
        throw new ReviewedGATKException("Unrecognized Base Recalibration type: " + (Object)((Object)errorModel));
    }

    public boolean hasBaseIndelQualities() {
        return this.getAttribute(BQSR_BASE_INSERTION_QUALITIES) != null || this.getAttribute(BQSR_BASE_DELETION_QUALITIES) != null;
    }

    public byte[] getExistingBaseInsertionQualities() {
        return SAMUtils.fastqToPhred(this.getStringAttribute(BQSR_BASE_INSERTION_QUALITIES));
    }

    public byte[] getExistingBaseDeletionQualities() {
        return SAMUtils.fastqToPhred(this.getStringAttribute(BQSR_BASE_DELETION_QUALITIES));
    }

    public byte[] getBaseInsertionQualities() {
        byte[] quals = this.getExistingBaseInsertionQualities();
        if (quals == null) {
            quals = new byte[this.getBaseQualities().length];
            Arrays.fill(quals, (byte)45);
        }
        return quals;
    }

    public byte[] getBaseDeletionQualities() {
        byte[] quals = this.getExistingBaseDeletionQualities();
        if (quals == null) {
            quals = new byte[this.getBaseQualities().length];
            Arrays.fill(quals, (byte)45);
        }
        return quals;
    }

    public NGSPlatform getNGSPlatform() {
        return this.getReadGroup().getNGSPlatform();
    }

    public boolean containsTemporaryAttribute(Object key) {
        return this.temporaryAttributes != null && this.temporaryAttributes.containsKey(key);
    }

    public Object setTemporaryAttribute(Object key, Object value) {
        if (this.temporaryAttributes == null) {
            this.temporaryAttributes = new HashMap<Object, Object>();
        }
        return this.temporaryAttributes.put(key, value);
    }

    public Object getTemporaryAttribute(Object key) {
        if (this.temporaryAttributes != null) {
            return this.temporaryAttributes.get(key);
        }
        return null;
    }

    public boolean isEmpty() {
        return super.getReadBases() == null || super.getReadLength() == 0;
    }

    public GATKSAMRecord simplify() {
        GATKSAMReadGroupRecord rg = this.getReadGroup();
        byte[] insQuals = this.getAttribute(BQSR_BASE_INSERTION_QUALITIES) == null ? null : this.getBaseInsertionQualities();
        byte[] delQuals = this.getAttribute(BQSR_BASE_DELETION_QUALITIES) == null ? null : this.getBaseDeletionQualities();
        this.clearAttributes();
        this.setReadGroup(rg);
        if (insQuals != null) {
            this.setBaseQualities(insQuals, EventType.BASE_INSERTION);
        }
        if (delQuals != null) {
            this.setBaseQualities(delQuals, EventType.BASE_DELETION);
        }
        return this;
    }

    public int getSoftStart() {
        if (this.softStart == -1) {
            this.softStart = this.getAlignmentStart();
            for (CigarElement cig : this.getCigar().getCigarElements()) {
                CigarOperator op = cig.getOperator();
                if (op == CigarOperator.SOFT_CLIP) {
                    this.softStart -= cig.getLength();
                    continue;
                }
                if (op == CigarOperator.HARD_CLIP) continue;
                break;
            }
        }
        return this.softStart;
    }

    public int getSoftEnd() {
        if (this.softEnd == -1) {
            boolean foundAlignedBase = false;
            this.softEnd = this.getAlignmentEnd();
            List<CigarElement> cigs = this.getCigar().getCigarElements();
            for (int i2 = cigs.size() - 1; i2 >= 0; --i2) {
                CigarElement cig = cigs.get(i2);
                CigarOperator op = cig.getOperator();
                if (op == CigarOperator.SOFT_CLIP) {
                    this.softEnd += cig.getLength();
                    continue;
                }
                if (op == CigarOperator.HARD_CLIP) continue;
                foundAlignedBase = true;
                break;
            }
            if (!foundAlignedBase) {
                this.softEnd = this.getAlignmentEnd();
            }
        }
        return this.softEnd;
    }

    public void resetSoftStartAndEnd() {
        this.softStart = -1;
        this.softEnd = -1;
    }

    public void resetSoftStartAndEnd(int softStart, int softEnd) {
        this.softStart = softStart;
        this.softEnd = softEnd;
    }

    public int getOriginalAlignmentStart() {
        return this.getUnclippedStart();
    }

    public int getOriginalAlignmentEnd() {
        return this.getUnclippedEnd();
    }

    public static GATKSAMRecord emptyRead(GATKSAMRecord read) {
        GATKSAMRecord emptyRead = new GATKSAMRecord(read.getHeader(), read.getReferenceIndex(), 0, 0, 0, 0, 0, read.getFlags(), 0, read.getMateReferenceIndex(), read.getMateAlignmentStart(), read.getInferredInsertSize(), null);
        emptyRead.setCigarString("");
        emptyRead.setReadBases(new byte[0]);
        emptyRead.setBaseQualities(new byte[0]);
        GATKSAMReadGroupRecord samRG = read.getReadGroup();
        emptyRead.clearAttributes();
        if (samRG != null) {
            GATKSAMReadGroupRecord rg = new GATKSAMReadGroupRecord(samRG);
            emptyRead.setReadGroup(rg);
        }
        return emptyRead;
    }

    public static GATKSAMRecord createQualityModifiedRead(GATKSAMRecord read, byte[] readBases, byte[] baseQualities, byte[] baseInsertionQualities, byte[] baseDeletionQualities) {
        if (baseQualities.length != readBases.length || baseInsertionQualities.length != readBases.length || baseDeletionQualities.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read quality arrays aren't the same size: Bases:" + readBases.length + " vs Base Q's:" + baseQualities.length + " vs Insert Q's:" + baseInsertionQualities.length + " vs Delete Q's:" + baseDeletionQualities.length);
        }
        GATKSAMRecord processedRead = GATKSAMRecord.emptyRead(read);
        processedRead.setReadBases(readBases);
        processedRead.setBaseQualities(baseQualities, EventType.BASE_SUBSTITUTION);
        processedRead.setBaseQualities(baseInsertionQualities, EventType.BASE_INSERTION);
        processedRead.setBaseQualities(baseDeletionQualities, EventType.BASE_DELETION);
        return processedRead;
    }

    @Override
    public Object clone() {
        try {
            GATKSAMRecord clone = (GATKSAMRecord)super.clone();
            if (this.temporaryAttributes != null) {
                clone.temporaryAttributes = new HashMap<Object, Object>();
                for (Object attribute : this.temporaryAttributes.keySet()) {
                    clone.setTemporaryAttribute(attribute, this.temporaryAttributes.get(attribute));
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Ensures(value={"result == ReadUtils.getAdaptorBoundary(this)"})
    public int getAdaptorBoundary() {
        if (this.adapterBoundary == null) {
            this.adapterBoundary = ReadUtils.getAdaptorBoundary(this);
        }
        return this.adapterBoundary;
    }
}

