/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import htsjdk.tribble.Feature;
import org.broad.igv.util.Utilities;

public class Range
implements Feature {
    protected String chr = null;
    protected int start = -1;
    protected int end = -1;

    public Range(String chr, int start, int end) {
        this.chr = chr;
        this.start = start;
        this.end = end;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public boolean contains(String chr, int start, int end) {
        return Utilities.objectEqual(this.chr, chr) && this.start <= (start < 0 ? 0 : start) && this.end >= end;
    }

    public boolean overlaps(String chr, int start, int end) {
        return Utilities.objectEqual(this.chr, chr) && this.start <= end && this.end >= start;
    }

    public boolean overlaps(Range range) {
        return this.overlaps(range.getChr(), range.getStart(), range.getEnd());
    }
}

