/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.awt.Color;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import org.broad.igv.Globals;
import org.broad.igv.feature.SeqLenAndBinnedPairs;
import org.broad.igv.feature.SeqLenAndPairs;
import org.broad.igv.feature.basepair.BasePairFeature;
import org.broad.igv.util.Utilities;

public class BasePairFileUtils {
    static LinkedList<BasePairFeature> transformArcs(LinkedList<BasePairFeature> arcs, int seqLen, int newLeft, String strand) {
        LinkedList<BasePairFeature> transArcs = new LinkedList<BasePairFeature>();
        for (BasePairFeature arc : arcs) {
            int endRight;
            int endLeft;
            int startRight;
            int startLeft;
            String chr = arc.getChr();
            int colorIndex = arc.getColorIndex();
            if (strand == "+") {
                startLeft = arc.getStartLeft() + newLeft - 1;
                startRight = arc.getStartRight() + newLeft - 1;
                endLeft = arc.getEndLeft() + newLeft - 1;
                endRight = arc.getEndRight() + newLeft - 1;
            } else if (strand == "-") {
                startLeft = seqLen - arc.getEndRight() + newLeft;
                startRight = seqLen - arc.getEndLeft() + newLeft;
                endLeft = seqLen - arc.getStartRight() + newLeft;
                endRight = seqLen - arc.getStartLeft() + newLeft;
            } else {
                throw new RuntimeException("Unrecognized strand (options: \"+\",\"-\")");
            }
            BasePairFeature transArc = new BasePairFeature(chr, startLeft, startRight, endLeft, endRight, colorIndex);
            transArcs.add(transArc);
        }
        return transArcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SeqLenAndPairs loadDotBracket(String inFile) throws FileNotFoundException, IOException {
        ArrayList<Point> pairs = new ArrayList<Point>();
        int seqLen = 0;
        BufferedReader br = null;
        try {
            int i2;
            String nextLine;
            br = new BufferedReader(new FileReader(inFile));
            String struct = "";
            while ((nextLine = br.readLine()) != null) {
                String s2;
                if (nextLine.startsWith(">") || nextLine.startsWith("#") || Utilities.isAllLetters(s2 = nextLine.trim())) continue;
                struct = struct + s2;
            }
            String leftBrackets = "([{<";
            String rightBrackets = ")]}>";
            ArrayList openIndices = new ArrayList();
            for (i2 = 0; i2 < leftBrackets.length(); ++i2) {
                openIndices.add(new LinkedList());
            }
            for (i2 = 0; i2 < struct.length(); ++i2) {
                int n2 = leftBrackets.indexOf(struct.charAt(i2));
                int k2 = rightBrackets.indexOf(struct.charAt(i2));
                if (n2 >= 0) {
                    ((LinkedList)openIndices.get(n2)).add(i2);
                    continue;
                }
                if (k2 < 0) continue;
                int left = i2 + 1;
                int right = (Integer)((LinkedList)openIndices.get(k2)).pollLast() + 1;
                pairs.add(new Point(left, right));
            }
            seqLen = struct.length();
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return new SeqLenAndPairs(seqLen, pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SeqLenAndPairs loadConnectTable(String inFile) throws FileNotFoundException, IOException {
        ArrayList<Point> pairs = new ArrayList<Point>();
        int seqLen = 0;
        BufferedReader br = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(inFile));
            seqLen = Integer.parseInt(Globals.whitespacePattern.split(br.readLine().trim())[0]);
            for (int n2 = 1; (nextLine = br.readLine()) != null && n2 <= seqLen; ++n2) {
                String[] s2 = Globals.whitespacePattern.split(nextLine.trim());
                int left = Integer.parseInt(s2[0]);
                int right = Integer.parseInt(s2[4]);
                if (right <= left) continue;
                pairs.add(new Point(left, right));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return new SeqLenAndPairs(seqLen, pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SeqLenAndBinnedPairs loadPairingProb(String inFile) throws FileNotFoundException, IOException {
        int i2;
        ArrayList<ArrayList<Point>> binnedPairs = new ArrayList<ArrayList<Point>>();
        int seqLen = 0;
        double[] probThresh = new double[]{0.1, 0.3, 0.8};
        double[] negLogTenProbThresh = new double[]{0.0, 0.0, 0.0};
        for (i2 = 0; i2 < probThresh.length; ++i2) {
            negLogTenProbThresh[i2] = -Math.log10(probThresh[i2]);
        }
        for (i2 = 0; i2 < probThresh.length; ++i2) {
            binnedPairs.add(new ArrayList());
        }
        BufferedReader br = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(inFile));
            seqLen = Integer.parseInt(Globals.whitespacePattern.split(br.readLine().trim())[0]);
            br.readLine();
            while ((nextLine = br.readLine()) != null) {
                String[] s2 = Globals.whitespacePattern.split(nextLine.trim());
                int left = Integer.parseInt(s2[0]);
                int right = Integer.parseInt(s2[1]);
                double negLogTenProb = Double.parseDouble(s2[2]);
                int binIndex = -1;
                for (int i3 = probThresh.length - 1; i3 >= 0; --i3) {
                    if (!(negLogTenProb <= negLogTenProbThresh[i3])) continue;
                    binIndex = i3;
                    break;
                }
                if (binIndex == -1) continue;
                binnedPairs.get(binIndex).add(new Point(left, right));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return new SeqLenAndBinnedPairs(seqLen, binnedPairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBasePairFile(String bpFile, ArrayList<Color> colors, ArrayList<String> colorLabels, ArrayList<LinkedList<BasePairFeature>> groupedArcs) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(bpFile)));
            for (int i2 = 0; i2 < colors.size(); ++i2) {
                Color color = colors.get(i2);
                String label = "";
                try {
                    label = colorLabels.get(i2);
                }
                catch (IndexOutOfBoundsException e2) {
                }
                catch (NullPointerException e3) {
                    // empty catch block
                }
                pw.println("color:\t" + color.getRed() + "\t" + color.getGreen() + "\t" + color.getBlue() + "\t" + label);
            }
            int colorIndex = 0;
            for (LinkedList<BasePairFeature> colorGroup : groupedArcs) {
                for (BasePairFeature arc : colorGroup) {
                    pw.println(arc.toString() + "\t" + colorIndex);
                }
                ++colorIndex;
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    static LinkedList<BasePairFeature> pairsToHelices(ArrayList<Point> pairs, String chromosome) {
        ArrayList<Point> bps = new ArrayList<Point>(pairs);
        LinkedList helixPairGroups = new LinkedList();
        while (bps.size() > 0) {
            ArrayList<Point> tmpBps;
            Point bp = bps.get(0);
            LinkedList<Point> helixPairs = new LinkedList<Point>();
            boolean[] blArray = new boolean[bps.size()];
            helixPairs.add(bp);
            blArray[0] = true;
            boolean endOfList = false;
            int i2 = 1;
            int skippedCount = 0;
            if (i2 < bps.size()) {
                while (bps.get((int)i2).x == bp.x) {
                    ++skippedCount;
                    if (++i2 < bps.size()) continue;
                    endOfList = true;
                    break;
                }
            } else {
                endOfList = true;
            }
            while (i2 < bps.size()) {
                if (bps.get((int)i2).x - bp.x > 1) {
                    helixPairGroups.add(helixPairs);
                    tmpBps = new ArrayList();
                    for (int k2 = 0; k2 < bps.size(); ++k2) {
                        if (blArray[k2]) continue;
                        tmpBps.add(bps.get(k2));
                    }
                    bps = tmpBps;
                    break;
                }
                if (bps.get((int)i2).y - bp.y == -1) {
                    bp = bps.get(i2);
                    helixPairs.add(bp);
                    blArray[i2] = true;
                }
                if (++i2 < bps.size()) continue;
                endOfList = true;
                break;
            }
            if (!endOfList) continue;
            helixPairGroups.add(helixPairs);
            tmpBps = new ArrayList<Point>();
            for (int k2 = 0; k2 < bps.size(); ++k2) {
                if (blArray[k2]) continue;
                tmpBps.add(bps.get(k2));
            }
            bps = tmpBps;
        }
        LinkedList<BasePairFeature> helices = new LinkedList<BasePairFeature>();
        for (LinkedList linkedList : helixPairGroups) {
            int startLeft = Integer.MAX_VALUE;
            int startRight = 0;
            int endLeft = Integer.MAX_VALUE;
            int endRight = 0;
            for (Point pair : linkedList) {
                if (pair.x < startLeft) {
                    startLeft = pair.x;
                }
                if (pair.x > startRight) {
                    startRight = pair.x;
                }
                if (pair.y < endLeft) {
                    endLeft = pair.y;
                }
                if (pair.y <= endRight) continue;
                endRight = pair.y;
            }
            helices.add(new BasePairFeature(chromosome, startLeft, startRight, endLeft, endRight, 0));
        }
        return helices;
    }

    public static void dotBracketToBasePairFile(String inFile, String bpFile, String chromosome, String strand, int left) throws FileNotFoundException, IOException {
        SeqLenAndPairs s2 = BasePairFileUtils.loadDotBracket(inFile);
        ArrayList<Point> pairs = s2.pairs;
        int seqLen = s2.seqLen;
        LinkedList<BasePairFeature> arcs = BasePairFileUtils.pairsToHelices(pairs, chromosome);
        arcs = BasePairFileUtils.transformArcs(arcs, seqLen, left, strand);
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.black);
        ArrayList<LinkedList<BasePairFeature>> groupedArcs = new ArrayList<LinkedList<BasePairFeature>>();
        groupedArcs.add(arcs);
        BasePairFileUtils.writeBasePairFile(bpFile, colors, null, groupedArcs);
    }

    public static void connectTableToBasePairFile(String inFile, String bpFile, String chromosome, String strand, int left) throws FileNotFoundException, IOException {
        SeqLenAndPairs s2 = BasePairFileUtils.loadConnectTable(inFile);
        ArrayList<Point> pairs = s2.pairs;
        int seqLen = s2.seqLen;
        LinkedList<BasePairFeature> arcs = BasePairFileUtils.pairsToHelices(pairs, chromosome);
        arcs = BasePairFileUtils.transformArcs(arcs, seqLen, left, strand);
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.black);
        ArrayList<LinkedList<BasePairFeature>> groupedArcs = new ArrayList<LinkedList<BasePairFeature>>();
        groupedArcs.add(arcs);
        BasePairFileUtils.writeBasePairFile(bpFile, colors, null, groupedArcs);
    }

    public static void pairingProbToBasePairFile(String inFile, String bpFile, String chromosome, String strand, int left) throws FileNotFoundException, IOException {
        SeqLenAndBinnedPairs s2 = BasePairFileUtils.loadPairingProb(inFile);
        ArrayList<ArrayList<Point>> binnedPairs = s2.binnedPairs;
        int seqLen = s2.seqLen;
        ArrayList<LinkedList<BasePairFeature>> groupedArcs = new ArrayList<LinkedList<BasePairFeature>>();
        for (ArrayList<Point> pairGroup : binnedPairs) {
            groupedArcs.add(BasePairFileUtils.transformArcs(BasePairFileUtils.pairsToHelices(pairGroup, chromosome), seqLen, left, strand));
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(255, 218, 125));
        colors.add(new Color(113, 195, 209));
        colors.add(new Color(51, 114, 38));
        ArrayList<String> colorLabels = new ArrayList<String>();
        colorLabels.add("PP 10 - 30%");
        colorLabels.add("PP 30 - 80%");
        colorLabels.add("Pairing probability > 80%");
        BasePairFileUtils.writeBasePairFile(bpFile, colors, colorLabels, groupedArcs);
    }
}

