/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.AbstractRealVector;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.RealVectorFormat;
import org.apache.commons.math.util.FastMath;
import org.apache.commons.math.util.MathUtils;

public class ArrayRealVector
extends AbstractRealVector
implements Serializable {
    private static final long serialVersionUID = -1097961340710804027L;
    private static final RealVectorFormat DEFAULT_FORMAT = RealVectorFormat.getInstance();
    protected double[] data;

    public ArrayRealVector() {
        this.data = new double[0];
    }

    public ArrayRealVector(int size) {
        this.data = new double[size];
    }

    public ArrayRealVector(int size, double preset) {
        this.data = new double[size];
        Arrays.fill(this.data, preset);
    }

    public ArrayRealVector(double[] d2) {
        this.data = (double[])d2.clone();
    }

    public ArrayRealVector(double[] d2, boolean copyArray) {
        this.data = copyArray ? (double[])d2.clone() : d2;
    }

    public ArrayRealVector(double[] d2, int pos, int size) {
        if (d2.length < pos + size) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POSITION_SIZE_MISMATCH_INPUT_ARRAY, pos, size, d2.length);
        }
        this.data = new double[size];
        System.arraycopy(d2, pos, this.data, 0, size);
    }

    public ArrayRealVector(Double[] d2) {
        this.data = new double[d2.length];
        for (int i2 = 0; i2 < d2.length; ++i2) {
            this.data[i2] = d2[i2];
        }
    }

    public ArrayRealVector(Double[] d2, int pos, int size) {
        if (d2.length < pos + size) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POSITION_SIZE_MISMATCH_INPUT_ARRAY, pos, size, d2.length);
        }
        this.data = new double[size];
        for (int i2 = pos; i2 < pos + size; ++i2) {
            this.data[i2 - pos] = d2[i2];
        }
    }

    public ArrayRealVector(RealVector v2) {
        this.data = new double[v2.getDimension()];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = v2.getEntry(i2);
        }
    }

    public ArrayRealVector(ArrayRealVector v2) {
        this(v2, true);
    }

    public ArrayRealVector(ArrayRealVector v2, boolean deep) {
        this.data = deep ? (double[])v2.data.clone() : v2.data;
    }

    public ArrayRealVector(ArrayRealVector v1, ArrayRealVector v2) {
        this.data = new double[v1.data.length + v2.data.length];
        System.arraycopy(v1.data, 0, this.data, 0, v1.data.length);
        System.arraycopy(v2.data, 0, this.data, v1.data.length, v2.data.length);
    }

    public ArrayRealVector(ArrayRealVector v1, RealVector v2) {
        int l1 = v1.data.length;
        int l2 = v2.getDimension();
        this.data = new double[l1 + l2];
        System.arraycopy(v1.data, 0, this.data, 0, l1);
        for (int i2 = 0; i2 < l2; ++i2) {
            this.data[l1 + i2] = v2.getEntry(i2);
        }
    }

    public ArrayRealVector(RealVector v1, ArrayRealVector v2) {
        int l1 = v1.getDimension();
        int l2 = v2.data.length;
        this.data = new double[l1 + l2];
        for (int i2 = 0; i2 < l1; ++i2) {
            this.data[i2] = v1.getEntry(i2);
        }
        System.arraycopy(v2.data, 0, this.data, l1, l2);
    }

    public ArrayRealVector(ArrayRealVector v1, double[] v2) {
        int l1 = v1.getDimension();
        int l2 = v2.length;
        this.data = new double[l1 + l2];
        System.arraycopy(v1.data, 0, this.data, 0, l1);
        System.arraycopy(v2, 0, this.data, l1, l2);
    }

    public ArrayRealVector(double[] v1, ArrayRealVector v2) {
        int l1 = v1.length;
        int l2 = v2.getDimension();
        this.data = new double[l1 + l2];
        System.arraycopy(v1, 0, this.data, 0, l1);
        System.arraycopy(v2.data, 0, this.data, l1, l2);
    }

    public ArrayRealVector(double[] v1, double[] v2) {
        int l1 = v1.length;
        int l2 = v2.length;
        this.data = new double[l1 + l2];
        System.arraycopy(v1, 0, this.data, 0, l1);
        System.arraycopy(v2, 0, this.data, l1, l2);
    }

    public AbstractRealVector copy() {
        return new ArrayRealVector(this, true);
    }

    public RealVector add(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        if (v2 instanceof ArrayRealVector) {
            return this.add((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        double[] out = (double[])this.data.clone();
        Iterator<RealVector.Entry> it = v2.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            int n2 = e2.getIndex();
            out[n2] = out[n2] + e2.getValue();
        }
        return new ArrayRealVector(out, false);
    }

    public RealVector add(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        double[] out = (double[])this.data.clone();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            out[n2] = out[n2] + v2[i2];
        }
        return new ArrayRealVector(out, false);
    }

    public ArrayRealVector add(ArrayRealVector v2) throws IllegalArgumentException {
        return (ArrayRealVector)this.add(v2.data);
    }

    public RealVector subtract(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        if (v2 instanceof ArrayRealVector) {
            return this.subtract((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        double[] out = (double[])this.data.clone();
        Iterator<RealVector.Entry> it = v2.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            int n2 = e2.getIndex();
            out[n2] = out[n2] - e2.getValue();
        }
        return new ArrayRealVector(out, false);
    }

    public RealVector subtract(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        double[] out = (double[])this.data.clone();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            out[n2] = out[n2] - v2[i2];
        }
        return new ArrayRealVector(out, false);
    }

    public ArrayRealVector subtract(ArrayRealVector v2) throws IllegalArgumentException {
        return (ArrayRealVector)this.subtract(v2.data);
    }

    public RealVector mapAddToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = this.data[i2] + d2;
        }
        return this;
    }

    public RealVector mapSubtractToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = this.data[i2] - d2;
        }
        return this;
    }

    public RealVector mapMultiplyToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = this.data[i2] * d2;
        }
        return this;
    }

    public RealVector mapDivideToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = this.data[i2] / d2;
        }
        return this;
    }

    public RealVector mapPowToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.pow(this.data[i2], d2);
        }
        return this;
    }

    public RealVector mapExpToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.exp(this.data[i2]);
        }
        return this;
    }

    public RealVector mapExpm1ToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.expm1(this.data[i2]);
        }
        return this;
    }

    public RealVector mapLogToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.log(this.data[i2]);
        }
        return this;
    }

    public RealVector mapLog10ToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.log10(this.data[i2]);
        }
        return this;
    }

    public RealVector mapLog1pToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.log1p(this.data[i2]);
        }
        return this;
    }

    public RealVector mapCoshToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.cosh(this.data[i2]);
        }
        return this;
    }

    public RealVector mapSinhToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.sinh(this.data[i2]);
        }
        return this;
    }

    public RealVector mapTanhToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.tanh(this.data[i2]);
        }
        return this;
    }

    public RealVector mapCosToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.cos(this.data[i2]);
        }
        return this;
    }

    public RealVector mapSinToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.sin(this.data[i2]);
        }
        return this;
    }

    public RealVector mapTanToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.tan(this.data[i2]);
        }
        return this;
    }

    public RealVector mapAcosToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.acos(this.data[i2]);
        }
        return this;
    }

    public RealVector mapAsinToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.asin(this.data[i2]);
        }
        return this;
    }

    public RealVector mapAtanToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.atan(this.data[i2]);
        }
        return this;
    }

    public RealVector mapInvToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = 1.0 / this.data[i2];
        }
        return this;
    }

    public RealVector mapAbsToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.abs(this.data[i2]);
        }
        return this;
    }

    public RealVector mapSqrtToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.sqrt(this.data[i2]);
        }
        return this;
    }

    public RealVector mapCbrtToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.cbrt(this.data[i2]);
        }
        return this;
    }

    public RealVector mapCeilToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.ceil(this.data[i2]);
        }
        return this;
    }

    public RealVector mapFloorToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.floor(this.data[i2]);
        }
        return this;
    }

    public RealVector mapRintToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.rint(this.data[i2]);
        }
        return this;
    }

    public RealVector mapSignumToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.signum(this.data[i2]);
        }
        return this;
    }

    public RealVector mapUlpToSelf() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = FastMath.ulp(this.data[i2]);
        }
        return this;
    }

    public RealVector ebeMultiply(RealVector v2) throws IllegalArgumentException {
        if (v2 instanceof ArrayRealVector) {
            return this.ebeMultiply((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        double[] out = (double[])this.data.clone();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            out[n2] = out[n2] * v2.getEntry(i2);
        }
        return new ArrayRealVector(out, false);
    }

    public RealVector ebeMultiply(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        double[] out = (double[])this.data.clone();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            out[n2] = out[n2] * v2[i2];
        }
        return new ArrayRealVector(out, false);
    }

    public ArrayRealVector ebeMultiply(ArrayRealVector v2) throws IllegalArgumentException {
        return (ArrayRealVector)this.ebeMultiply(v2.data);
    }

    public RealVector ebeDivide(RealVector v2) throws IllegalArgumentException {
        if (v2 instanceof ArrayRealVector) {
            return this.ebeDivide((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        double[] out = (double[])this.data.clone();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            out[n2] = out[n2] / v2.getEntry(i2);
        }
        return new ArrayRealVector(out, false);
    }

    public RealVector ebeDivide(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        double[] out = (double[])this.data.clone();
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n2 = i2;
            out[n2] = out[n2] / v2[i2];
        }
        return new ArrayRealVector(out, false);
    }

    public ArrayRealVector ebeDivide(ArrayRealVector v2) throws IllegalArgumentException {
        return (ArrayRealVector)this.ebeDivide(v2.data);
    }

    public double[] getData() {
        return (double[])this.data.clone();
    }

    public double[] getDataRef() {
        return this.data;
    }

    public double dotProduct(RealVector v2) throws IllegalArgumentException {
        RealVector.Entry e2;
        if (v2 instanceof ArrayRealVector) {
            return this.dotProduct((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        double dot = 0.0;
        Iterator<RealVector.Entry> it = v2.sparseIterator();
        while (it.hasNext() && (e2 = it.next()) != null) {
            dot += this.data[e2.getIndex()] * e2.getValue();
        }
        return dot;
    }

    public double dotProduct(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        double dot = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            dot += this.data[i2] * v2[i2];
        }
        return dot;
    }

    public double dotProduct(ArrayRealVector v2) throws IllegalArgumentException {
        return this.dotProduct(v2.data);
    }

    public double getNorm() {
        double sum = 0.0;
        for (double a2 : this.data) {
            sum += a2 * a2;
        }
        return FastMath.sqrt(sum);
    }

    public double getL1Norm() {
        double sum = 0.0;
        for (double a2 : this.data) {
            sum += FastMath.abs(a2);
        }
        return sum;
    }

    public double getLInfNorm() {
        double max = 0.0;
        for (double a2 : this.data) {
            max = FastMath.max(max, FastMath.abs(a2));
        }
        return max;
    }

    public double getDistance(RealVector v2) throws IllegalArgumentException {
        if (v2 instanceof ArrayRealVector) {
            return this.getDistance((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        double sum = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            double delta = this.data[i2] - v2.getEntry(i2);
            sum += delta * delta;
        }
        return FastMath.sqrt(sum);
    }

    public double getDistance(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        double sum = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            double delta = this.data[i2] - v2[i2];
            sum += delta * delta;
        }
        return FastMath.sqrt(sum);
    }

    public double getDistance(ArrayRealVector v2) throws IllegalArgumentException {
        return this.getDistance(v2.data);
    }

    public double getL1Distance(RealVector v2) throws IllegalArgumentException {
        if (v2 instanceof ArrayRealVector) {
            return this.getL1Distance((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        double sum = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            double delta = this.data[i2] - v2.getEntry(i2);
            sum += FastMath.abs(delta);
        }
        return sum;
    }

    public double getL1Distance(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        double sum = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            double delta = this.data[i2] - v2[i2];
            sum += FastMath.abs(delta);
        }
        return sum;
    }

    public double getL1Distance(ArrayRealVector v2) throws IllegalArgumentException {
        return this.getL1Distance(v2.data);
    }

    public double getLInfDistance(RealVector v2) throws IllegalArgumentException {
        if (v2 instanceof ArrayRealVector) {
            return this.getLInfDistance((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        double max = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            double delta = this.data[i2] - v2.getEntry(i2);
            max = FastMath.max(max, FastMath.abs(delta));
        }
        return max;
    }

    public double getLInfDistance(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        double max = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            double delta = this.data[i2] - v2[i2];
            max = FastMath.max(max, FastMath.abs(delta));
        }
        return max;
    }

    public double getLInfDistance(ArrayRealVector v2) throws IllegalArgumentException {
        return this.getLInfDistance(v2.data);
    }

    public RealVector unitVector() throws ArithmeticException {
        double norm = this.getNorm();
        if (norm == 0.0) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return this.mapDivide(norm);
    }

    public void unitize() throws ArithmeticException {
        double norm = this.getNorm();
        if (norm == 0.0) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        this.mapDivideToSelf(norm);
    }

    public RealVector projection(RealVector v2) {
        return v2.mapMultiply(this.dotProduct(v2) / v2.dotProduct(v2));
    }

    public RealVector projection(double[] v2) {
        return this.projection(new ArrayRealVector(v2, false));
    }

    public ArrayRealVector projection(ArrayRealVector v2) {
        return (ArrayRealVector)v2.mapMultiply(this.dotProduct(v2) / v2.dotProduct(v2));
    }

    public RealMatrix outerProduct(RealVector v2) throws IllegalArgumentException {
        if (v2 instanceof ArrayRealVector) {
            return this.outerProduct((ArrayRealVector)v2);
        }
        this.checkVectorDimensions(v2);
        int m2 = this.data.length;
        RealMatrix out = MatrixUtils.createRealMatrix(m2, m2);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (int j2 = 0; j2 < this.data.length; ++j2) {
                out.setEntry(i2, j2, this.data[i2] * v2.getEntry(j2));
            }
        }
        return out;
    }

    public RealMatrix outerProduct(ArrayRealVector v2) throws IllegalArgumentException {
        return this.outerProduct(v2.data);
    }

    public RealMatrix outerProduct(double[] v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.length);
        int m2 = this.data.length;
        RealMatrix out = MatrixUtils.createRealMatrix(m2, m2);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (int j2 = 0; j2 < this.data.length; ++j2) {
                out.setEntry(i2, j2, this.data[i2] * v2[j2]);
            }
        }
        return out;
    }

    public double getEntry(int index) throws MatrixIndexException {
        return this.data[index];
    }

    public int getDimension() {
        return this.data.length;
    }

    public RealVector append(RealVector v2) {
        try {
            return new ArrayRealVector(this, (ArrayRealVector)v2);
        }
        catch (ClassCastException cce) {
            return new ArrayRealVector(this, v2);
        }
    }

    public ArrayRealVector append(ArrayRealVector v2) {
        return new ArrayRealVector(this, v2);
    }

    public RealVector append(double in) {
        double[] out = new double[this.data.length + 1];
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        out[this.data.length] = in;
        return new ArrayRealVector(out, false);
    }

    public RealVector append(double[] in) {
        return new ArrayRealVector(this, in);
    }

    public RealVector getSubVector(int index, int n2) {
        ArrayRealVector out = new ArrayRealVector(n2);
        try {
            System.arraycopy(this.data, index, out.data, 0, n2);
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
            this.checkIndex(index + n2 - 1);
        }
        return out;
    }

    public void setEntry(int index, double value) {
        try {
            this.data[index] = value;
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
        }
    }

    public void setSubVector(int index, RealVector v2) {
        try {
            try {
                this.set(index, (ArrayRealVector)v2);
            }
            catch (ClassCastException cce) {
                for (int i2 = index; i2 < index + v2.getDimension(); ++i2) {
                    this.data[i2] = v2.getEntry(i2 - index);
                }
            }
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
            this.checkIndex(index + v2.getDimension() - 1);
        }
    }

    public void setSubVector(int index, double[] v2) {
        try {
            System.arraycopy(v2, 0, this.data, index, v2.length);
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
            this.checkIndex(index + v2.length - 1);
        }
    }

    public void set(int index, ArrayRealVector v2) throws MatrixIndexException {
        this.setSubVector(index, v2.data);
    }

    public void set(double value) {
        Arrays.fill(this.data, value);
    }

    public double[] toArray() {
        return (double[])this.data.clone();
    }

    public String toString() {
        return DEFAULT_FORMAT.format(this);
    }

    protected void checkVectorDimensions(RealVector v2) throws IllegalArgumentException {
        this.checkVectorDimensions(v2.getDimension());
    }

    protected void checkVectorDimensions(int n2) throws IllegalArgumentException {
        if (this.data.length != n2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, this.data.length, n2);
        }
    }

    public boolean isNaN() {
        for (double v2 : this.data) {
            if (!Double.isNaN(v2)) continue;
            return true;
        }
        return false;
    }

    public boolean isInfinite() {
        if (this.isNaN()) {
            return false;
        }
        for (double v2 : this.data) {
            if (!Double.isInfinite(v2)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof RealVector)) {
            return false;
        }
        RealVector rhs = (RealVector)other;
        if (this.data.length != rhs.getDimension()) {
            return false;
        }
        if (rhs.isNaN()) {
            return this.isNaN();
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            if (this.data[i2] == rhs.getEntry(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 9;
        }
        return MathUtils.hash(this.data);
    }
}

