/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util;

public class MathUtils {

    public static class RunningStat {
        private double oldMean;
        private double newMean;
        private double oldStdDev;
        private double newStdDev;
        private long recordCount = 0L;

        public void push(double x2) {
            ++this.recordCount;
            if (this.recordCount == 1L) {
                this.oldMean = this.newMean = x2;
                this.oldStdDev = 0.0;
            } else {
                this.newMean = this.oldMean + (x2 - this.oldMean) / (double)this.recordCount;
                this.newStdDev = this.oldStdDev + (x2 - this.oldMean) * (x2 - this.newMean);
                this.oldMean = this.newMean;
                this.oldStdDev = this.newStdDev;
            }
        }

        public void clear() {
            this.recordCount = 0L;
        }

        public final long numDataValues() {
            return this.recordCount;
        }

        public final double mean() {
            return this.recordCount > 0L ? this.newMean : 0.0;
        }

        public double variance() {
            return this.recordCount > 1L ? this.newStdDev / (double)(this.recordCount - 1L) : 0.0;
        }

        public double standardDeviation() {
            return Math.sqrt(this.variance());
        }
    }
}

