/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.event.VertexSetListener;
import org.jgrapht.graph.GraphDelegator;
import org.jgrapht.util.TypeUtil;

public class DefaultListenableGraph<V, E>
extends GraphDelegator<V, E>
implements ListenableGraph<V, E>,
Cloneable {
    private static final long serialVersionUID = 3977575900898471984L;
    private ArrayList<GraphListener<V, E>> graphListeners = new ArrayList();
    private ArrayList<VertexSetListener<V>> vertexSetListeners = new ArrayList();
    private FlyweightEdgeEvent<V, E> reuseableEdgeEvent;
    private FlyweightVertexEvent<V> reuseableVertexEvent;
    private boolean reuseEvents;

    public DefaultListenableGraph(Graph<V, E> graph) {
        this(graph, false);
    }

    public DefaultListenableGraph(Graph<V, E> graph, boolean bl) {
        super(graph);
        this.reuseEvents = bl;
        this.reuseableEdgeEvent = new FlyweightEdgeEvent((Object)this, -1, null);
        this.reuseableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, -1, null);
        if (graph instanceof ListenableGraph) {
            throw new IllegalArgumentException("base graph cannot be listenable");
        }
    }

    public void setReuseEvents(boolean bl) {
        this.reuseEvents = bl;
    }

    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public E addEdge(V v2, V v3) {
        Object e2 = super.addEdge(v2, v3);
        if (e2 != null) {
            this.fireEdgeAdded(e2);
        }
        return e2;
    }

    @Override
    public boolean addEdge(V v2, V v3, E e2) {
        boolean bl = super.addEdge(v2, v3, e2);
        if (bl) {
            this.fireEdgeAdded(e2);
        }
        return bl;
    }

    @Override
    public void addGraphListener(GraphListener<V, E> graphListener) {
        DefaultListenableGraph.addToListenerList(this.graphListeners, graphListener);
    }

    @Override
    public boolean addVertex(V v2) {
        boolean bl = super.addVertex(v2);
        if (bl) {
            this.fireVertexAdded(v2);
        }
        return bl;
    }

    @Override
    public void addVertexSetListener(VertexSetListener<V> vertexSetListener) {
        DefaultListenableGraph.addToListenerList(this.vertexSetListeners, vertexSetListener);
    }

    public Object clone() {
        try {
            TypeUtil typeUtil = null;
            DefaultListenableGraph defaultListenableGraph = (DefaultListenableGraph)TypeUtil.uncheckedCast(super.clone(), typeUtil);
            defaultListenableGraph.graphListeners = new ArrayList();
            defaultListenableGraph.vertexSetListeners = new ArrayList();
            return defaultListenableGraph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException("internal error");
        }
    }

    @Override
    public E removeEdge(V v2, V v3) {
        Object e2 = super.removeEdge(v2, v3);
        if (e2 != null) {
            this.fireEdgeRemoved(e2);
        }
        return e2;
    }

    @Override
    public boolean removeEdge(E e2) {
        boolean bl = super.removeEdge(e2);
        if (bl) {
            this.fireEdgeRemoved(e2);
        }
        return bl;
    }

    @Override
    public void removeGraphListener(GraphListener<V, E> graphListener) {
        this.graphListeners.remove(graphListener);
    }

    @Override
    public boolean removeVertex(V v2) {
        if (this.containsVertex(v2)) {
            Set set = this.edgesOf(v2);
            this.removeAllEdges(new ArrayList(set));
            super.removeVertex(v2);
            this.fireVertexRemoved(v2);
            return true;
        }
        return false;
    }

    @Override
    public void removeVertexSetListener(VertexSetListener<V> vertexSetListener) {
        this.vertexSetListeners.remove(vertexSetListener);
    }

    protected void fireEdgeAdded(E e2) {
        GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent = this.createGraphEdgeChangeEvent(23, e2);
        for (int i2 = 0; i2 < this.graphListeners.size(); ++i2) {
            GraphListener<V, E> graphListener = this.graphListeners.get(i2);
            graphListener.edgeAdded(graphEdgeChangeEvent);
        }
    }

    protected void fireEdgeRemoved(E e2) {
        GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent = this.createGraphEdgeChangeEvent(24, e2);
        for (int i2 = 0; i2 < this.graphListeners.size(); ++i2) {
            GraphListener<V, E> graphListener = this.graphListeners.get(i2);
            graphListener.edgeRemoved(graphEdgeChangeEvent);
        }
    }

    protected void fireVertexAdded(V v2) {
        VertexSetListener<V> vertexSetListener;
        int n2;
        GraphVertexChangeEvent<V> graphVertexChangeEvent = this.createGraphVertexChangeEvent(13, v2);
        for (n2 = 0; n2 < this.vertexSetListeners.size(); ++n2) {
            vertexSetListener = this.vertexSetListeners.get(n2);
            vertexSetListener.vertexAdded(graphVertexChangeEvent);
        }
        for (n2 = 0; n2 < this.graphListeners.size(); ++n2) {
            vertexSetListener = this.graphListeners.get(n2);
            vertexSetListener.vertexAdded(graphVertexChangeEvent);
        }
    }

    protected void fireVertexRemoved(V v2) {
        VertexSetListener<V> vertexSetListener;
        int n2;
        GraphVertexChangeEvent<V> graphVertexChangeEvent = this.createGraphVertexChangeEvent(14, v2);
        for (n2 = 0; n2 < this.vertexSetListeners.size(); ++n2) {
            vertexSetListener = this.vertexSetListeners.get(n2);
            vertexSetListener.vertexRemoved(graphVertexChangeEvent);
        }
        for (n2 = 0; n2 < this.graphListeners.size(); ++n2) {
            vertexSetListener = this.graphListeners.get(n2);
            vertexSetListener.vertexRemoved(graphVertexChangeEvent);
        }
    }

    private static <L extends EventListener> void addToListenerList(List<L> list, L l2) {
        if (!list.contains(l2)) {
            list.add(l2);
        }
    }

    private GraphEdgeChangeEvent<V, E> createGraphEdgeChangeEvent(int n2, E e2) {
        if (this.reuseEvents) {
            this.reuseableEdgeEvent.setType(n2);
            this.reuseableEdgeEvent.setEdge(e2);
            return this.reuseableEdgeEvent;
        }
        return new GraphEdgeChangeEvent(this, n2, e2);
    }

    private GraphVertexChangeEvent<V> createGraphVertexChangeEvent(int n2, V v2) {
        if (this.reuseEvents) {
            this.reuseableVertexEvent.setType(n2);
            this.reuseableVertexEvent.setVertex(v2);
            return this.reuseableVertexEvent;
        }
        return new GraphVertexChangeEvent<V>(this, n2, v2);
    }

    private static class FlyweightVertexEvent<VV>
    extends GraphVertexChangeEvent<VV> {
        private static final long serialVersionUID = 3257848787857585716L;

        public FlyweightVertexEvent(Object object, int n2, VV VV) {
            super(object, n2, VV);
        }

        protected void setType(int n2) {
            this.type = n2;
        }

        protected void setVertex(VV VV) {
            this.vertex = VV;
        }
    }

    private static class FlyweightEdgeEvent<VV, EE>
    extends GraphEdgeChangeEvent<VV, EE> {
        private static final long serialVersionUID = 3907207152526636089L;

        public FlyweightEdgeEvent(Object object, int n2, EE EE) {
            super(object, n2, EE);
        }

        protected void setEdge(EE EE) {
            this.edge = EE;
        }

        protected void setType(int n2) {
            this.type = n2;
        }
    }
}

