/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.UndirectedMaskSubgraph;

public class BlockCutpointGraph<V, E>
extends SimpleGraph<UndirectedGraph<V, E>, DefaultEdge> {
    private static final long serialVersionUID = -9101341117013163934L;
    private Set<V> cutpoints = new HashSet<V>();
    private DirectedGraph<V, DefaultEdge> dfsTree;
    private UndirectedGraph<V, E> graph;
    private int numOrder;
    private Deque<BCGEdge> stack = new ArrayDeque<BCGEdge>();
    private Map<V, Set<UndirectedGraph<V, E>>> vertex2biconnectedSubgraphs = new HashMap<V, Set<UndirectedGraph<V, E>>>();
    private Map<V, UndirectedGraph<V, E>> vertex2block = new HashMap<V, UndirectedGraph<V, E>>();
    private Map<V, Integer> vertex2numOrder = new HashMap<V, Integer>();

    public BlockCutpointGraph(UndirectedGraph<V, E> undirectedGraph) {
        super(DefaultEdge.class);
        this.graph = undirectedGraph;
        this.dfsTree = new SimpleDirectedGraph(DefaultEdge.class);
        Object v2 = undirectedGraph.vertexSet().iterator().next();
        this.dfsTree.addVertex(v2);
        this.dfsVisit(v2, v2);
        if (this.dfsTree.edgesOf(v2).size() > 1) {
            this.cutpoints.add(v2);
        } else {
            this.cutpoints.remove(v2);
        }
        for (V v3 : this.cutpoints) {
            SimpleGraph simpleGraph = new SimpleGraph(this.graph.getEdgeFactory());
            simpleGraph.addVertex(v3);
            this.vertex2block.put(v3, simpleGraph);
            this.addVertex(simpleGraph);
            Set<UndirectedGraph<V, E>> set = this.getBiconnectedSubgraphs(v3);
            for (UndirectedGraph<V, E> undirectedGraph2 : set) {
                assert (this.vertexSet().contains(undirectedGraph2));
                this.addEdge(simpleGraph, undirectedGraph2);
            }
        }
    }

    public UndirectedGraph<V, E> getBlock(V v2) {
        if (!this.graph.vertexSet().contains(v2)) {
            throw new IllegalArgumentException("No such vertex in the graph!");
        }
        return this.vertex2block.get(v2);
    }

    public Set<V> getCutpoints() {
        return this.cutpoints;
    }

    public boolean isCutpoint(V v2) {
        if (!this.graph.vertexSet().contains(v2)) {
            throw new IllegalArgumentException("No such vertex in the graph!");
        }
        return this.cutpoints.contains(v2);
    }

    private void biconnectedComponentFinished(V v2, V v3) {
        this.cutpoints.add(v2);
        HashSet hashSet = new HashSet();
        HashSet<BCGEdge> hashSet2 = new HashSet<BCGEdge>();
        BCGEdge bCGEdge = this.stack.removeLast();
        while (this.getNumOrder(bCGEdge.getSource()) >= this.getNumOrder(v3) && !this.stack.isEmpty()) {
            hashSet2.add(bCGEdge);
            hashSet.add(bCGEdge.getSource());
            hashSet.add(bCGEdge.getTarget());
            bCGEdge = this.stack.removeLast();
        }
        hashSet2.add(bCGEdge);
        hashSet.add(bCGEdge.getSource());
        hashSet.add(bCGEdge.getTarget());
        VertexComponentForbiddenFunction vertexComponentForbiddenFunction = new VertexComponentForbiddenFunction(hashSet);
        UndirectedMaskSubgraph<V, E> undirectedMaskSubgraph = new UndirectedMaskSubgraph<V, E>(this.graph, vertexComponentForbiddenFunction);
        for (Object e2 : hashSet) {
            this.vertex2block.put((UndirectedMaskSubgraph<V, E>)e2, (UndirectedGraph<UndirectedMaskSubgraph<V, E>, E>)undirectedMaskSubgraph);
            this.getBiconnectedSubgraphs(e2).add(undirectedMaskSubgraph);
        }
        this.addVertex(undirectedMaskSubgraph);
    }

    private int dfsVisit(V v2, V v3) {
        ++this.numOrder;
        int n2 = this.numOrder;
        this.setNumOrder(v2, this.numOrder);
        for (Object e2 : this.graph.edgesOf(v2)) {
            BCGEdge bCGEdge;
            V v4 = Graphs.getOppositeVertex(this.graph, e2, v2);
            if (this.getNumOrder(v4) == 0) {
                this.dfsTree.addVertex(v4);
                bCGEdge = new BCGEdge(v2, v4);
                this.dfsTree.addEdge(v2, v4, bCGEdge);
                this.stack.add(bCGEdge);
                int n3 = this.dfsVisit(v4, v2);
                n2 = Math.min(n3, n2);
                if (n3 < this.getNumOrder(v2)) continue;
                this.biconnectedComponentFinished(v2, v4);
                continue;
            }
            if (this.getNumOrder(v4) >= this.getNumOrder(v2) || v4.equals(v3)) continue;
            bCGEdge = new BCGEdge(v2, v4);
            this.stack.add(bCGEdge);
            n2 = Math.min(this.getNumOrder(v4), n2);
        }
        return n2;
    }

    private Set<UndirectedGraph<V, E>> getBiconnectedSubgraphs(V v2) {
        Set<UndirectedGraph<V, E>> set = this.vertex2biconnectedSubgraphs.get(v2);
        if (set == null) {
            set = new HashSet<UndirectedGraph<V, E>>();
            this.vertex2biconnectedSubgraphs.put((Set<UndirectedGraph<V, E>>)v2, (Set<UndirectedGraph<Set<UndirectedGraph<V, E>>, E>>)set);
        }
        return set;
    }

    private int getNumOrder(V v2) {
        assert (v2 != null);
        Integer n2 = this.vertex2numOrder.get(v2);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    private void setNumOrder(V v2, int n2) {
        this.vertex2numOrder.put((Integer)v2, n2);
    }

    private class VertexComponentForbiddenFunction
    implements MaskFunctor<V, E> {
        private Set<V> vertexComponent;

        public VertexComponentForbiddenFunction(Set<V> set) {
            this.vertexComponent = set;
        }

        @Override
        public boolean isEdgeMasked(E e2) {
            return false;
        }

        @Override
        public boolean isVertexMasked(V v2) {
            return !this.vertexComponent.contains(v2);
        }
    }

    private class BCGEdge
    extends DefaultEdge {
        private static final long serialVersionUID = -5115006161815760059L;
        private V source;
        private V target;

        public BCGEdge(V v2, V v3) {
            this.source = v2;
            this.target = v3;
        }

        public V getSource() {
            return this.source;
        }

        public V getTarget() {
            return this.target;
        }
    }
}

