/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.smithwaterman;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.broadinstitute.gatk.utils.exceptions.GATKException;
import org.broadinstitute.gatk.utils.sam.AlignmentUtils;
import org.broadinstitute.gatk.utils.smithwaterman.Parameters;
import org.broadinstitute.gatk.utils.smithwaterman.SWParameterSet;
import org.broadinstitute.gatk.utils.smithwaterman.SmithWaterman;

public class SWPairwiseAlignment
implements SmithWaterman {
    protected SWPairwiseAlignmentResult alignmentResult;
    protected final Parameters parameters;
    protected static boolean cutoff = false;
    protected OVERHANG_STRATEGY overhang_strategy = OVERHANG_STRATEGY.SOFTCLIP;
    protected int[][] SW = null;
    protected static boolean keepScoringMatrix = false;

    @Deprecated
    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, int match, int mismatch, int open, int extend) {
        this(seq1, seq2, new Parameters(match, mismatch, open, extend));
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, Parameters parameters) {
        this(parameters);
        this.align(seq1, seq2);
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, SWParameterSet parameters, OVERHANG_STRATEGY strategy) {
        this(parameters.parameters);
        this.overhang_strategy = strategy;
        this.align(seq1, seq2);
    }

    protected SWPairwiseAlignment(Parameters parameters) {
        this.parameters = parameters;
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, SWParameterSet namedParameters) {
        this(seq1, seq2, namedParameters.parameters);
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2) {
        this(seq1, seq2, SWParameterSet.ORIGINAL_DEFAULT);
    }

    @Override
    public Cigar getCigar() {
        return this.alignmentResult.cigar;
    }

    @Override
    public int getAlignmentStart2wrt1() {
        return this.alignmentResult.alignment_offset;
    }

    protected void align(byte[] reference, byte[] alternate) {
        if (reference == null || reference.length == 0 || alternate == null || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty sequences are required for the Smith-Waterman calculation");
        }
        int n2 = reference.length + 1;
        int m2 = alternate.length + 1;
        int[][] sw = new int[n2][m2];
        if (keepScoringMatrix) {
            this.SW = sw;
        }
        int[][] btrack = new int[n2][m2];
        this.calculateMatrix(reference, alternate, sw, btrack);
        this.alignmentResult = this.calculateCigar(sw, btrack, this.overhang_strategy);
    }

    protected void calculateMatrix(byte[] reference, byte[] alternate, int[][] sw, int[][] btrack) {
        this.calculateMatrix(reference, alternate, sw, btrack, this.overhang_strategy);
    }

    protected void calculateMatrix(byte[] reference, byte[] alternate, int[][] sw, int[][] btrack, OVERHANG_STRATEGY overhang_strategy) {
        if (reference.length == 0 || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty sequences are required for the Smith-Waterman calculation");
        }
        int ncol = sw[0].length;
        int nrow = sw.length;
        int MATRIX_MIN_CUTOFF = cutoff ? 0 : -100000000;
        int lowInitValue = -1073741824;
        int[] best_gap_v = new int[ncol + 1];
        Arrays.fill(best_gap_v, lowInitValue);
        int[] gap_size_v = new int[ncol + 1];
        int[] best_gap_h = new int[nrow + 1];
        Arrays.fill(best_gap_h, lowInitValue);
        int[] gap_size_h = new int[nrow + 1];
        if (overhang_strategy == OVERHANG_STRATEGY.INDEL || overhang_strategy == OVERHANG_STRATEGY.LEADING_INDEL) {
            int i2;
            int[] topRow = sw[0];
            topRow[1] = this.parameters.w_open;
            int currentValue = this.parameters.w_open;
            for (i2 = 2; i2 < topRow.length; ++i2) {
                topRow[i2] = currentValue += this.parameters.w_extend;
            }
            sw[1][0] = this.parameters.w_open;
            currentValue = this.parameters.w_open;
            for (i2 = 2; i2 < sw.length; ++i2) {
                sw[i2][0] = currentValue += this.parameters.w_extend;
            }
        }
        int[] curRow = sw[0];
        for (int i3 = 1; i3 < sw.length; ++i3) {
            byte a_base = reference[i3 - 1];
            int[] lastRow = curRow;
            curRow = sw[i3];
            int[] curBackTrackRow = btrack[i3];
            for (int j2 = 1; j2 < curRow.length; ++j2) {
                boolean diagHighestOrEqual;
                byte b_base = alternate[j2 - 1];
                int step_diag = lastRow[j2 - 1] + this.wd(a_base, b_base);
                int prev_gap = lastRow[j2] + this.parameters.w_open;
                int n2 = j2;
                best_gap_v[n2] = best_gap_v[n2] + this.parameters.w_extend;
                if (prev_gap > best_gap_v[j2]) {
                    best_gap_v[j2] = prev_gap;
                    gap_size_v[j2] = 1;
                } else {
                    int n3 = j2;
                    gap_size_v[n3] = gap_size_v[n3] + 1;
                }
                int step_down = best_gap_v[j2];
                int kd = gap_size_v[j2];
                prev_gap = curRow[j2 - 1] + this.parameters.w_open;
                int n4 = i3;
                best_gap_h[n4] = best_gap_h[n4] + this.parameters.w_extend;
                if (prev_gap > best_gap_h[i3]) {
                    best_gap_h[i3] = prev_gap;
                    gap_size_h[i3] = 1;
                } else {
                    int n5 = i3;
                    gap_size_h[n5] = gap_size_h[n5] + 1;
                }
                int step_right = best_gap_h[i3];
                int ki = gap_size_h[i3];
                boolean bl = diagHighestOrEqual = step_diag >= step_down && step_diag >= step_right;
                if (diagHighestOrEqual) {
                    curRow[j2] = Math.max(MATRIX_MIN_CUTOFF, step_diag);
                    curBackTrackRow[j2] = 0;
                    continue;
                }
                if (step_right >= step_down) {
                    curRow[j2] = Math.max(MATRIX_MIN_CUTOFF, step_right);
                    curBackTrackRow[j2] = -ki;
                    continue;
                }
                curRow[j2] = Math.max(MATRIX_MIN_CUTOFF, step_down);
                curBackTrackRow[j2] = kd;
            }
        }
    }

    protected SWPairwiseAlignmentResult calculateCigar(int[][] sw, int[][] btrack, OVERHANG_STRATEGY overhang_strategy) {
        int alignment_offset;
        int p1 = 0;
        int p2 = 0;
        int refLength = sw.length - 1;
        int altLength = sw[0].length - 1;
        int maxscore = Integer.MIN_VALUE;
        int segment_length = 0;
        if (overhang_strategy == OVERHANG_STRATEGY.INDEL) {
            p1 = refLength;
            p2 = altLength;
        } else {
            p2 = altLength;
            for (int i2 = 1; i2 < sw.length; ++i2) {
                int curScore = sw[i2][altLength];
                if (curScore < maxscore) continue;
                p1 = i2;
                maxscore = curScore;
            }
            if (overhang_strategy != OVERHANG_STRATEGY.LEADING_INDEL) {
                int[] bottomRow = sw[refLength];
                for (int j2 = 1; j2 < bottomRow.length; ++j2) {
                    int curScore = bottomRow[j2];
                    if (curScore <= maxscore && (curScore != maxscore || Math.abs(refLength - j2) >= Math.abs(p1 - p2))) continue;
                    p1 = refLength;
                    p2 = j2;
                    maxscore = curScore;
                    segment_length = altLength - j2;
                }
            }
        }
        ArrayList<CigarElement> lce = new ArrayList<CigarElement>(5);
        if (segment_length > 0 && overhang_strategy == OVERHANG_STRATEGY.SOFTCLIP) {
            lce.add(this.makeElement(State.CLIP, segment_length));
            segment_length = 0;
        }
        State state = State.MATCH;
        do {
            State new_state;
            int btr = btrack[p1][p2];
            int step_length = 1;
            if (btr > 0) {
                new_state = State.DELETION;
                step_length = btr;
            } else if (btr < 0) {
                new_state = State.INSERTION;
                step_length = -btr;
            } else {
                new_state = State.MATCH;
            }
            switch (new_state) {
                case MATCH: {
                    --p1;
                    --p2;
                    break;
                }
                case INSERTION: {
                    p2 -= step_length;
                    break;
                }
                case DELETION: {
                    p1 -= step_length;
                }
            }
            if (new_state == state) {
                segment_length += step_length;
                continue;
            }
            lce.add(this.makeElement(state, segment_length));
            segment_length = step_length;
            state = new_state;
        } while (p1 > 0 && p2 > 0);
        if (overhang_strategy == OVERHANG_STRATEGY.SOFTCLIP) {
            lce.add(this.makeElement(state, segment_length));
            if (p2 > 0) {
                lce.add(this.makeElement(State.CLIP, p2));
            }
            alignment_offset = p1;
        } else if (overhang_strategy == OVERHANG_STRATEGY.IGNORE) {
            lce.add(this.makeElement(state, segment_length + p2));
            alignment_offset = p1 - p2;
        } else {
            lce.add(this.makeElement(state, segment_length));
            if (p1 > 0) {
                lce.add(this.makeElement(State.DELETION, p1));
            } else if (p2 > 0) {
                lce.add(this.makeElement(State.INSERTION, p2));
            }
            alignment_offset = 0;
        }
        Collections.reverse(lce);
        return new SWPairwiseAlignmentResult(AlignmentUtils.consolidateCigar(new Cigar(lce)), alignment_offset);
    }

    protected CigarElement makeElement(State state, int length) {
        CigarOperator op = null;
        switch (state) {
            case MATCH: {
                op = CigarOperator.M;
                break;
            }
            case INSERTION: {
                op = CigarOperator.I;
                break;
            }
            case DELETION: {
                op = CigarOperator.D;
                break;
            }
            case CLIP: {
                op = CigarOperator.S;
            }
        }
        return new CigarElement(length, op);
    }

    private int wd(byte x2, byte y) {
        return x2 == y ? this.parameters.w_match : this.parameters.w_mismatch;
    }

    public void printAlignment(byte[] ref, byte[] read) {
        this.printAlignment(ref, read, 100);
    }

    public void printAlignment(byte[] ref, byte[] read, int width) {
        int j2;
        StringBuilder bread = new StringBuilder();
        StringBuilder bref = new StringBuilder();
        StringBuilder match = new StringBuilder();
        int i2 = 0;
        int offset = this.getAlignmentStart2wrt1();
        Cigar cigar = this.getCigar();
        if (this.overhang_strategy != OVERHANG_STRATEGY.SOFTCLIP && offset < 0) {
            for (j2 = 0; j2 < -offset; ++j2) {
                bread.append((char)read[j2]);
                bref.append(' ');
                match.append(' ');
            }
            ArrayList<CigarElement> tweaked = new ArrayList<CigarElement>();
            tweaked.addAll(cigar.getCigarElements());
            tweaked.set(0, new CigarElement(cigar.getCigarElement(0).getLength() + offset, cigar.getCigarElement(0).getOperator()));
            cigar = new Cigar(tweaked);
        }
        if (offset > 0) {
            while (i2 < this.getAlignmentStart2wrt1()) {
                bref.append((char)ref[i2]);
                bread.append(' ');
                match.append(' ');
                ++i2;
            }
        }
        block8: for (CigarElement e2 : cigar.getCigarElements()) {
            switch (e2.getOperator()) {
                case M: {
                    int z = 0;
                    while (z < e2.getLength()) {
                        bref.append(i2 < ref.length ? (char)ref[i2] : (char)' ');
                        bread.append(j2 < read.length ? (char)read[j2] : (char)' ');
                        match.append((char)(i2 < ref.length && j2 < read.length ? (ref[i2] == read[j2] ? 46 : 42) : 32));
                        ++z;
                        ++i2;
                        ++j2;
                    }
                    continue block8;
                }
                case I: {
                    int z = 0;
                    while (z < e2.getLength()) {
                        bref.append('-');
                        bread.append((char)read[j2]);
                        match.append('I');
                        ++z;
                        ++j2;
                    }
                    continue block8;
                }
                case S: {
                    int z = 0;
                    while (z < e2.getLength()) {
                        bref.append(' ');
                        bread.append((char)read[j2]);
                        match.append('S');
                        ++z;
                        ++j2;
                    }
                    continue block8;
                }
                case D: {
                    int z = 0;
                    while (z < e2.getLength()) {
                        bref.append((char)ref[i2]);
                        bread.append('-');
                        match.append('D');
                        ++z;
                        ++i2;
                    }
                    continue block8;
                }
                default: {
                    throw new GATKException("Unexpected Cigar element:" + (Object)((Object)e2.getOperator()));
                }
            }
        }
        while (i2 < ref.length) {
            bref.append((char)ref[i2]);
            ++i2;
        }
        while (j2 < read.length) {
            bread.append((char)read[j2]);
            ++j2;
        }
        int maxlength = Math.max(match.length(), Math.max(bread.length(), bref.length()));
        for (int pos = 0; pos < maxlength; pos += width) {
            SWPairwiseAlignment.print_cautiously(match, pos, width);
            SWPairwiseAlignment.print_cautiously(bread, pos, width);
            SWPairwiseAlignment.print_cautiously(bref, pos, width);
            System.out.println();
        }
    }

    private static void print_cautiously(StringBuilder s2, int start, int width) {
        if (start >= s2.length()) {
            System.out.println();
            return;
        }
        int end = Math.min(start + width, s2.length());
        System.out.println(s2.substring(start, end));
    }

    protected final class SWPairwiseAlignmentResult {
        public final Cigar cigar;
        public final int alignment_offset;

        public SWPairwiseAlignmentResult(Cigar cigar, int alignment_offset) {
            this.cigar = cigar;
            this.alignment_offset = alignment_offset;
        }
    }

    public static enum OVERHANG_STRATEGY {
        SOFTCLIP,
        INDEL,
        LEADING_INDEL,
        IGNORE;

    }

    protected static enum State {
        MATCH,
        INSERTION,
        DELETION,
        CLIP;

    }
}

