/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.collections;

import com.google.java.contract.Requires;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class CountSet
implements Cloneable,
Set<Integer> {
    private int size;
    private int[] elements;

    public CountSet(CountSet template) {
        this.elements = (int[])template.elements.clone();
        this.size = template.size;
    }

    public CountSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elements = new int[initialCapacity];
        this.size = 0;
    }

    public void setTo(int value) {
        this.ensureCapacity(1);
        this.size = 1;
        this.elements[0] = value;
    }

    public void setTo(int ... values) {
        this.ensureCapacity(values.length);
        this.size = values.length;
        System.arraycopy(values, 0, this.elements, 0, this.size);
        Arrays.sort(this.elements, 0, this.size);
    }

    public boolean incAll(int delta) {
        if (this.size == 0 || delta == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.size) {
            int n2 = i2++;
            this.elements[n2] = this.elements[n2] + delta;
        }
        return true;
    }

    public int min() {
        if (this.size == 0) {
            throw new NoSuchElementException("cannot have a min from an empty set");
        }
        return this.elements[0];
    }

    public int max() {
        if (this.size == 0) {
            throw new NoSuchElementException("cannot have a max from an empty set");
        }
        return this.elements[this.size - 1];
    }

    public boolean addRange(int fromValue, int toValue) {
        int highEnd;
        int lowEnd;
        if (fromValue <= toValue) {
            lowEnd = fromValue;
            highEnd = toValue;
        } else {
            highEnd = fromValue;
            lowEnd = toValue;
        }
        boolean result = false;
        for (int i2 = lowEnd; i2 <= highEnd; ++i2) {
            result = this.add(i2) | result;
        }
        return result;
    }

    @Override
    public boolean add(int value) {
        int pos = Arrays.binarySearch(this.elements, 0, this.size, value);
        if (pos >= 0) {
            return false;
        }
        int insertPos = -pos - 1;
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, insertPos, this.elements, insertPos + 1, this.size - insertPos);
        this.elements[insertPos] = value;
        ++this.size;
        return true;
    }

    public boolean addAll(int ... values) {
        this.ensureCapacity(this.size + values.length);
        boolean result = false;
        for (int v2 : values) {
            result = this.add(v2) | result;
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> numbers) {
        this.ensureCapacity(this.size + numbers.size());
        boolean result = false;
        for (Number number : numbers) {
            result = this.add(number.intValue()) | result;
        }
        return result;
    }

    public boolean addAll(int[] source, int fromIndex, int toIndex) {
        this.ensureCapacity(this.size + source.length);
        boolean result = false;
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            result = this.add(source[i2]) | result;
        }
        return result;
    }

    public boolean addAll(CountSet other) {
        return this.addAll(other.elements, 0, other.size);
    }

    public boolean contains(int value) {
        return Arrays.binarySearch(this.elements, 0, this.size, value) >= 0;
    }

    private void ensureCapacity(int capacity) {
        if (this.elements.length >= capacity) {
            return;
        }
        int newLength = Math.max(this.elements.length << 1, capacity);
        this.elements = Arrays.copyOf(this.elements, newLength);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 instanceof Integer) {
            int i2 = (Integer)o2;
            return this.contains(i2);
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new MyIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Integer[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            result[i2] = this.elements[i2];
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2 == null) {
            throw new NullPointerException();
        }
        Class<Integer> componentClass = a2.getClass().getComponentType();
        if (!componentClass.isAssignableFrom(Integer.class)) {
            throw new ArrayStoreException();
        }
        T[] dest = a2.length < this.size ? (Object[])Array.newInstance(componentClass, this.size) : a2;
        for (int i2 = 0; i2 < this.size; ++i2) {
            dest[i2] = this.elements[i2];
        }
        return dest;
    }

    public int[] toIntArray() {
        return Arrays.copyOfRange(this.elements, 0, this.size);
    }

    public void copyTo(int[] dest, int offset) {
        if (dest == null) {
            throw new NullPointerException();
        }
        if (dest.length < this.size + offset) {
            throw new ArrayIndexOutOfBoundsException("destination is to short");
        }
        System.arraycopy(this.elements, 0, dest, offset, this.size);
    }

    public void copyTo(int[] dest) {
        this.copyTo(dest, 0);
    }

    @Override
    public boolean add(Integer integer) {
        return this.add((int)integer);
    }

    @Override
    public boolean remove(Object o2) {
        return o2 instanceof Integer && this.remove((Integer)o2);
    }

    public boolean remove(int i2) {
        int pos = Arrays.binarySearch(this.elements, 0, this.size, i2);
        if (pos < 0) {
            return false;
        }
        this.removeIndex(pos);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        for (Object o2 : c2) {
            if (this.contains(o2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        if (this.size == 0) {
            return false;
        }
        CountSet retainIndices = new CountSet(c2.size() + 2);
        retainIndices.add(-1);
        retainIndices.add(this.size);
        for (Object o2 : c2) {
            int pos;
            if (!(o2 instanceof Integer) || (pos = Arrays.binarySearch(this.elements, 0, this.size, (Integer)o2)) < 0) continue;
            retainIndices.add(pos);
        }
        if (retainIndices.size == 2) {
            this.size = 0;
            return true;
        }
        if (retainIndices.size == this.size + 2) {
            return false;
        }
        for (int idx = retainIndices.size - 1; idx > 0; --idx) {
            int toIdx = retainIndices.elements[idx];
            int fromIdx = retainIndices.elements[idx - 1] + 1;
            this.removeIndices(toIdx, fromIdx);
        }
        return true;
    }

    @Requires(value={"fromIdx >= toIdx & fromIdx >= 0 & toIdx <= size"})
    private void removeIndices(int fromIdx, int toIdx) {
        System.arraycopy(this.elements, toIdx, this.elements, fromIdx, this.size - toIdx);
        this.size -= toIdx - fromIdx;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean result = false;
        for (Object o2 : c2) {
            result = this.remove(o2) | result;
        }
        return result;
    }

    @Requires(value={"idx >= 0 && idx < size"})
    private void removeIndex(int idx) {
        System.arraycopy(this.elements, idx + 1, this.elements, idx, this.size - idx - 1);
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public CountSet clone() {
        return new CountSet(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2 + this.size() * 10);
        sb.append('{');
        for (int i2 = 0; i2 < this.size; ++i2) {
            sb.append(this.elements[i2]).append(',');
        }
        sb.replace(sb.length() - 1, sb.length(), "}");
        return sb.toString();
    }

    private class MyIterator
    implements Iterator<Integer> {
        private int next = 0;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next < CountSet.this.size;
        }

        @Override
        public Integer next() {
            if (this.next >= CountSet.this.size) {
                throw new NoSuchElementException();
            }
            return CountSet.this.elements[this.next];
        }

        @Override
        public void remove() {
            if (this.next == 0) {
                throw new IllegalStateException();
            }
            if (this.next >= CountSet.this.size) {
                throw new NoSuchElementException();
            }
            CountSet.this.removeIndex(this.next - 1);
        }
    }
}

