/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.clipping;

import com.google.java.contract.Requires;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.broadinstitute.gatk.utils.clipping.ClippingRepresentation;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.recalibration.EventType;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class ClippingOp {
    public final int start;
    public final int stop;

    public ClippingOp(int start, int stop) {
        this.start = start;
        this.stop = stop;
    }

    public int getLength() {
        return this.stop - this.start + 1;
    }

    public GATKSAMRecord apply(ClippingRepresentation algorithm, GATKSAMRecord originalRead) {
        GATKSAMRecord read = (GATKSAMRecord)originalRead.clone();
        byte[] quals = read.getBaseQualities();
        byte[] bases = read.getReadBases();
        byte[] newBases = new byte[bases.length];
        byte[] newQuals = new byte[quals.length];
        switch (algorithm) {
            case WRITE_NS: {
                for (int i2 = 0; i2 < bases.length; ++i2) {
                    newBases[i2] = i2 >= this.start && i2 <= this.stop ? 78 : bases[i2];
                }
                read.setReadBases(newBases);
                break;
            }
            case WRITE_Q0S: {
                for (int i3 = 0; i3 < quals.length; ++i3) {
                    newQuals[i3] = i3 >= this.start && i3 <= this.stop ? (byte)0 : quals[i3];
                }
                read.setBaseQualities(newQuals);
                break;
            }
            case WRITE_NS_Q0S: {
                for (int i4 = 0; i4 < bases.length; ++i4) {
                    if (i4 >= this.start && i4 <= this.stop) {
                        newQuals[i4] = 0;
                        newBases[i4] = 78;
                        continue;
                    }
                    newQuals[i4] = quals[i4];
                    newBases[i4] = bases[i4];
                }
                read.setBaseQualities(newBases);
                read.setReadBases(newBases);
                break;
            }
            case HARDCLIP_BASES: {
                read = this.hardClip(read, this.start, this.stop);
                break;
            }
            case SOFTCLIP_BASES: {
                if (read.getReadUnmappedFlag()) {
                    throw new UserException("Read Clipper cannot soft clip unmapped reads");
                }
                int myStop = this.stop;
                if (this.stop + 1 - this.start == read.getReadLength()) {
                    --myStop;
                }
                if (this.start > 0 && myStop != read.getReadLength() - 1) {
                    throw new RuntimeException(String.format("Cannot apply soft clipping operator to the middle of a read: %s to be clipped at %d-%d", read.getReadName(), this.start, myStop));
                }
                Cigar oldCigar = read.getCigar();
                int scLeft = 0;
                int scRight = read.getReadLength();
                if (this.start == 0) {
                    scLeft = myStop + 1;
                } else {
                    scRight = this.start;
                }
                Cigar newCigar = this.softClip(oldCigar, scLeft, scRight);
                read.setCigar(newCigar);
                int newClippedStart = this.getNewAlignmentStartOffset(newCigar, oldCigar);
                int newStart = read.getAlignmentStart() + newClippedStart;
                read.setAlignmentStart(newStart);
                break;
            }
            case REVERT_SOFTCLIPPED_BASES: {
                read = this.revertSoftClippedBases(read);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Clipping operator type " + (Object)((Object)algorithm));
            }
        }
        return read;
    }

    private GATKSAMRecord revertSoftClippedBases(GATKSAMRecord read) {
        GATKSAMRecord unclipped = (GATKSAMRecord)read.clone();
        Cigar unclippedCigar = new Cigar();
        int matchesCount = 0;
        for (CigarElement element : read.getCigar().getCigarElements()) {
            if (element.getOperator() == CigarOperator.SOFT_CLIP || element.getOperator() == CigarOperator.MATCH_OR_MISMATCH) {
                matchesCount += element.getLength();
                continue;
            }
            if (matchesCount > 0) {
                unclippedCigar.add(new CigarElement(matchesCount, CigarOperator.MATCH_OR_MISMATCH));
                matchesCount = 0;
                unclippedCigar.add(element);
                continue;
            }
            unclippedCigar.add(element);
        }
        if (matchesCount > 0) {
            unclippedCigar.add(new CigarElement(matchesCount, CigarOperator.MATCH_OR_MISMATCH));
        }
        unclipped.setCigar(unclippedCigar);
        int newStart = read.getAlignmentStart() + this.calculateAlignmentStartShift(read.getCigar(), unclippedCigar);
        unclipped.setAlignmentStart(newStart);
        if (newStart <= 0) {
            return this.hardClip(unclipped, 0, -newStart);
        }
        return unclipped;
    }

    private int getNewAlignmentStartOffset(Cigar __cigar, Cigar __oldCigar) {
        int num = 0;
        for (CigarElement e2 : __cigar.getCigarElements()) {
            if (e2.getOperator().consumesReferenceBases()) break;
            if (!e2.getOperator().consumesReadBases()) continue;
            num += e2.getLength();
        }
        int oldNum = 0;
        int curReadCounter = 0;
        for (CigarElement e3 : __oldCigar.getCigarElements()) {
            int curRefLength = e3.getLength();
            int curReadLength = e3.getLength();
            if (!e3.getOperator().consumesReadBases()) {
                curReadLength = 0;
            }
            boolean truncated = false;
            if (curReadCounter + curReadLength > num) {
                curReadLength = num - curReadCounter;
                curRefLength = num - curReadCounter;
                truncated = true;
            }
            if (!e3.getOperator().consumesReferenceBases()) {
                curRefLength = 0;
            }
            oldNum += curRefLength;
            if ((curReadCounter += curReadLength) <= num && !truncated) continue;
            break;
        }
        return oldNum;
    }

    private Cigar softClip(Cigar __cigar, int __startClipEnd, int __endClipBegin) {
        if (__endClipBegin <= __startClipEnd) {
            int cigarLength = 0;
            for (CigarElement e2 : __cigar.getCigarElements()) {
                cigarLength += e2.getLength();
            }
            Cigar newCigar = new Cigar();
            newCigar.add(new CigarElement(cigarLength, CigarOperator.SOFT_CLIP));
            assert (newCigar.isValid(null, -1L) == null);
            return newCigar;
        }
        int curLength = 0;
        Vector<CigarElement> newElements = new Vector<CigarElement>();
        for (CigarElement curElem : __cigar.getCigarElements()) {
            if (!curElem.getOperator().consumesReadBases()) {
                if (curElem.getOperator() != CigarOperator.HARD_CLIP && (curLength <= __startClipEnd || curLength >= __endClipBegin)) continue;
                newElements.add(new CigarElement(curElem.getLength(), curElem.getOperator()));
                continue;
            }
            int s2 = curLength;
            int e3 = curLength + curElem.getLength();
            if (e3 <= __startClipEnd || s2 >= __endClipBegin) {
                newElements.add(new CigarElement(curElem.getLength(), CigarOperator.SOFT_CLIP));
            } else if (s2 >= __startClipEnd && e3 <= __endClipBegin) {
                newElements.add(new CigarElement(curElem.getLength(), curElem.getOperator()));
            } else {
                CigarElement newStart = null;
                CigarElement newMid = null;
                CigarElement newEnd = null;
                int midLength = curElem.getLength();
                if (s2 < __startClipEnd) {
                    newStart = new CigarElement(__startClipEnd - s2, CigarOperator.SOFT_CLIP);
                    midLength -= newStart.getLength();
                }
                if (e3 > __endClipBegin) {
                    newEnd = new CigarElement(e3 - __endClipBegin, CigarOperator.SOFT_CLIP);
                    midLength -= newEnd.getLength();
                }
                assert (midLength >= 0);
                if (midLength > 0) {
                    newMid = new CigarElement(midLength, curElem.getOperator());
                }
                if (newStart != null) {
                    newElements.add(newStart);
                }
                if (newMid != null) {
                    newElements.add(newMid);
                }
                if (newEnd != null) {
                    newElements.add(newEnd);
                }
            }
            curLength += curElem.getLength();
        }
        Vector<CigarElement> finalNewElements = new Vector<CigarElement>();
        CigarElement lastElement = null;
        for (CigarElement elem : newElements) {
            if (lastElement == null || lastElement.getOperator() != elem.getOperator()) {
                if (lastElement != null) {
                    finalNewElements.add(lastElement);
                }
                lastElement = elem;
                continue;
            }
            lastElement = new CigarElement(lastElement.getLength() + elem.getLength(), lastElement.getOperator());
        }
        if (lastElement != null) {
            finalNewElements.add(lastElement);
        }
        Cigar newCigar = new Cigar(finalNewElements);
        assert (newCigar.isValid(null, -1L) == null);
        return newCigar;
    }

    private GATKSAMRecord hardClip(GATKSAMRecord read, int start, int stop) {
        CigarShift cigarShift = read.getReadUnmappedFlag() ? new CigarShift(new Cigar(), 0, 0) : this.hardClipCigar(read.getCigar(), start, stop);
        int newLength = read.getReadLength() - (stop - start + 1) - cigarShift.shiftFromStart - cigarShift.shiftFromEnd;
        byte[] newBases = new byte[newLength];
        byte[] newQuals = new byte[newLength];
        int copyStart = start == 0 ? stop + 1 + cigarShift.shiftFromStart : cigarShift.shiftFromStart;
        System.arraycopy(read.getReadBases(), copyStart, newBases, 0, newLength);
        System.arraycopy(read.getBaseQualities(), copyStart, newQuals, 0, newLength);
        GATKSAMRecord hardClippedRead = (GATKSAMRecord)read.clone();
        hardClippedRead.resetSoftStartAndEnd();
        hardClippedRead.setBaseQualities(newQuals);
        hardClippedRead.setReadBases(newBases);
        hardClippedRead.setCigar(cigarShift.cigar);
        if (start == 0) {
            hardClippedRead.setAlignmentStart(read.getAlignmentStart() + this.calculateAlignmentStartShift(read.getCigar(), cigarShift.cigar));
        }
        if (read.hasBaseIndelQualities()) {
            byte[] newBaseInsertionQuals = new byte[newLength];
            byte[] newBaseDeletionQuals = new byte[newLength];
            System.arraycopy(read.getBaseInsertionQualities(), copyStart, newBaseInsertionQuals, 0, newLength);
            System.arraycopy(read.getBaseDeletionQualities(), copyStart, newBaseDeletionQuals, 0, newLength);
            hardClippedRead.setBaseQualities(newBaseInsertionQuals, EventType.BASE_INSERTION);
            hardClippedRead.setBaseQualities(newBaseDeletionQuals, EventType.BASE_DELETION);
        }
        return hardClippedRead;
    }

    @Requires(value={"!cigar.isEmpty()"})
    private CigarShift hardClipCigar(Cigar cigar, int start, int stop) {
        Cigar newCigar = new Cigar();
        int index = 0;
        int totalHardClipCount = stop - start + 1;
        int alignmentShift = 0;
        if (start == 0) {
            Iterator<CigarElement> cigarElementIterator = cigar.getCigarElements().iterator();
            CigarElement cigarElement = cigarElementIterator.next();
            while (cigarElement.getOperator() == CigarOperator.HARD_CLIP) {
                totalHardClipCount += cigarElement.getLength();
                if (cigarElementIterator.hasNext()) {
                    cigarElement = cigarElementIterator.next();
                    continue;
                }
                throw new ReviewedGATKException("Read is entirely hardclipped, shouldn't be trying to clip it's cigar string");
            }
            while (index <= stop) {
                int shift = 0;
                if (cigarElement.getOperator().consumesReadBases()) {
                    shift = cigarElement.getLength();
                }
                if (index + shift == stop + 1) {
                    newCigar.add(new CigarElement(totalHardClipCount + (alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, cigarElement.getLength())), CigarOperator.HARD_CLIP));
                } else if (index + shift > stop + 1) {
                    int elementLengthAfterChopping = cigarElement.getLength() - (stop - index + 1);
                    newCigar.add(new CigarElement(totalHardClipCount + (alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, stop - index + 1)), CigarOperator.HARD_CLIP));
                    newCigar.add(new CigarElement(elementLengthAfterChopping, cigarElement.getOperator()));
                }
                alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, shift);
                if ((index += shift) > stop || !cigarElementIterator.hasNext()) break;
                cigarElement = cigarElementIterator.next();
            }
            while (cigarElementIterator.hasNext()) {
                cigarElement = cigarElementIterator.next();
                newCigar.add(new CigarElement(cigarElement.getLength(), cigarElement.getOperator()));
            }
        } else {
            Iterator<CigarElement> cigarElementIterator = cigar.getCigarElements().iterator();
            CigarElement cigarElement = cigarElementIterator.next();
            while (index < start) {
                int shift = 0;
                if (cigarElement.getOperator().consumesReadBases()) {
                    shift = cigarElement.getLength();
                }
                if (index + shift < start) {
                    newCigar.add(new CigarElement(cigarElement.getLength(), cigarElement.getOperator()));
                } else {
                    int elementLengthAfterChopping = start - index;
                    alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, cigarElement.getLength() - (start - index));
                    if (cigarElement.getOperator() == CigarOperator.HARD_CLIP) {
                        totalHardClipCount += elementLengthAfterChopping;
                    } else {
                        newCigar.add(new CigarElement(elementLengthAfterChopping, cigarElement.getOperator()));
                    }
                }
                if ((index += shift) >= start || !cigarElementIterator.hasNext()) break;
                cigarElement = cigarElementIterator.next();
            }
            while (cigarElementIterator.hasNext()) {
                cigarElement = cigarElementIterator.next();
                alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, cigarElement.getLength());
                if (cigarElement.getOperator() != CigarOperator.HARD_CLIP) continue;
                totalHardClipCount += cigarElement.getLength();
            }
            newCigar.add(new CigarElement(totalHardClipCount + alignmentShift, CigarOperator.HARD_CLIP));
        }
        return this.cleanHardClippedCigar(newCigar);
    }

    private CigarShift cleanHardClippedCigar(Cigar cigar) {
        Cigar cleanCigar = new Cigar();
        int shiftFromStart = 0;
        int shiftFromEnd = 0;
        Stack<CigarElement> cigarStack = new Stack<CigarElement>();
        Stack<CigarElement> inverseCigarStack = new Stack<CigarElement>();
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            cigarStack.push(cigarElement);
        }
        for (int i2 = 1; i2 <= 2; ++i2) {
            int shift = 0;
            int totalHardClip = 0;
            boolean readHasStarted = false;
            boolean addedHardClips = false;
            while (!cigarStack.empty()) {
                CigarElement cigarElement = (CigarElement)cigarStack.pop();
                if (!readHasStarted && cigarElement.getOperator() != CigarOperator.DELETION && cigarElement.getOperator() != CigarOperator.SKIPPED_REGION && cigarElement.getOperator() != CigarOperator.HARD_CLIP) {
                    readHasStarted = true;
                } else if (!readHasStarted && cigarElement.getOperator() == CigarOperator.HARD_CLIP) {
                    totalHardClip += cigarElement.getLength();
                } else if (!readHasStarted && cigarElement.getOperator() == CigarOperator.DELETION) {
                    totalHardClip += cigarElement.getLength();
                } else if (!readHasStarted && cigarElement.getOperator() == CigarOperator.SKIPPED_REGION) {
                    totalHardClip += cigarElement.getLength();
                }
                if (!readHasStarted) continue;
                if (i2 == 1) {
                    if (!addedHardClips) {
                        if (totalHardClip > 0) {
                            inverseCigarStack.push(new CigarElement(totalHardClip, CigarOperator.HARD_CLIP));
                        }
                        addedHardClips = true;
                    }
                    inverseCigarStack.push(cigarElement);
                    continue;
                }
                if (!addedHardClips) {
                    if (totalHardClip > 0) {
                        cleanCigar.add(new CigarElement(totalHardClip, CigarOperator.HARD_CLIP));
                    }
                    addedHardClips = true;
                }
                cleanCigar.add(cigarElement);
            }
            if (i2 == 1) {
                shiftFromEnd = shift;
                cigarStack = inverseCigarStack;
                continue;
            }
            shiftFromStart = shift;
        }
        return new CigarShift(cleanCigar, shiftFromStart, shiftFromEnd);
    }

    private int calcHardSoftOffset(Cigar cigar) {
        int i2;
        List<CigarElement> elements = cigar.getCigarElements();
        int size = 0;
        for (i2 = 0; i2 < elements.size() && elements.get(i2).getOperator() == CigarOperator.HARD_CLIP; ++i2) {
            size += elements.get(i2).getLength();
        }
        while (i2 < elements.size() && elements.get(i2).getOperator() == CigarOperator.SOFT_CLIP) {
            size += elements.get(i2).getLength();
            ++i2;
        }
        return size;
    }

    private int calculateAlignmentStartShift(Cigar oldCigar, Cigar newCigar) {
        int newShift = this.calcHardSoftOffset(newCigar);
        int oldShift = this.calcHardSoftOffset(oldCigar);
        return newShift - oldShift;
    }

    private int calculateHardClippingAlignmentShift(CigarElement cigarElement, int clippedLength) {
        if (cigarElement.getOperator() == CigarOperator.INSERTION) {
            return -clippedLength;
        }
        if (cigarElement.getOperator() == CigarOperator.DELETION || cigarElement.getOperator() == CigarOperator.SKIPPED_REGION) {
            return cigarElement.getLength();
        }
        return 0;
    }

    private static class CigarShift {
        private Cigar cigar;
        private int shiftFromStart;
        private int shiftFromEnd;

        private CigarShift(Cigar cigar, int shiftFromStart, int shiftFromEnd) {
            this.cigar = cigar;
            this.shiftFromStart = shiftFromStart;
            this.shiftFromEnd = shiftFromEnd;
        }
    }
}

