/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import org.broad.igv.track.Track;
import org.broad.igv.util.Filter;
import org.broad.igv.util.collections.CollUtils;

public abstract class FilterElement {
    private Filter filter;
    private String selectedItem;
    private Operator comparisonOperator = Operator.EQUAL;
    private String expectedValue;
    private BooleanOperator booleanOperator = BooleanOperator.AND;

    public FilterElement(Filter filter, String item, Operator comparisonOperator, String expectedValue, BooleanOperator booleanOperator) {
        this.filter = filter;
        if (item != null) {
            this.selectedItem = item.trim();
        }
        if (comparisonOperator != null) {
            this.comparisonOperator = comparisonOperator;
        }
        if (expectedValue != null) {
            this.expectedValue = new String(expectedValue).toUpperCase().trim();
        }
        if (booleanOperator != null) {
            this.booleanOperator = booleanOperator;
        }
    }

    public boolean test(String comparableItem, Boolean previousResult) {
        boolean result = false;
        if (this.expectedValue == null) {
            this.expectedValue = "";
        }
        if (comparableItem == null) {
            comparableItem = "";
        }
        comparableItem = comparableItem.toUpperCase().trim();
        boolean isComparableNumeric = this.isNumber(comparableItem);
        boolean isExpectedValueNumeric = this.isNumber(this.expectedValue);
        int comparison = 0;
        if (isComparableNumeric && isExpectedValueNumeric) {
            Double number1 = Double.parseDouble(comparableItem);
            Double number2 = Double.parseDouble(this.expectedValue);
            comparison = number1.compareTo(number2);
        } else if (isExpectedValueNumeric && comparableItem.equals("")) {
            Double number1 = Double.MIN_VALUE;
            Double number2 = Double.parseDouble(this.expectedValue);
            comparison = number1.compareTo(number2);
        } else {
            comparison = comparableItem.compareTo(this.expectedValue);
        }
        if (this.comparisonOperator.equals(Operator.EQUAL)) {
            result = comparison == 0;
        } else if (this.comparisonOperator.equals(Operator.NOT_EQUAL)) {
            result = comparison != 0;
        } else if (this.comparisonOperator.equals(Operator.GREATER_THAN)) {
            result = comparison > 0;
        } else if (this.comparisonOperator.equals(Operator.LESS_THAN)) {
            result = comparison < 0;
        } else if (this.comparisonOperator.equals(Operator.GREATER_THAN_OR_EQUAL)) {
            result = comparison >= 0;
        } else if (this.comparisonOperator.equals(Operator.LESS_THAN_OR_EQUAL)) {
            result = comparison <= 0;
        } else if (this.comparisonOperator.equals(Operator.CONTAINS)) {
            result = comparableItem.indexOf(this.expectedValue) != -1;
        } else if (this.comparisonOperator.equals(Operator.DOES_NOT_CONTAIN)) {
            result = comparableItem.indexOf(this.expectedValue) == -1;
        } else if (this.comparisonOperator.equals(Operator.STARTS_WITH)) {
            result = comparableItem.startsWith(this.expectedValue);
        }
        if (previousResult != null) {
            result = this.booleanOperator.equals((Object)BooleanOperator.OR) ? result || previousResult != false : result && previousResult != false;
        }
        return result;
    }

    public void setBooleanOperator(BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
    }

    public void setComparisonOperator(Operator comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
    }

    public void setSelectedItem(String item) {
        this.selectedItem = item;
    }

    public void setExpectedValue(String expectedValue) {
        if (expectedValue != null) {
            this.expectedValue = new String(expectedValue).toUpperCase();
        }
    }

    public BooleanOperator getBooleanOperator() {
        return this.booleanOperator;
    }

    public Operator getComparisonOperator() {
        return this.comparisonOperator;
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public String getValue() {
        return this.expectedValue;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).equals("")) {
            return false;
        }
        char[] charcters = string.toCharArray();
        boolean withDecimal = false;
        boolean isNegative = false;
        int len = charcters.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isDigit(charcters[i2])) continue;
            if (charcters[i2] == '.') {
                if (withDecimal) {
                    return false;
                }
                withDecimal = true;
                continue;
            }
            if (charcters[i2] == '-') {
                if (isNegative) {
                    return false;
                }
                if (i2 == 0) {
                    isNegative = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public abstract boolean evaluate(Track var1, Boolean var2);

    public static enum BooleanOperator {
        AND("AND"),
        OR("OR");

        String value;

        private BooleanOperator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Operator implements CollUtils.Valued
    {
        EQUAL("is equal to"),
        NOT_EQUAL("is not equal to"),
        GREATER_THAN("is greater than"),
        LESS_THAN("is less than"),
        GREATER_THAN_OR_EQUAL("is greater than or equal to"),
        LESS_THAN_OR_EQUAL("is less than or equal to"),
        STARTS_WITH("starts with"),
        CONTAINS("contains"),
        DOES_NOT_CONTAIN("does not contain");

        String value;

        private Operator(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

