/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.Comparator;
import java.util.List;

public class ArrayHeapObjectSorter<T> {
    private List<T> a;
    private int n;
    Comparator<T> c;

    public void sort(List<T> a0, Comparator<T> c2) {
        this.a = a0;
        this.n = this.a.size();
        this.c = c2;
        this.heapsort();
    }

    private void heapsort() {
        this.buildheap();
        while (this.n > 1) {
            --this.n;
            this.exchange(0, this.n);
            this.downheap(0);
        }
    }

    private void buildheap() {
        for (int v2 = this.n / 2 - 1; v2 >= 0; --v2) {
            this.downheap(v2);
        }
    }

    private void downheap(int v2) {
        int w2 = 2 * v2 + 1;
        while (w2 < this.n) {
            if (w2 + 1 < this.n && this.c.compare(this.a.get(w2 + 1), this.a.get(w2)) > 0) {
                ++w2;
            }
            if (this.c.compare(this.a.get(v2), this.a.get(w2)) >= 0) {
                return;
            }
            this.exchange(v2, w2);
            v2 = w2;
            w2 = 2 * v2 + 1;
        }
    }

    private void exchange(int i2, int j2) {
        T t2 = this.a.get(i2);
        this.a.set(i2, this.a.get(j2));
        this.a.set(j2, t2);
    }
}

