/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.color;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.util.ObjectCache;

public class ColorUtilities {
    private static Logger log = Logger.getLogger(ColorUtilities.class);
    public static ObjectCache<Object, Color> colorCache = new ObjectCache(1000);
    private static float[] whiteComponents = Color.white.getRGBColorComponents(null);
    private static Map<Integer, Color> grayscaleColors = new HashMap<Integer, Color>();
    static Map<String, String> colorSymbols = new HashMap<String, String>();
    private static Map<String, ColorPalette> palettes;
    public static Map<Color, float[]> componentsCache;
    static String colorPalleteString;
    static int nextPaletteIdx;
    static ArrayList<String> palleteNames;

    private static int[] quasiRandomColor(int idx) {
        int BASE_COL = 40;
        int RAND_COL = 255 - BASE_COL;
        int r2 = Math.abs(BASE_COL + ++idx * 33 % RAND_COL);
        int g2 = Math.abs(BASE_COL + idx * 55 % RAND_COL);
        int b2 = Math.abs(BASE_COL + idx * 77 % RAND_COL);
        return new int[]{r2, g2, b2};
    }

    public static Color randomColor(int idx) {
        return ColorUtilities.randomColor(idx, 1.0f);
    }

    public static Color randomColor(int idx, float alpha) {
        int[] rgb = ColorUtilities.quasiRandomColor(idx);
        int r2 = rgb[0];
        int g2 = rgb[1];
        int b2 = rgb[2];
        if (r2 > 200 && g2 > 200 && b2 > 200) {
            int tmp = r2 % 3;
            if (tmp == 0) {
                r2 = 255 - r2;
            } else if (tmp == 1) {
                g2 = 255 - g2;
            } else {
                b2 = 255 - b2;
            }
        }
        return new Color(r2, g2, b2, (int)(255.0f * alpha));
    }

    public static void main(String[] args) {
        for (int i2 = 200; i2 < 300; ++i2) {
            System.out.println(i2 % 3);
        }
    }

    public static Color randomDesaturatedColor(float alpha) {
        float hue = (float)Math.random();
        float brightenss = (float)(Math.random() * 0.7);
        Color base = Color.getHSBColor(hue, 0.0f, brightenss);
        if (alpha >= 1.0f) {
            return base;
        }
        return new Color(base.getRed(), base.getGreen(), base.getBlue(), (int)(alpha * 255.0f));
    }

    public static Color adjustHSB(Color inputColor, float hue, float saturation, float brightness) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(inputColor.getRed(), inputColor.getGreen(), inputColor.getBlue(), hsbvals);
        return Color.getHSBColor(hue * hsbvals[0], saturation * hsbvals[1], brightness * hsbvals[2]);
    }

    public static String colorToString(Color color) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(color.getRed());
        buffer.append(",");
        buffer.append(color.getGreen());
        buffer.append(",");
        buffer.append(color.getBlue());
        return buffer.toString();
    }

    public static Color stringToColor(String string) {
        return ColorUtilities.stringToColor(string, Color.black);
    }

    public static Color stringToColor(String string, Color defaultColor) {
        try {
            Color c2 = ColorUtilities.stringToColorNoDefault(string);
            if (c2 == null) {
                c2 = defaultColor;
            }
            colorCache.put(string, c2);
            return c2;
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Error in color string. ", numberFormatException);
            return defaultColor;
        }
    }

    private static Color stringToColorNoDefault(String string) throws NumberFormatException {
        Color c2;
        block7: {
            string = string.replace("\"", "").replace("'", "");
            c2 = null;
            if (string.contains(",")) {
                String[] rgb = string.split(",");
                int red = Integer.parseInt(rgb[0]);
                int green = Integer.parseInt(rgb[1]);
                int blue = Integer.parseInt(rgb[2]);
                c2 = new Color(red, green, blue);
            } else if (string.startsWith("#")) {
                c2 = ColorUtilities.hexToColor(string.substring(1));
            } else {
                try {
                    int intValue = Integer.parseInt(string);
                    if (intValue >= 0) {
                        c2 = new Color(intValue);
                    }
                }
                catch (NumberFormatException e2) {
                    String hexString = colorSymbols.get(string.toLowerCase());
                    if (hexString == null) break block7;
                    c2 = ColorUtilities.hexToColor(hexString);
                }
            }
        }
        return c2;
    }

    private static Color hexToColor(String string) {
        if (string.length() == 6) {
            int red = Integer.parseInt(string.substring(0, 2), 16);
            int green = Integer.parseInt(string.substring(2, 4), 16);
            int blue = Integer.parseInt(string.substring(4, 6), 16);
            return new Color(red, green, blue);
        }
        return null;
    }

    public static float[] getRGBColorComponents(Color color) {
        float[] comps = componentsCache.get(color);
        if (comps == null) {
            comps = color.getRGBColorComponents(null);
            componentsCache.put(color, comps);
        }
        return comps;
    }

    public static Color getCompositeColor(Color backgroundColor, Color foregroundColor, float alpha) {
        int b2;
        int g2;
        float[] dest = ColorUtilities.getRGBColorComponents(backgroundColor);
        int a2 = 255;
        float[] source = ColorUtilities.getRGBColorComponents(foregroundColor);
        int r2 = (int)((double)((alpha * source[0] + (1.0f - alpha) * dest[0]) * 255.0f) + 0.5);
        int value = (a2 & 0xFF) << 24 | (r2 & 0xFF) << 16 | ((g2 = (int)((double)((alpha * source[1] + (1.0f - alpha) * dest[1]) * 255.0f) + 0.5)) & 0xFF) << 8 | ((b2 = (int)((double)((alpha * source[2] + (1.0f - alpha) * dest[2]) * 255.0f) + 0.5)) & 0xFF) << 0;
        Color c2 = colorCache.get(value);
        if (c2 == null) {
            c2 = new Color(value);
            colorCache.put(value, c2);
        }
        return c2;
    }

    public static Color getCompositeColor(Color source, float alpha) {
        return ColorUtilities.getCompositeColor(Color.white, source, alpha);
    }

    public static Map<String, ColorPalette> loadPalettes() throws IOException {
        ColorPalette palette;
        String nextLine;
        BufferedReader br = new BufferedReader(new StringReader(colorPalleteString));
        palettes = new LinkedHashMap<String, ColorPalette>();
        palleteNames = new ArrayList();
        String currentPalletName = null;
        ArrayList<Color> currentColorList = new ArrayList<Color>();
        while ((nextLine = br.readLine()) != null) {
            String[] tokens;
            if ((nextLine = nextLine.trim()).length() == 0) continue;
            if (nextLine.startsWith("#")) {
                if (currentPalletName != null) {
                    palette = new ColorPalette(currentPalletName, currentColorList.toArray(new Color[currentColorList.size()]));
                    palettes.put(currentPalletName, palette);
                    palleteNames.add(currentPalletName);
                    currentColorList.clear();
                }
                currentPalletName = nextLine.substring(1);
                continue;
            }
            for (String s2 : tokens = nextLine.split(";")) {
                s2 = s2.replaceAll(" ", "");
                Color c2 = ColorUtilities.stringToColor(s2);
                currentColorList.add(c2);
            }
        }
        if (!currentColorList.isEmpty()) {
            palette = new ColorPalette(currentPalletName, currentColorList.toArray(new Color[currentColorList.size()]));
            palettes.put(currentPalletName, palette);
            palleteNames.add(currentPalletName);
        }
        return palettes;
    }

    public static ColorPalette getNextPalette() {
        try {
            if (palettes == null) {
                ColorUtilities.loadPalettes();
            }
            ColorPalette pallete = palettes.get(palleteNames.get(nextPaletteIdx));
            if (++nextPaletteIdx >= palleteNames.size()) {
                nextPaletteIdx = 0;
            }
            return pallete;
        }
        catch (IOException e2) {
            log.error(e2);
            return null;
        }
    }

    public static ColorPalette getPalette(String s2) {
        try {
            if (palettes == null) {
                ColorUtilities.loadPalettes();
            }
            return palettes.get(s2);
        }
        catch (IOException e2) {
            log.error(e2);
            return null;
        }
    }

    public static ColorPalette getDefaultPalette() {
        try {
            if (palettes == null) {
                ColorUtilities.loadPalettes();
            }
            if (palettes.isEmpty()) {
                return null;
            }
            return palettes.values().iterator().next();
        }
        catch (IOException e2) {
            log.error("Error loading color palletes", e2);
            return null;
        }
    }

    public static synchronized Color getGrayscaleColor(int gray) {
        Color c2 = grayscaleColors.get(gray = Math.max(0, Math.min(255, gray)));
        if (c2 == null) {
            c2 = new Color(gray, gray, gray);
            grayscaleColors.put(gray, c2);
        }
        return c2;
    }

    public static Color modifyAlpha(Color oldColor, int newAlpha) {
        return new Color(oldColor.getRed(), oldColor.getGreen(), oldColor.getBlue(), newAlpha);
    }

    static {
        componentsCache = Collections.synchronizedMap(new HashMap());
        colorSymbols.put("white", "FFFFFF");
        colorSymbols.put("silver", "C0C0C0");
        colorSymbols.put("gray", "808080");
        colorSymbols.put("black", "000000");
        colorSymbols.put("red", "FF0000");
        colorSymbols.put("maroon", "800000");
        colorSymbols.put("yellow", "FFFF00");
        colorSymbols.put("olive", "808000");
        colorSymbols.put("lime", "00FF00");
        colorSymbols.put("green", "008000");
        colorSymbols.put("aqua", "00FFFF");
        colorSymbols.put("teal", "008080");
        colorSymbols.put("blue", "0000FF");
        colorSymbols.put("navy", "000080");
        colorSymbols.put("fuchsia", "FF00FF");
        colorSymbols.put("purple", "800080");
        colorSymbols.put("orange", "FFA500");
        colorSymbols.put("magenta", "FF00FF");
        colorPalleteString = "#Set 1\n228, 26, 28; 55, 126, 184; 77, 175, 74; 166, 86, 40; 152, 78, 163; 255, 127, 0; 247, 129, 191; 153, 153, 153; 255, 255, 51;\n#Dark 2\n27, 158, 119; 217, 95, 2; 117, 112, 179; 231, 41, 138; 102, 166, 30; 230, 171, 2; 166, 118, 29; 102, 102, 102;\n#Set 2\n102, 194, 165; 252, 141, 98; 141, 160, 203; 231, 138, 195; 166, 216, 84; 255, 217, 47; 229, 196, 148; 179, 179, 179;\n#Set 3\n141, 211, 199; 255, 255, 179; 190, 186, 218; 251, 128, 114; 128, 177, 211; 253, 180, 98; 179, 222, 105; 252, 205, 229; 217, 217, 217; 188, 128, 189; 204, 235, 197; 255, 237, 111;\n#Pastel 1\n251, 180, 174; 179, 205, 227; 204, 235, 197; 222, 203, 228; 254, 217, 166; 255, 255, 204; 229, 216, 189; 253, 218, 236;\n#Pastel 2\n173, 226, 207; 253, 205, 172; 203, 213, 232; 244, 202, 228; 230, 245, 201; 255, 242, 174; 243, 225, 206;\n#Accent\n127, 201, 127; 190, 174, 212; 253, 192, 134; 255, 255, 153; 56, 108, 176; 240, 2, 127; 191, 91, 23;";
        nextPaletteIdx = 0;
        palleteNames = new ArrayList();
    }
}

