/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.peaks.PeakTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;

public class PeakCommandBar
extends JPanel {
    private JPanel panel3;
    private JLabel label1;
    private JSlider foldChangeSlider;
    private JPanel panel2;
    private JLabel label2;
    private JSlider scoreSlider;
    private JPanel hSpacer1;
    private JPanel panel1;
    private JLabel label3;
    private JRadioButton peaksButton;
    private JRadioButton signalsButton;
    private JRadioButton bothButton;
    private JPanel hSpacer2;
    private JPanel colorByPanel;
    private JLabel label4;
    private JRadioButton colorByScoresButton;
    private JRadioButton colorByChangeButton;
    private JButton sortButton;

    public PeakCommandBar() {
        this.initComponents();
        this.scoreSlider.setValue((int)PeakTrack.getScoreThreshold());
        this.foldChangeSlider.setValue((int)PeakTrack.getFoldChangeThreshold());
        this.colorByScoresButton.setSelected(PeakTrack.getColorOption() == PeakTrack.ColorOption.SCORE);
        this.colorByChangeButton.setSelected(PeakTrack.getColorOption() == PeakTrack.ColorOption.FOLD_CHANGE);
        this.peaksButton.setSelected(PeakTrack.isShowPeaks() && !PeakTrack.isShowSignals());
        this.signalsButton.setSelected(!PeakTrack.isShowPeaks() && PeakTrack.isShowSignals());
        this.bothButton.setSelected(PeakTrack.isShowPeaks() && PeakTrack.isShowSignals());
    }

    private void scoreSliderStateChanged(ChangeEvent e2) {
        PeakTrack.setScoreThreshold(this.scoreSlider.getValue());
        IGV.getInstance().repaintDataPanels();
    }

    private void foldChangeSliderStateChanged(ChangeEvent e2) {
        PeakTrack.setFoldChangeThreshold(this.foldChangeSlider.getValue());
        IGV.getInstance().repaintDataPanels();
    }

    private void radioButtonActionPerformed(ActionEvent e2) {
        if (this.bothButton.isSelected()) {
            PeakTrack.setShowPeaks(true);
            PeakTrack.setShowSignals(true);
        } else if (this.peaksButton.isSelected()) {
            PeakTrack.setShowPeaks(true);
            PeakTrack.setShowSignals(false);
        } else {
            PeakTrack.setShowPeaks(false);
            PeakTrack.setShowSignals(true);
        }
        IGV.getInstance().repaint();
    }

    private void colorByActionPeformed(ActionEvent e2) {
        if (this.colorByChangeButton.isSelected()) {
            PeakTrack.setShadeOption(PeakTrack.ColorOption.FOLD_CHANGE);
        } else {
            PeakTrack.setShadeOption(PeakTrack.ColorOption.SCORE);
        }
        IGV.getInstance().repaint();
    }

    private void sortButtonActionPerformed(ActionEvent e2) {
        if (FrameManager.isGeneListMode()) {
            MessageUtils.showMessage("To sort in gene list mode right-click the header of a gene panel.");
        } else {
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            RegionOfInterest roi = new RegionOfInterest(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd(), "");
            IGV.getInstance().sortByRegionScore(roi, RegionScoreType.SCORE, frame);
        }
    }

    private void signalsButtonActionPerformed(ActionEvent e2) {
        this.colorByScoresButton.setEnabled(false);
        this.colorByChangeButton.setEnabled(false);
    }

    private void peaksButtonActionPerformed(ActionEvent e2) {
        this.colorByScoresButton.setEnabled(true);
        this.colorByChangeButton.setEnabled(true);
    }

    private void bothButtonActionPerformed(ActionEvent e2) {
        this.colorByScoresButton.setEnabled(true);
        this.colorByChangeButton.setEnabled(true);
    }

    private void initComponents() {
        this.panel3 = new JPanel();
        this.label1 = new JLabel();
        this.foldChangeSlider = new JSlider();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.scoreSlider = new JSlider();
        this.hSpacer1 = new JPanel(null);
        this.panel1 = new JPanel();
        this.label3 = new JLabel();
        this.peaksButton = new JRadioButton();
        this.signalsButton = new JRadioButton();
        this.bothButton = new JRadioButton();
        this.hSpacer2 = new JPanel(null);
        this.colorByPanel = new JPanel();
        this.label4 = new JLabel();
        this.colorByScoresButton = new JRadioButton();
        this.colorByChangeButton = new JRadioButton();
        this.sortButton = new JButton();
        this.setLayout(new FlowLayout(0, 5, 0));
        this.panel3.setLayout(new FlowLayout());
        this.label1.setText("<html>Fold change<br>threshold");
        this.panel3.add(this.label1);
        this.foldChangeSlider.setPaintTicks(true);
        this.foldChangeSlider.setToolTipText("Adjust score threshold");
        this.foldChangeSlider.setMajorTickSpacing(2);
        this.foldChangeSlider.setMinorTickSpacing(1);
        this.foldChangeSlider.setMaximum(10);
        this.foldChangeSlider.setValue(0);
        this.foldChangeSlider.setPaintLabels(true);
        this.foldChangeSlider.setPreferredSize(new Dimension(150, 52));
        this.foldChangeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                PeakCommandBar.this.foldChangeSliderStateChanged(e2);
            }
        });
        this.panel3.add(this.foldChangeSlider);
        this.add(this.panel3);
        this.panel2.setLayout(new FlowLayout());
        this.label2.setText("<html>Score<br>threshold");
        this.panel2.add(this.label2);
        this.scoreSlider.setPaintTicks(true);
        this.scoreSlider.setToolTipText("Adjust score threshold");
        this.scoreSlider.setMajorTickSpacing(20);
        this.scoreSlider.setPaintLabels(true);
        this.scoreSlider.setPreferredSize(new Dimension(150, 52));
        this.scoreSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                PeakCommandBar.this.scoreSliderStateChanged(e2);
            }
        });
        this.panel2.add(this.scoreSlider);
        this.panel2.add(this.hSpacer1);
        this.add(this.panel2);
        this.panel1.setBorder(new EtchedBorder(0));
        this.panel1.setMinimumSize(new Dimension(250, 37));
        this.panel1.setLayout(new FlowLayout());
        this.label3.setText("Show:");
        this.panel1.add(this.label3);
        this.peaksButton.setText("Peaks");
        this.peaksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PeakCommandBar.this.radioButtonActionPerformed(e2);
                PeakCommandBar.this.peaksButtonActionPerformed(e2);
            }
        });
        this.panel1.add(this.peaksButton);
        this.signalsButton.setText("Signals");
        this.signalsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PeakCommandBar.this.radioButtonActionPerformed(e2);
                PeakCommandBar.this.signalsButtonActionPerformed(e2);
            }
        });
        this.panel1.add(this.signalsButton);
        this.bothButton.setText("Both");
        this.bothButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PeakCommandBar.this.radioButtonActionPerformed(e2);
                PeakCommandBar.this.bothButtonActionPerformed(e2);
            }
        });
        this.panel1.add(this.bothButton);
        this.add(this.panel1);
        this.add(this.hSpacer2);
        this.colorByPanel.setBorder(new EtchedBorder(0));
        this.colorByPanel.setLayout(new FlowLayout(0));
        this.label4.setText("Color peaks by:");
        this.colorByPanel.add(this.label4);
        this.colorByScoresButton.setText("Factor");
        this.colorByScoresButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PeakCommandBar.this.colorByActionPeformed(e2);
            }
        });
        this.colorByPanel.add(this.colorByScoresButton);
        this.colorByChangeButton.setText("Change");
        this.colorByChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PeakCommandBar.this.colorByActionPeformed(e2);
            }
        });
        this.colorByPanel.add(this.colorByChangeButton);
        this.add(this.colorByPanel);
        this.sortButton.setText("Sort");
        this.sortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PeakCommandBar.this.sortButtonActionPerformed(e2);
            }
        });
        this.add(this.sortButton);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.peaksButton);
        buttonGroup1.add(this.signalsButton);
        buttonGroup1.add(this.bothButton);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.colorByScoresButton);
        buttonGroup2.add(this.colorByChangeButton);
    }
}

