/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.bionano;

import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.bionano.SMAPFeature;
import org.broad.igv.feature.bionano.SMAPPairedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class SMAPParser {
    private SMAPParser() {
    }

    public static List<Feature> parseFeatures(ResourceLocator locator, Genome genome) throws IOException {
        int linkId;
        String nextLine;
        BufferedReader br = null;
        ArrayList<Feature> features = new ArrayList<Feature>(1000);
        ArrayList<SMAPFeature> partialFeatures = new ArrayList<SMAPFeature>(1000);
        HashMap<Integer, SMAPFeature> featureMap = new HashMap<Integer, SMAPFeature>(1000);
        br = ParsingUtils.openBufferedReader(locator);
        String[] headers = null;
        int refContig1 = -1;
        int refContig2 = -1;
        int refStart = -1;
        int refEnd = -1;
        int confidence = -1;
        int type = -1;
        int idf = -1;
        int linkIdf = -1;
        while ((nextLine = br.readLine()) != null) {
            String chr2;
            if (nextLine.startsWith("#h")) {
                headers = Globals.tabPattern.split(nextLine.substring(3));
                for (int i2 = 0; i2 < headers.length; ++i2) {
                    String h2 = headers[i2];
                    if (h2.equals("RefcontigID1")) {
                        refContig1 = i2;
                        continue;
                    }
                    if (h2.equals("RefcontigID2")) {
                        refContig2 = i2;
                        continue;
                    }
                    if (h2.equals("RefStartPos")) {
                        refStart = i2;
                        continue;
                    }
                    if (h2.equals("RefEndPos")) {
                        refEnd = i2;
                        continue;
                    }
                    if (h2.equals("Confidence")) {
                        confidence = i2;
                        continue;
                    }
                    if (h2.equals("Type")) {
                        type = i2;
                        continue;
                    }
                    if (h2.equals("SmapEntryID")) {
                        idf = i2;
                        continue;
                    }
                    if (!h2.equals("LinkID")) continue;
                    linkIdf = i2;
                }
                continue;
            }
            if (nextLine.startsWith("#")) continue;
            if (headers == null) {
                throw new RuntimeException("Never saw #h line");
            }
            String[] tokens = Globals.tabPattern.split(nextLine);
            int id = Integer.parseInt(tokens[idf]);
            linkId = Integer.parseInt(tokens[linkIdf]);
            String c1 = tokens[refContig1];
            String c2 = tokens[refContig2];
            int start = (int)Double.parseDouble(tokens[refStart]);
            int end = (int)Double.parseDouble(tokens[refEnd]);
            double conf = confidence >= 0 ? Double.parseDouble(tokens[confidence]) : 0.0;
            String t2 = type >= 0 ? tokens[type] : "";
            String chr1 = genome == null ? c1 : genome.getCanonicalChrName(c1);
            String string = chr2 = genome == null ? c2 : genome.getCanonicalChrName(c2);
            if (t2.endsWith("_partial")) {
                partialFeatures.add(new SMAPFeature(chr1, start, end, conf, t2, headers, tokens, linkId));
                continue;
            }
            if (c1.equals(c2)) {
                featureMap.put(id, new SMAPFeature(chr1, start, end, conf, t2, headers, tokens, linkId));
                continue;
            }
            SMAPFeature feature1 = new SMAPFeature(chr1, start, start + 1, conf, t2, headers, tokens);
            SMAPFeature feature2 = new SMAPFeature(chr2, end, end + 1, conf, t2, headers, tokens);
            features.add(feature1);
            features.add(feature2);
        }
        for (SMAPFeature partialFeature : partialFeatures) {
            linkId = partialFeature.getLinkId();
            SMAPFeature f2 = (SMAPFeature)featureMap.get(linkId);
            if (f2 == null) continue;
            f2.addPartialFeature(partialFeature);
        }
        HashSet<Object> pairedIds = new HashSet<Object>();
        for (Map.Entry entry : featureMap.entrySet()) {
            if (pairedIds.contains(entry.getKey())) continue;
            if (((SMAPFeature)entry.getValue()).getType().endsWith("_paired")) {
                SMAPFeature f1 = (SMAPFeature)entry.getValue();
                SMAPFeature f2 = (SMAPFeature)featureMap.get(f1.getLinkId());
                pairedIds.add(entry.getKey());
                pairedIds.add(f1.getLinkId());
                features.add(new SMAPPairedFeature(f1, f2));
                continue;
            }
            features.add((Feature)entry.getValue());
        }
        FeatureUtils.sortFeatureList(features);
        return features;
    }
}

