/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tdf.Accumulator;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class GenomeSummaryData {
    private static Logger log = Logger.getLogger(GenomeSummaryData.class);
    private static final double locationUnit = 1000.0;
    int nPixels = 1000;
    Genome genome;
    String[] samples;
    Map<String, Map<String, FloatArrayList>> dataMap = new HashMap<String, Map<String, FloatArrayList>>();
    Map<String, IntArrayList> locationMap;
    int[] locations;
    Map<String, float[]> data;
    int nDataPts = 0;
    Set<String> skippedChromosomes = new HashSet<String>();
    double scale;

    public GenomeSummaryData(Genome genome, String[] samples) {
        this.genome = genome;
        this.samples = samples;
        this.scale = (double)genome.getNominalLength() / 1000.0 / (double)this.nPixels;
        List<String> chrNames = genome.getLongChromosomeNames();
        this.locationMap = new HashMap<String, IntArrayList>();
        this.dataMap = new HashMap<String, Map<String, FloatArrayList>>();
        for (String chr : chrNames) {
            this.locationMap.put(chr, new IntArrayList(this.nPixels / 10));
            this.dataMap.put(chr, new HashMap());
            for (String s2 : samples) {
                this.dataMap.get(chr).put(s2, new FloatArrayList(this.nPixels / 10));
            }
        }
    }

    void setScale(double scale) {
        if (this.nDataPts > 0) {
            throw new IllegalStateException("Can't alter scale after adding data");
        }
        this.scale = scale;
        this.nPixels = (int)((double)this.genome.getNominalLength() / 1000.0 / scale);
    }

    public void addData(String chr, int[] locs, Map<String, float[]> sampleData) {
        IntArrayList locations = this.locationMap.get(chr);
        if (locations == null) {
            if (!this.skippedChromosomes.contains(chr)) {
                this.skippedChromosomes.add(chr);
                log.info("Skipping data for: " + chr);
            }
            return;
        }
        int lastPixel = -1;
        int lastGenomeLocation = -1;
        HashMap<String, Accumulator> dataPoints = new HashMap<String, Accumulator>();
        for (int i2 = 0; i2 < locs.length; ++i2) {
            int genomeLocation = this.genome.getGenomeCoordinate(chr, locs[i2]);
            int pixel = (int)((double)genomeLocation / this.scale);
            if (lastPixel >= 0 && pixel != lastPixel) {
                locations.add(lastGenomeLocation);
                this.finishLastLocation(chr, dataPoints);
            }
            for (String s2 : this.samples) {
                float[] data = sampleData.get(s2);
                Accumulator dp = (Accumulator)dataPoints.get(s2);
                if (dp == null) {
                    dp = new Accumulator(WindowFunction.mean);
                    dataPoints.put(s2, dp);
                }
                try {
                    dp.add(1, data[i2], null);
                }
                catch (Exception e2) {
                    log.error("Error adding to GenomeSummaryData", e2);
                }
            }
            lastPixel = pixel;
            lastGenomeLocation = genomeLocation;
        }
        locations.add(lastGenomeLocation);
        this.finishLastLocation(chr, dataPoints);
    }

    private void finishLastLocation(String chr, Map<String, Accumulator> dataPoints) {
        ++this.nDataPts;
        for (String s2 : this.dataMap.get(chr).keySet()) {
            Accumulator dp = dataPoints.get(s2);
            dp.finish();
            this.dataMap.get(chr).get(s2).add(dp.getValue());
        }
        dataPoints.clear();
    }

    public int[] getLocations() {
        if (this.locations == null) {
            this.createDataArrays();
        }
        return this.locations;
    }

    public float[] getData(String sample) {
        if (!this.data.containsKey(sample)) {
            this.createDataArrays();
        }
        return this.data.get(sample);
    }

    private synchronized void createDataArrays() {
        this.locations = new int[this.nDataPts];
        int offset = 0;
        List<String> chrNames = this.genome.getLongChromosomeNames();
        for (String chr : chrNames) {
            int[] chrLocs = this.locationMap.get(chr).toArray();
            System.arraycopy(chrLocs, 0, this.locations, offset, chrLocs.length);
            offset += chrLocs.length;
        }
        this.data = new HashMap<String, float[]>();
        for (String s2 : this.samples) {
            float[] sampleData = new float[this.nDataPts];
            offset = 0;
            for (String chr : chrNames) {
                float[] chrData = this.dataMap.get(chr).get(s2).toArray();
                System.arraycopy(chrData, 0, sampleData, offset, chrData.length);
                offset += chrData.length;
            }
            this.data.put(s2, sampleData);
        }
        this.locationMap.clear();
        this.dataMap.clear();
    }
}

