/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

public class Ascii {
    private static final byte[] toUpper = new byte[256];
    private static final byte[] toLower = new byte[256];
    private static final boolean[] isAlpha = new boolean[256];
    private static final boolean[] isUpper = new boolean[256];
    private static final boolean[] isLower = new boolean[256];
    private static final boolean[] isWhite = new boolean[256];
    private static final boolean[] isDigit = new boolean[256];

    public static int toUpper(int c2) {
        return toUpper[c2 & 0xFF] & 0xFF;
    }

    public static int toLower(int c2) {
        return toLower[c2 & 0xFF] & 0xFF;
    }

    public static boolean isAlpha(int c2) {
        return isAlpha[c2 & 0xFF];
    }

    public static boolean isUpper(int c2) {
        return isUpper[c2 & 0xFF];
    }

    public static boolean isLower(int c2) {
        return isLower[c2 & 0xFF];
    }

    public static boolean isWhite(int c2) {
        return isWhite[c2 & 0xFF];
    }

    public static boolean isDigit(int c2) {
        return isDigit[c2 & 0xFF];
    }

    public static int parseInt(byte[] b2, int off, int len) throws NumberFormatException {
        byte c2;
        if (b2 == null || len <= 0 || !Ascii.isDigit(c2 = b2[off++])) {
            String msg = "Could not parse byte array as integer: " + new String(b2);
            throw new NumberFormatException(msg);
        }
        int n2 = c2 - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c2 = b2[off++])) {
                String msg = "Could not parse byte array as integer: " + new String(b2);
                throw new NumberFormatException(msg);
            }
            n2 = n2 * 10 + c2 - 48;
        }
        return n2;
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            Ascii.toUpper[i2] = (byte)i2;
            Ascii.toLower[i2] = (byte)i2;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            int uc = lc + 65 - 97;
            Ascii.toUpper[lc] = (byte)uc;
            Ascii.toLower[uc] = (byte)lc;
            Ascii.isAlpha[lc] = true;
            Ascii.isAlpha[uc] = true;
            Ascii.isLower[lc] = true;
            Ascii.isUpper[uc] = true;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        for (int d2 = 48; d2 <= 57; ++d2) {
            Ascii.isDigit[d2] = true;
        }
    }
}

