/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.linear;

import java.util.ArrayList;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.AbstractLinearOptimizer;
import org.apache.commons.math.optimization.linear.NoFeasibleSolutionException;
import org.apache.commons.math.optimization.linear.SimplexTableau;
import org.apache.commons.math.optimization.linear.UnboundedSolutionException;
import org.apache.commons.math.util.MathUtils;

public class SimplexSolver
extends AbstractLinearOptimizer {
    private static final double DEFAULT_EPSILON = 1.0E-6;
    protected final double epsilon;

    public SimplexSolver() {
        this(1.0E-6);
    }

    public SimplexSolver(double epsilon) {
        this.epsilon = epsilon;
    }

    private Integer getPivotColumn(SimplexTableau tableau) {
        double minValue = 0.0;
        Integer minPos = null;
        for (int i2 = tableau.getNumObjectiveFunctions(); i2 < tableau.getWidth() - 1; ++i2) {
            if (MathUtils.compareTo(tableau.getEntry(0, i2), minValue, this.epsilon) >= 0) continue;
            minValue = tableau.getEntry(0, i2);
            minPos = i2;
        }
        return minPos;
    }

    private Integer getPivotRow(SimplexTableau tableau, int col) {
        ArrayList<Integer> minRatioPositions = new ArrayList<Integer>();
        double minRatio = Double.MAX_VALUE;
        for (int i2 = tableau.getNumObjectiveFunctions(); i2 < tableau.getHeight(); ++i2) {
            double rhs = tableau.getEntry(i2, tableau.getWidth() - 1);
            double entry = tableau.getEntry(i2, col);
            if (MathUtils.compareTo(entry, 0.0, this.epsilon) <= 0) continue;
            double ratio = rhs / entry;
            if (MathUtils.equals(ratio, minRatio, this.epsilon)) {
                minRatioPositions.add(i2);
                continue;
            }
            if (!(ratio < minRatio)) continue;
            minRatio = ratio;
            minRatioPositions = new ArrayList();
            minRatioPositions.add(i2);
        }
        if (minRatioPositions.size() == 0) {
            return null;
        }
        if (minRatioPositions.size() > 1) {
            for (Integer row : minRatioPositions) {
                for (int i3 = 0; i3 < tableau.getNumArtificialVariables(); ++i3) {
                    int column = i3 + tableau.getArtificialVariableOffset();
                    if (!MathUtils.equals(tableau.getEntry(row, column), 1.0, this.epsilon) || !row.equals(tableau.getBasicRow(column))) continue;
                    return row;
                }
            }
        }
        return (Integer)minRatioPositions.get(0);
    }

    protected void doIteration(SimplexTableau tableau) throws OptimizationException {
        this.incrementIterationsCounter();
        Integer pivotCol = this.getPivotColumn(tableau);
        Integer pivotRow = this.getPivotRow(tableau, pivotCol);
        if (pivotRow == null) {
            throw new UnboundedSolutionException();
        }
        double pivotVal = tableau.getEntry(pivotRow, pivotCol);
        tableau.divideRow(pivotRow, pivotVal);
        for (int i2 = 0; i2 < tableau.getHeight(); ++i2) {
            if (i2 == pivotRow) continue;
            double multiplier = tableau.getEntry(i2, pivotCol);
            tableau.subtractRow(i2, pivotRow, multiplier);
        }
    }

    protected void solvePhase1(SimplexTableau tableau) throws OptimizationException {
        if (tableau.getNumArtificialVariables() == 0) {
            return;
        }
        while (!tableau.isOptimal()) {
            this.doIteration(tableau);
        }
        if (!MathUtils.equals(tableau.getEntry(0, tableau.getRhsOffset()), 0.0, this.epsilon)) {
            throw new NoFeasibleSolutionException();
        }
    }

    public RealPointValuePair doOptimize() throws OptimizationException {
        SimplexTableau tableau = new SimplexTableau(this.function, this.linearConstraints, this.goal, this.nonNegative, this.epsilon);
        this.solvePhase1(tableau);
        tableau.dropPhase1Objective();
        while (!tableau.isOptimal()) {
            this.doIteration(tableau);
        }
        return tableau.getSolution();
    }
}

