/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.optimization.general.AbstractLeastSquaresOptimizer;

public class GaussNewtonOptimizer
extends AbstractLeastSquaresOptimizer {
    private final boolean useLU;

    public GaussNewtonOptimizer(boolean useLU) {
        this.useLU = useLU;
    }

    public VectorialPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        VectorialPointValuePair current = null;
        boolean converged = false;
        while (!converged) {
            this.incrementIterationsCounter();
            VectorialPointValuePair previous = current;
            this.updateResidualsAndCost();
            this.updateJacobian();
            current = new VectorialPointValuePair(this.point, this.objective);
            double[] b2 = new double[this.cols];
            double[][] a2 = new double[this.cols][this.cols];
            for (int i2 = 0; i2 < this.rows; ++i2) {
                double[] grad = this.jacobian[i2];
                double weight = this.residualsWeights[i2];
                double residual = this.objective[i2] - this.targetValues[i2];
                double wr = weight * residual;
                for (int j2 = 0; j2 < this.cols; ++j2) {
                    int n2 = j2;
                    b2[n2] = b2[n2] + wr * grad[j2];
                }
                for (int k2 = 0; k2 < this.cols; ++k2) {
                    double[] ak = a2[k2];
                    double wgk = weight * grad[k2];
                    for (int l2 = 0; l2 < this.cols; ++l2) {
                        int n3 = l2;
                        ak[n3] = ak[n3] + wgk * grad[l2];
                    }
                }
            }
            try {
                BlockRealMatrix mA = new BlockRealMatrix(a2);
                DecompositionSolver solver = this.useLU ? new LUDecompositionImpl(mA).getSolver() : new QRDecompositionImpl(mA).getSolver();
                double[] dX = solver.solve(b2);
                for (int i3 = 0; i3 < this.cols; ++i3) {
                    int n4 = i3;
                    this.point[n4] = this.point[n4] + dX[i3];
                }
            }
            catch (InvalidMatrixException e2) {
                throw new OptimizationException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[0]);
            }
            if (previous == null) continue;
            converged = this.checker.converged(this.getIterations(), previous, current);
        }
        return current;
    }
}

