/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.BinomialDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.util.FastMath;

public class BinomialDistributionImpl
extends AbstractIntegerDistribution
implements BinomialDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfTrials;
    private double probabilityOfSuccess;

    public BinomialDistributionImpl(int trials, double p2) {
        this.setNumberOfTrialsInternal(trials);
        this.setProbabilityOfSuccessInternal(p2);
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Deprecated
    public void setNumberOfTrials(int trials) {
        this.setNumberOfTrialsInternal(trials);
    }

    private void setNumberOfTrialsInternal(int trials) {
        if (trials < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_NUMBER_OF_TRIALS, trials);
        }
        this.numberOfTrials = trials;
    }

    @Deprecated
    public void setProbabilityOfSuccess(double p2) {
        this.setProbabilityOfSuccessInternal(p2);
    }

    private void setProbabilityOfSuccessInternal(double p2) {
        if (p2 < 0.0 || p2 > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, p2, 0.0, 1.0);
        }
        this.probabilityOfSuccess = p2;
    }

    protected int getDomainLowerBound(double p2) {
        return -1;
    }

    protected int getDomainUpperBound(double p2) {
        return this.numberOfTrials;
    }

    public double cumulativeProbability(int x2) throws MathException {
        double ret = x2 < 0 ? 0.0 : (x2 >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta(this.getProbabilityOfSuccess(), (double)x2 + 1.0, this.numberOfTrials - x2));
        return ret;
    }

    public double probability(int x2) {
        double ret = x2 < 0 || x2 > this.numberOfTrials ? 0.0 : FastMath.exp(SaddlePointExpansion.logBinomialProbability(x2, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess));
        return ret;
    }

    public int inverseCumulativeProbability(double p2) throws MathException {
        if (p2 == 0.0) {
            return -1;
        }
        if (p2 == 1.0) {
            return Integer.MAX_VALUE;
        }
        return super.inverseCumulativeProbability(p2);
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return this.getNumberOfTrials();
    }

    public double getNumericalMean() {
        return (double)this.getNumberOfTrials() * this.getProbabilityOfSuccess();
    }

    public double getNumericalVariance() {
        double p2 = this.getProbabilityOfSuccess();
        return (double)this.getNumberOfTrials() * p2 * (1.0 - p2);
    }
}

