/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.analysis.interpolation.UnivariateRealInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NumberIsTooSmallException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.MathUtils;

public class SplineInterpolator
implements UnivariateRealInterpolator {
    public PolynomialSplineFunction interpolate(double[] x2, double[] y) {
        if (x2.length != y.length) {
            throw new DimensionMismatchException(x2.length, y.length);
        }
        if (x2.length < 3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)x2.length, (Number)3, true);
        }
        int n2 = x2.length - 1;
        MathUtils.checkOrder(x2);
        double[] h2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            h2[i2] = x2[i2 + 1] - x2[i2];
        }
        double[] mu = new double[n2];
        double[] z = new double[n2 + 1];
        mu[0] = 0.0;
        z[0] = 0.0;
        double g2 = 0.0;
        for (int i3 = 1; i3 < n2; ++i3) {
            g2 = 2.0 * (x2[i3 + 1] - x2[i3 - 1]) - h2[i3 - 1] * mu[i3 - 1];
            mu[i3] = h2[i3] / g2;
            z[i3] = (3.0 * (y[i3 + 1] * h2[i3 - 1] - y[i3] * (x2[i3 + 1] - x2[i3 - 1]) + y[i3 - 1] * h2[i3]) / (h2[i3 - 1] * h2[i3]) - h2[i3 - 1] * z[i3 - 1]) / g2;
        }
        double[] b2 = new double[n2];
        double[] c2 = new double[n2 + 1];
        double[] d2 = new double[n2];
        z[n2] = 0.0;
        c2[n2] = 0.0;
        for (int j2 = n2 - 1; j2 >= 0; --j2) {
            c2[j2] = z[j2] - mu[j2] * c2[j2 + 1];
            b2[j2] = (y[j2 + 1] - y[j2]) / h2[j2] - h2[j2] * (c2[j2 + 1] + 2.0 * c2[j2]) / 3.0;
            d2[j2] = (c2[j2 + 1] - c2[j2]) / (3.0 * h2[j2]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n2];
        double[] coefficients = new double[4];
        for (int i4 = 0; i4 < n2; ++i4) {
            coefficients[0] = y[i4];
            coefficients[1] = b2[i4];
            coefficients[2] = c2[i4];
            coefficients[3] = d2[i4];
            polynomials[i4] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x2, polynomials);
    }
}

