/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class RombergIntegrator
extends UnivariateRealIntegratorImpl {
    @Deprecated
    public RombergIntegrator(UnivariateRealFunction f2) {
        super(f2, 32);
    }

    public RombergIntegrator() {
        super(32);
    }

    @Deprecated
    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, min, max);
    }

    public double integrate(UnivariateRealFunction f2, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        int m2 = this.maximalIterationCount + 1;
        double[] previousRow = new double[m2];
        double[] currentRow = new double[m2];
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        currentRow[0] = qtrap.stage(f2, min, max, 0);
        double olds = currentRow[0];
        for (int i2 = 1; i2 <= this.maximalIterationCount; ++i2) {
            double rLimit;
            double delta;
            double[] tmpRow = previousRow;
            previousRow = currentRow;
            currentRow = tmpRow;
            currentRow[0] = qtrap.stage(f2, min, max, i2);
            for (int j2 = 1; j2 <= i2; ++j2) {
                double r2 = (1L << 2 * j2) - 1L;
                double tIJm1 = currentRow[j2 - 1];
                currentRow[j2] = tIJm1 + (tIJm1 - previousRow[j2 - 1]) / r2;
            }
            double s2 = currentRow[i2];
            if (i2 >= this.minimalIterationCount && ((delta = FastMath.abs(s2 - olds)) <= (rLimit = this.relativeAccuracy * (FastMath.abs(olds) + FastMath.abs(s2)) * 0.5) || delta <= this.absoluteAccuracy)) {
                this.setResult(s2, i2);
                return this.result;
            }
            olds = s2;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 32) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_ITERATIONS_LIMITS, 0, 32);
        }
    }
}

