/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.batik.util.AbstractParsedURLProtocolHandler;
import org.apache.batik.util.Base64DecodeStream;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLData;

public class ParsedURLDataProtocolHandler
extends AbstractParsedURLProtocolHandler {
    static final String DATA_PROTOCOL = "data";
    static final String BASE64 = "base64";
    static final String CHARSET = "charset";

    public ParsedURLDataProtocolHandler() {
        super(DATA_PROTOCOL);
    }

    public ParsedURLData parseURL(ParsedURL baseURL, String urlStr) {
        return this.parseURL(urlStr);
    }

    public ParsedURLData parseURL(String urlStr) {
        DataParsedURLData ret = new DataParsedURLData();
        int pidx = 0;
        int len = urlStr.length();
        int idx = urlStr.indexOf(35);
        ret.ref = null;
        if (idx != -1) {
            if (idx + 1 < len) {
                ret.ref = urlStr.substring(idx + 1);
            }
            urlStr = urlStr.substring(0, idx);
            len = urlStr.length();
        }
        if ((idx = urlStr.indexOf(58)) != -1) {
            ret.protocol = urlStr.substring(pidx, idx);
            if (ret.protocol.indexOf(47) == -1) {
                pidx = idx + 1;
            } else {
                ret.protocol = null;
                pidx = 0;
            }
        }
        if ((idx = urlStr.indexOf(44, pidx)) != -1 && idx != pidx) {
            ret.host = urlStr.substring(pidx, idx);
            pidx = idx + 1;
            int aidx = ret.host.lastIndexOf(59);
            if (aidx == -1 || aidx == ret.host.length()) {
                ret.contentType = ret.host;
            } else {
                String enc = ret.host.substring(aidx + 1);
                idx = enc.indexOf(61);
                if (idx == -1) {
                    ret.contentEncoding = enc;
                    ret.contentType = ret.host.substring(0, aidx);
                } else {
                    ret.contentType = ret.host;
                }
                aidx = 0;
                idx = ret.contentType.indexOf(59, aidx);
                if (idx != -1) {
                    aidx = idx + 1;
                    while (aidx < ret.contentType.length()) {
                        String param;
                        int eqIdx;
                        idx = ret.contentType.indexOf(59, aidx);
                        if (idx == -1) {
                            idx = ret.contentType.length();
                        }
                        if ((eqIdx = (param = ret.contentType.substring(aidx, idx)).indexOf(61)) != -1 && CHARSET.equals(param.substring(0, eqIdx))) {
                            ret.charset = param.substring(eqIdx + 1);
                        }
                        aidx = idx + 1;
                    }
                }
            }
        }
        if (pidx < urlStr.length()) {
            ret.path = urlStr.substring(pidx);
        }
        return ret;
    }

    static class DataParsedURLData
    extends ParsedURLData {
        String charset;

        DataParsedURLData() {
        }

        public boolean complete() {
            return this.path != null;
        }

        public String getPortStr() {
            String portStr = "data:";
            if (this.host != null) {
                portStr = portStr + this.host;
            }
            portStr = portStr + ",";
            return portStr;
        }

        public String toString() {
            String ret = this.getPortStr();
            if (this.path != null) {
                ret = ret + this.path;
            }
            if (this.ref != null) {
                ret = ret + '#' + this.ref;
            }
            return ret;
        }

        public String getContentType(String userAgent) {
            return this.contentType;
        }

        public String getContentEncoding(String userAgent) {
            return this.contentEncoding;
        }

        protected InputStream openStreamInternal(String userAgent, Iterator mimeTypes, Iterator encodingTypes) throws IOException {
            this.stream = DataParsedURLData.decode(this.path);
            if (ParsedURLDataProtocolHandler.BASE64.equals(this.contentEncoding)) {
                this.stream = new Base64DecodeStream(this.stream);
            }
            return this.stream;
        }

        public static InputStream decode(String s2) {
            int len = s2.length();
            byte[] data = new byte[len];
            int j2 = 0;
            int i2 = 0;
            while (i2 < len) {
                char c2 = s2.charAt(i2);
                switch (c2) {
                    default: {
                        data[j2++] = (byte)c2;
                        break;
                    }
                    case '%': {
                        byte b2;
                        if (i2 + 2 >= len) break;
                        char c1 = s2.charAt((i2 += 2) - 1);
                        if (c1 >= '0' && c1 <= '9') {
                            b2 = (byte)(c1 - 48);
                        } else if (c1 >= 'a' && c1 <= 'z') {
                            b2 = (byte)(c1 - 97 + 10);
                        } else {
                            if (c1 < 'A' || c1 > 'Z') break;
                            b2 = (byte)(c1 - 65 + 10);
                        }
                        b2 = (byte)(b2 * 16);
                        char c22 = s2.charAt(i2);
                        if (c22 >= '0' && c22 <= '9') {
                            b2 = (byte)(b2 + (byte)(c22 - 48));
                        } else if (c22 >= 'a' && c22 <= 'z') {
                            b2 = (byte)(b2 + (byte)(c22 - 97 + 10));
                        } else {
                            if (c22 < 'A' || c22 > 'Z') break;
                            b2 = (byte)(b2 + (byte)(c22 - 65 + 10));
                        }
                        data[j2++] = b2;
                    }
                }
                ++i2;
            }
            return new ByteArrayInputStream(data, 0, j2);
        }
    }
}

