/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.CmapIndexEntry;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class CmapTable
implements Table {
    private int version;
    private int numTables;
    private CmapIndexEntry[] entries;
    private CmapFormat[] formats;

    protected CmapTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        raf.seek(de.getOffset());
        long fp = raf.getFilePointer();
        this.version = raf.readUnsignedShort();
        this.numTables = raf.readUnsignedShort();
        this.entries = new CmapIndexEntry[this.numTables];
        this.formats = new CmapFormat[this.numTables];
        int i2 = 0;
        while (i2 < this.numTables) {
            this.entries[i2] = new CmapIndexEntry(raf);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numTables) {
            raf.seek(fp + (long)this.entries[i3].getOffset());
            int format = raf.readUnsignedShort();
            this.formats[i3] = CmapFormat.create(format, raf);
            ++i3;
        }
    }

    public CmapFormat getCmapFormat(short platformId, short encodingId) {
        int i2 = 0;
        while (i2 < this.numTables) {
            if (this.entries[i2].getPlatformId() == platformId && this.entries[i2].getEncodingId() == encodingId) {
                return this.formats[i2];
            }
            ++i2;
        }
        return null;
    }

    public int getType() {
        return 1668112752;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.numTables * 8).append("cmap\n");
        int i2 = 0;
        while (i2 < this.numTables) {
            sb.append('\t').append(this.entries[i2].toString()).append('\n');
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numTables) {
            sb.append('\t').append(this.formats[i3].toString()).append('\n');
            ++i3;
        }
        return sb.toString();
    }
}

