/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.batik.dom.util.DOMUtilitiesSupport;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.xml.XMLCharacters;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtilities
extends XMLUtilities {
    protected static final String[] LOCK_STRINGS = new String[]{"", "CapsLock", "NumLock", "NumLock CapsLock", "Scroll", "Scroll CapsLock", "Scroll NumLock", "Scroll NumLock CapsLock", "KanaMode", "KanaMode CapsLock", "KanaMode NumLock", "KanaMode NumLock CapsLock", "KanaMode Scroll", "KanaMode Scroll CapsLock", "KanaMode Scroll NumLock", "KanaMode Scroll NumLock CapsLock"};
    protected static final String[] MODIFIER_STRINGS = new String[]{"", "Shift", "Control", "Control Shift", "Meta", "Meta Shift", "Control Meta", "Control Meta Shift", "Alt", "Alt Shift", "Alt Control", "Alt Control Shift", "Alt Meta", "Alt Meta Shift", "Alt Control Meta", "Alt Control Meta Shift", "AltGraph", "AltGraph Shift", "AltGraph Control", "AltGraph Control Shift", "AltGraph Meta", "AltGraph Meta Shift", "AltGraph Control Meta", "AltGraph Control Meta Shift", "Alt AltGraph", "Alt AltGraph Shift", "Alt AltGraph Control", "Alt AltGraph Control Shift", "Alt AltGraph Meta", "Alt AltGraph Meta Shift", "Alt AltGraph Control Meta", "Alt AltGraph Control Meta Shift"};

    protected DOMUtilities() {
    }

    public static void writeDocument(Document doc, Writer w2) throws IOException {
        Node n2 = doc.getFirstChild();
        while (n2 != null) {
            DOMUtilities.writeNode(n2, w2);
            n2 = n2.getNextSibling();
        }
    }

    public static void writeNode(Node n2, Writer w2) throws IOException {
        switch (n2.getNodeType()) {
            case 1: {
                Node c2;
                w2.write("<");
                w2.write(n2.getNodeName());
                if (n2.hasAttributes()) {
                    NamedNodeMap attr = n2.getAttributes();
                    int len = attr.getLength();
                    int i2 = 0;
                    while (i2 < len) {
                        Attr a2 = (Attr)attr.item(i2);
                        w2.write(" ");
                        w2.write(a2.getNodeName());
                        w2.write("=\"");
                        w2.write(DOMUtilities.contentToString(a2.getNodeValue()));
                        w2.write("\"");
                        ++i2;
                    }
                }
                if ((c2 = n2.getFirstChild()) != null) {
                    w2.write(">");
                    while (c2 != null) {
                        DOMUtilities.writeNode(c2, w2);
                        c2 = c2.getNextSibling();
                    }
                    w2.write("</");
                    w2.write(n2.getNodeName());
                    w2.write(">");
                    break;
                }
                w2.write("/>");
                break;
            }
            case 3: {
                w2.write(DOMUtilities.contentToString(n2.getNodeValue()));
                break;
            }
            case 4: {
                w2.write("<![CDATA[");
                w2.write(n2.getNodeValue());
                w2.write("]]>");
                break;
            }
            case 5: {
                w2.write("&");
                w2.write(n2.getNodeName());
                w2.write(";");
                break;
            }
            case 7: {
                w2.write("<?");
                w2.write(n2.getNodeName());
                w2.write(" ");
                w2.write(n2.getNodeValue());
                w2.write("?>");
                break;
            }
            case 8: {
                w2.write("<!--");
                w2.write(n2.getNodeValue());
                w2.write("-->");
                break;
            }
            case 10: {
                DocumentType dt = (DocumentType)n2;
                w2.write("<!DOCTYPE ");
                w2.write(n2.getOwnerDocument().getDocumentElement().getNodeName());
                String pubID = dt.getPublicId();
                if (pubID != null) {
                    w2.write(" PUBLIC \"" + dt.getNodeName() + "\" \"" + pubID + "\">");
                    break;
                }
                String sysID = dt.getSystemId();
                if (sysID == null) break;
                w2.write(" SYSTEM \"" + sysID + "\">");
                break;
            }
            default: {
                throw new IOException("Unknown DOM node type " + n2.getNodeType());
            }
        }
    }

    public static String getXML(Node n2) {
        StringWriter writer = new StringWriter();
        try {
            DOMUtilities.writeNode(n2, writer);
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            return "";
        }
        return ((Object)writer).toString();
    }

    public static String contentToString(String s2) {
        StringBuffer result = new StringBuffer(s2.length());
        int i2 = 0;
        while (i2 < s2.length()) {
            char c2 = s2.charAt(i2);
            switch (c2) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '\'': {
                    result.append("&apos;");
                    break;
                }
                default: {
                    result.append(c2);
                }
            }
            ++i2;
        }
        return result.toString();
    }

    public static int getChildIndex(Node child, Node parent) {
        if (child == null || child.getParentNode() != parent || child.getParentNode() == null) {
            return -1;
        }
        return DOMUtilities.getChildIndex(child);
    }

    public static int getChildIndex(Node child) {
        NodeList children = child.getParentNode().getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node currentChild = children.item(i2);
            if (currentChild == child) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static boolean isAnyNodeAncestorOf(ArrayList ancestorNodes, Node node) {
        int n2 = ancestorNodes.size();
        int i2 = 0;
        while (i2 < n2) {
            Node ancestor = (Node)ancestorNodes.get(i2);
            if (DOMUtilities.isAncestorOf(ancestor, node)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static boolean isAncestorOf(Node node, Node descendant) {
        if (node == null || descendant == null) {
            return false;
        }
        Node currentNode = descendant.getParentNode();
        while (currentNode != null) {
            if (currentNode == node) {
                return true;
            }
            currentNode = currentNode.getParentNode();
        }
        return false;
    }

    public static boolean isParentOf(Node node, Node parentNode) {
        return node != null && parentNode != null && node.getParentNode() == parentNode;
    }

    public static boolean canAppend(Node node, Node parentNode) {
        return node != null && parentNode != null && node != parentNode && !DOMUtilities.isAncestorOf(node, parentNode);
    }

    public static boolean canAppendAny(ArrayList children, Node parentNode) {
        if (!DOMUtilities.canHaveChildren(parentNode)) {
            return false;
        }
        int n2 = children.size();
        int i2 = 0;
        while (i2 < n2) {
            Node child = (Node)children.get(i2);
            if (DOMUtilities.canAppend(child, parentNode)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static boolean canHaveChildren(Node parentNode) {
        if (parentNode == null) {
            return false;
        }
        switch (parentNode.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public static Node parseXML(String text, Document doc, String uri, Map prefixes, String wrapperElementName, SAXDocumentFactory documentFactory) {
        String wrapperElementPrefix = "";
        String wrapperElementSuffix = "";
        if (wrapperElementName != null) {
            wrapperElementPrefix = "<" + wrapperElementName;
            if (prefixes != null) {
                wrapperElementPrefix = wrapperElementPrefix + " ";
                Set keySet = prefixes.keySet();
                Iterator iter = keySet.iterator();
                while (iter.hasNext()) {
                    String currentKey = (String)iter.next();
                    String currentValue = (String)prefixes.get(currentKey);
                    wrapperElementPrefix = wrapperElementPrefix + currentKey + "=\"" + currentValue + "\" ";
                }
            }
            wrapperElementPrefix = wrapperElementPrefix + ">";
            wrapperElementSuffix = wrapperElementSuffix + "</" + wrapperElementName + ">";
        }
        if (wrapperElementPrefix.trim().length() == 0 && wrapperElementSuffix.trim().length() == 0) {
            try {
                Document d2 = documentFactory.createDocument(uri, new StringReader(text));
                if (doc == null) {
                    return d2;
                }
                DocumentFragment result = doc.createDocumentFragment();
                result.appendChild(doc.importNode(d2.getDocumentElement(), true));
                return result;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer(wrapperElementPrefix.length() + text.length() + wrapperElementSuffix.length());
        sb.append(wrapperElementPrefix);
        sb.append(text);
        sb.append(wrapperElementSuffix);
        String newText = sb.toString();
        try {
            Document d3 = documentFactory.createDocument(uri, new StringReader(newText));
            if (doc == null) {
                return d3;
            }
            Node node = d3.getDocumentElement().getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    node = doc.importNode(node, true);
                    DocumentFragment result = doc.createDocumentFragment();
                    result.appendChild(node);
                    return result;
                }
                node = node.getNextSibling();
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        return null;
    }

    public static Document deepCloneDocument(Document doc, DOMImplementation impl) {
        Element root = doc.getDocumentElement();
        Document result = impl.createDocument(root.getNamespaceURI(), root.getNodeName(), null);
        Element rroot = result.getDocumentElement();
        boolean before = true;
        Node n2 = doc.getFirstChild();
        while (n2 != null) {
            if (n2 == root) {
                before = false;
                if (root.hasAttributes()) {
                    NamedNodeMap attr = root.getAttributes();
                    int len = attr.getLength();
                    int i2 = 0;
                    while (i2 < len) {
                        rroot.setAttributeNode((Attr)result.importNode(attr.item(i2), true));
                        ++i2;
                    }
                }
                Node c2 = root.getFirstChild();
                while (c2 != null) {
                    rroot.appendChild(result.importNode(c2, true));
                    c2 = c2.getNextSibling();
                }
            } else if (n2.getNodeType() != 10) {
                if (before) {
                    result.insertBefore(result.importNode(n2, true), rroot);
                } else {
                    result.appendChild(result.importNode(n2, true));
                }
            }
            n2 = n2.getNextSibling();
        }
        return result;
    }

    public static boolean isValidName(String s2) {
        int m2;
        int len = s2.length();
        if (len == 0) {
            return false;
        }
        char c2 = s2.charAt(0);
        int d2 = c2 / 32;
        if ((XMLCharacters.NAME_FIRST_CHARACTER[d2] & 1 << (m2 = c2 % 32)) == 0) {
            return false;
        }
        int i2 = 1;
        while (i2 < len) {
            c2 = s2.charAt(i2);
            d2 = c2 / 32;
            if ((XMLCharacters.NAME_CHARACTER[d2] & 1 << (m2 = c2 % 32)) == 0) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isValidName11(String s2) {
        int m2;
        int len = s2.length();
        if (len == 0) {
            return false;
        }
        char c2 = s2.charAt(0);
        int d2 = c2 / 32;
        if ((XMLCharacters.NAME11_FIRST_CHARACTER[d2] & 1 << (m2 = c2 % 32)) == 0) {
            return false;
        }
        int i2 = 1;
        while (i2 < len) {
            c2 = s2.charAt(i2);
            d2 = c2 / 32;
            if ((XMLCharacters.NAME11_CHARACTER[d2] & 1 << (m2 = c2 % 32)) == 0) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isValidPrefix(String s2) {
        return s2.indexOf(58) == -1;
    }

    public static String getPrefix(String s2) {
        int i2 = s2.indexOf(58);
        return i2 == -1 || i2 == s2.length() - 1 ? null : s2.substring(0, i2);
    }

    public static String getLocalName(String s2) {
        int i2 = s2.indexOf(58);
        return i2 == -1 || i2 == s2.length() - 1 ? s2 : s2.substring(i2 + 1);
    }

    /*
     * Unable to fully structure code
     */
    public static void parseStyleSheetPIData(String data, HashTable table) {
        i = 0;
        while (i < data.length()) {
            c = data.charAt(i);
            if (!XMLUtilities.isXMLSpace(c)) break;
            ++i;
        }
        block1: while (i < data.length()) {
            c = data.charAt(i);
            d = c / 32;
            if ((XMLCharacters.NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c);
            }
            ident = new StringBuffer();
            ident.append(c);
            while (++i < data.length()) {
                c = data.charAt(i);
                d = c / 32;
                if ((XMLCharacters.NAME_CHARACTER[d] & 1 << (m = c % 32)) == 0) break;
                ident.append(c);
            }
            if (i < data.length()) ** GOTO lbl26
            throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            while (XMLUtilities.isXMLSpace(c = data.charAt(i))) {
                ++i;
lbl26:
                // 2 sources

                if (i < data.length()) continue;
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            if (data.charAt(i) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            ++i;
            while (i < data.length()) {
                c = data.charAt(i);
                if (!XMLUtilities.isXMLSpace(c)) break;
                ++i;
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            c = data.charAt(i);
            ++i;
            value = new StringBuffer();
            if (c == '\'') {
                while (i < data.length()) {
                    c = data.charAt(i);
                    if (c == '\'') break;
                    value.append(c);
                    ++i;
                }
                if (i >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else if (c == '\"') {
                while (i < data.length()) {
                    c = data.charAt(i);
                    if (c == '\"') break;
                    value.append(c);
                    ++i;
                }
                if (i >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            table.put(ident.toString().intern(), value.toString());
            ++i;
            while (i < data.length()) {
                c = data.charAt(i);
                if (!XMLUtilities.isXMLSpace(c)) continue block1;
                ++i;
            }
        }
    }

    public static String getModifiersList(int lockState, int modifiers) {
        return DOMUtilitiesSupport.getModifiersList(lockState, modifiers);
    }
}

