/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.AbstractValueFactory;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SVGPaintManager
extends SVGColorManager {
    public SVGPaintManager(String prop) {
        super(prop);
    }

    public SVGPaintManager(String prop, Value v2) {
        super(prop, v2);
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return true;
    }

    public int getPropertyType() {
        return 7;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 35: {
                if (lu.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
            }
            default: {
                return super.createValue(lu, engine);
            }
            case 24: 
        }
        String value = lu.getStringValue();
        String uri = AbstractValueFactory.resolveURI(engine.getCSSBaseURI(), value);
        lu = lu.getNextLexicalUnit();
        if (lu == null) {
            return new URIValue(value, uri);
        }
        ListValue result = new ListValue(' ');
        result.append(new URIValue(value, uri));
        if (lu.getLexicalUnitType() == 35 && lu.getStringValue().equalsIgnoreCase("none")) {
            result.append(ValueConstants.NONE_VALUE);
            return result;
        }
        Value v2 = super.createValue(lu, engine);
        if (v2.getCssValueType() == 3) {
            ListValue lv = (ListValue)v2;
            int i2 = 0;
            while (i2 < lv.getLength()) {
                result.append(lv.item(i2));
                ++i2;
            }
        } else {
            result.append(v2);
        }
        return result;
    }

    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        ListValue lv;
        Value v2;
        if (value == ValueConstants.NONE_VALUE) {
            return value;
        }
        if (value.getCssValueType() == 2 && (v2 = (lv = (ListValue)value).item(0)).getPrimitiveType() == 20) {
            v2 = lv.item(1);
            if (v2 == ValueConstants.NONE_VALUE) {
                return value;
            }
            Value t2 = super.computeValue(elt, pseudo, engine, idx, sm, v2);
            if (t2 != v2) {
                ListValue result = new ListValue(' ');
                result.append(lv.item(0));
                result.append(t2);
                if (lv.getLength() == 3) {
                    result.append(lv.item(1));
                }
                return result;
            }
            return value;
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }
}

