/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import com.mongodb.util.MyAsserts;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawDBObject
implements DBObject {
    final ByteBuffer _buf;
    final int _offset;
    final int _end;
    private static final byte[] _cStrBuf = new byte[1024];

    RawDBObject(ByteBuffer buf) {
        this(buf, 0);
        MyAsserts.assertEquals(this._end, this._buf.limit());
    }

    RawDBObject(ByteBuffer buf, int offset) {
        this._buf = buf;
        this._offset = offset;
        this._end = this._buf.getInt(this._offset);
    }

    @Override
    public Object get(String key) {
        Element e2 = this.findElement(key);
        if (e2 == null) {
            return null;
        }
        return e2.getObject();
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> m2 = new HashMap<String, Object>();
        for (String s2 : this.keySet()) {
            m2.put(s2, this.get(String.valueOf(s2)));
        }
        return m2;
    }

    @Override
    public Object put(String key, Object v2) {
        throw new RuntimeException("read only");
    }

    @Override
    public void putAll(BSONObject o2) {
        throw new RuntimeException("read only");
    }

    @Override
    public void putAll(Map m2) {
        throw new RuntimeException("read only");
    }

    @Override
    public Object removeField(String key) {
        throw new RuntimeException("read only");
    }

    @Override
    @Deprecated
    public boolean containsKey(String key) {
        return this.containsField(key);
    }

    @Override
    public boolean containsField(String field) {
        return this.findElement(field) != null;
    }

    @Override
    public Set<String> keySet() {
        Element e2;
        HashSet<String> keys = new HashSet<String>();
        ElementIter i2 = new ElementIter();
        while (i2.hasNext() && !(e2 = i2.next()).eoo()) {
            keys.add(e2.fieldName());
        }
        return keys;
    }

    String _readCStr(int start) {
        return this._readCStr(start, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String _readCStr(int start, int[] end) {
        byte[] byArray = _cStrBuf;
        synchronized (_cStrBuf) {
            int pos = 0;
            while (this._buf.get(pos + start) != 0) {
                int y;
                RawDBObject._cStrBuf[pos] = this._buf.get(pos + start);
                if (++pos >= _cStrBuf.length) {
                    throw new IllegalArgumentException("c string too big for RawDBObject.  so far[" + new String(_cStrBuf) + "]");
                }
                if (pos + start < this._buf.limit()) continue;
                StringBuilder sb = new StringBuilder();
                for (int x2 = 0; x2 < 10 && (y = start + x2) < this._buf.limit(); ++x2) {
                    sb.append((char)this._buf.get(y));
                }
                throw new IllegalArgumentException("can't find end of cstring.  start:" + start + " pos: " + pos + " [" + sb + "]");
            }
            if (end != null && end.length > 0) {
                end[0] = start + pos;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new String(_cStrBuf, 0, pos);
        }
    }

    String _readJavaString(int start) {
        int size = this._buf.getInt(start) - 1;
        byte[] b2 = new byte[size];
        int old = this._buf.position();
        this._buf.position(start + 4);
        this._buf.get(b2, 0, b2.length);
        this._buf.position(old);
        try {
            return new String(b2, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(b2);
        }
    }

    int _cStrLength(int start) {
        int end = start;
        while (this._buf.get(end) != 0) {
            ++end;
        }
        return 1 + (end - start);
    }

    Element findElement(String name) {
        ElementIter i2 = new ElementIter();
        while (i2.hasNext()) {
            Element e2 = i2.next();
            if (!e2.fieldName().equals(name)) continue;
            return e2;
        }
        return null;
    }

    @Override
    public boolean isPartialObject() {
        return false;
    }

    @Override
    public void markAsPartialObject() {
        throw new RuntimeException("RawDBObject can't be a partial object");
    }

    public String toString() {
        return "Object";
    }

    class ElementIter {
        int _pos;
        boolean _done = false;

        ElementIter() {
            this._pos = RawDBObject.this._offset + 4;
        }

        boolean hasNext() {
            return !this._done && this._pos < RawDBObject.this._buf.limit();
        }

        Element next() {
            Element e2 = new Element(this._pos);
            this._done = e2.eoo();
            this._pos += e2.size();
            return e2;
        }
    }

    class Element {
        final int _start;
        final byte _type;
        final String _name;
        final int _dataStart;
        final int _size;
        Object _cached;

        Element(int start) {
            this._start = start;
            this._type = RawDBObject.this._buf.get(this._start);
            int[] end = new int[1];
            this._name = this.eoo() ? "" : RawDBObject.this._readCStr(this._start + 1, end);
            int size = 1 + (end[0] - this._start);
            this._dataStart = this._start + size;
            switch (this._type) {
                case -1: 
                case 0: 
                case 6: 
                case 10: 
                case 127: {
                    break;
                }
                case 8: {
                    ++size;
                    break;
                }
                case 1: 
                case 9: 
                case 18: {
                    size += 8;
                    break;
                }
                case 16: {
                    size += 4;
                    break;
                }
                case 7: {
                    size += 12;
                    break;
                }
                case 12: {
                    size += 12;
                    size += 4 + RawDBObject.this._buf.getInt(this._dataStart);
                    break;
                }
                case 2: 
                case 13: 
                case 14: {
                    size += 4 + RawDBObject.this._buf.getInt(this._dataStart);
                    break;
                }
                case 3: 
                case 4: 
                case 15: {
                    size += RawDBObject.this._buf.getInt(this._dataStart);
                    break;
                }
                case 5: {
                    size += 4 + RawDBObject.this._buf.getInt(this._dataStart) + 1;
                    break;
                }
                case 11: {
                    int first = RawDBObject.this._cStrLength(this._dataStart);
                    int second = RawDBObject.this._cStrLength(this._dataStart + first);
                    size += first + second;
                    break;
                }
                case 17: {
                    size += 8;
                    break;
                }
                default: {
                    throw new RuntimeException("RawDBObject can't size type " + this._type);
                }
            }
            this._size = size;
        }

        String fieldName() {
            return this._name;
        }

        boolean eoo() {
            return this._type == 0 || this._type == 127;
        }

        int size() {
            return this._size;
        }

        Object getObject() {
            if (this._cached != null) {
                return this._cached;
            }
            switch (this._type) {
                case 1: {
                    return RawDBObject.this._buf.getDouble(this._dataStart);
                }
                case 16: {
                    return RawDBObject.this._buf.getInt(this._dataStart);
                }
                case 7: {
                    return new ObjectId(RawDBObject.this._buf.getInt(this._dataStart), RawDBObject.this._buf.getInt(this._dataStart + 4), RawDBObject.this._buf.getInt(this._dataStart + 8));
                }
                case 13: 
                case 15: {
                    throw new RuntimeException("can't handle code");
                }
                case 2: 
                case 14: {
                    return RawDBObject.this._readJavaString(this._dataStart);
                }
                case 9: {
                    return new Date(RawDBObject.this._buf.getLong(this._dataStart));
                }
                case 11: {
                    throw new RuntimeException("can't handle regex");
                }
                case 5: {
                    throw new RuntimeException("can't inspect binary in db");
                }
                case 8: {
                    return RawDBObject.this._buf.get(this._dataStart) > 0;
                }
                case 3: 
                case 4: {
                    throw new RuntimeException("can't handle emebdded objects");
                }
                case -1: 
                case 0: 
                case 6: 
                case 10: 
                case 127: {
                    return null;
                }
            }
            throw new RuntimeException("can't decode type " + this._type);
        }
    }
}

