/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.GradientCache;
import com.jidesoft.swing.GradientInfo;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;

class FastGradientPainter {
    private static GradientCache gradientCache = new GradientCache();

    private FastGradientPainter() {
    }

    public static void clearGradientCache() {
        gradientCache.clear();
    }

    public static void drawGradient(Graphics2D g2, Shape s2, Color startColor, Color endColor, boolean isVertical) {
        Rectangle r2 = s2.getBounds();
        if (r2.height <= 0 || r2.width <= 0) {
            return;
        }
        int length = isVertical ? r2.height : r2.width;
        GradientInfo info = new GradientInfo(g2.getDeviceConfiguration(), length, startColor, endColor, isVertical);
        BufferedImage gradient = gradientCache.retrieve(info);
        if (gradient == null) {
            gradient = FastGradientPainter.createGradientTile(info);
            gradientCache.store(info, gradient);
        }
        Shape prevClip = null;
        boolean nonRectangular = false;
        if (!r2.equals(s2)) {
            nonRectangular = true;
            prevClip = g2.getClip();
            g2.clip(s2);
        }
        if (isVertical) {
            int w2 = gradient.getWidth();
            int loops = r2.width / w2;
            for (int i2 = 0; i2 < loops; ++i2) {
                g2.drawImage((Image)gradient, r2.x + i2 * w2, r2.y, null);
            }
            int rem = r2.width % w2;
            if (rem > 0) {
                g2.drawImage(gradient, r2.x + loops * w2, r2.y, r2.x + loops * w2 + rem, r2.y + length, 0, 0, rem, length, null);
            }
        } else {
            int h2 = gradient.getHeight();
            int loops = r2.height / h2;
            for (int i3 = 0; i3 < loops; ++i3) {
                g2.drawImage((Image)gradient, r2.x, r2.y + i3 * h2, null);
            }
            int rem = r2.height % h2;
            if (rem > 0) {
                g2.drawImage(gradient, r2.x, r2.y + loops * h2, r2.x + length, r2.y + loops * h2 + rem, 0, 0, length, rem, null);
            }
        }
        if (nonRectangular) {
            g2.setClip(prevClip);
        }
    }

    private static BufferedImage createGradientTile(GradientInfo info) {
        int w2;
        int h2;
        int dy;
        int dx;
        boolean t2;
        boolean bl = t2 = info.startColor.getTransparency() > 1 || info.endColor.getTransparency() > 1;
        if (info.isVertical) {
            dx = 0;
            h2 = dy = info.length;
            w2 = 32;
        } else {
            w2 = dx = info.length;
            dy = 0;
            h2 = 32;
        }
        BufferedImage img = info.gfxConfig.createCompatibleImage(w2, h2, t2 ? 3 : 1);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, info.startColor, dx, dy, info.endColor);
        Graphics2D g2 = img.createGraphics();
        g2.setPaint(gp);
        g2.fillRect(0, 0, w2, h2);
        g2.dispose();
        return img;
    }
}

