/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.PopupUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.Gripper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicJidePopupUI
extends PopupUI {
    protected JidePopup _popup;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _dockableFrameLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected Gripper _titlePane;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;

    public static ComponentUI createUI(JComponent b2) {
        return new BasicJidePopupUI((JidePopup)b2);
    }

    public BasicJidePopupUI() {
    }

    public BasicJidePopupUI(JidePopup f2) {
        this._popup = f2;
    }

    public void installUI(JComponent c2) {
        this._popup = (JidePopup)c2;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        this._popup.setOpaque(true);
    }

    public void uninstallUI(JComponent c2) {
        if (c2 != this._popup) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + c2 + " when it only knows about " + this._popup + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._popup = null;
    }

    protected void installDefaults() {
        Color bg;
        JComponent contentPane = (JComponent)this._popup.getContentPane();
        if (contentPane != null && (bg = contentPane.getBackground()) instanceof UIResource) {
            contentPane.setBackground(null);
        }
        this._dockableFrameLayout = this.createLayoutManager();
        this._popup.setLayout(this._dockableFrameLayout);
        this._popup.setBackground(UIDefaultsLookup.getColor("JideButton.background"));
        LookAndFeel.installBorder(this._popup, "Popup.border");
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._popup, actionMap);
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIDefaultsLookup.get("Popup.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Popup.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        return map;
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this._popup));
        this.setSouthPane(this.createSouthPane(this._popup));
        this.setEastPane(this.createEastPane(this._popup));
        this.setWestPane(this.createWestPane(this._popup));
    }

    protected void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._popup.addPropertyChangeListener(this._propertyChangeListener);
    }

    InputMap getInputMap(int condition) {
        if (condition == 2) {
            return this.createInputMap(condition);
        }
        return null;
    }

    InputMap createInputMap(int condition) {
        Object[] bindings;
        if (condition == 2 && (bindings = (Object[])UIDefaultsLookup.get("Popup.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._popup, bindings);
        }
        return null;
    }

    protected void uninstallDefaults() {
        this._dockableFrameLayout = null;
        this._popup.setLayout(null);
        LookAndFeel.uninstallBorder(this._popup);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this._titlePane = null;
    }

    protected void uninstallListeners() {
        this._popup.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this._popup, 2, null);
        SwingUtilities.replaceUIActionMap(this._popup, null);
    }

    public Component getGripper() {
        return this._titlePane;
    }

    protected LayoutManager createLayoutManager() {
        return new PopupLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PopupPropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent x2) {
        if (this._popup == x2 && this._popup.getLayout() != null) {
            return this._popup.getLayout().preferredLayoutSize(x2);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize(JComponent x2) {
        if (this._popup == x2) {
            return this._popup.getLayout().minimumLayoutSize(x2);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent x2) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent currentPane, JComponent newPane) {
        if (currentPane != null) {
            this.deinstallMouseHandlers(currentPane);
            this._popup.remove(currentPane);
        }
        if (newPane != null) {
            this._popup.add(newPane);
            this.installMouseHandlers(newPane);
        }
    }

    protected void deinstallMouseHandlers(JComponent c2) {
    }

    protected void installMouseHandlers(JComponent c2) {
    }

    protected JComponent createNorthPane(JidePopup w2) {
        if (w2.getGripperLocation() == 1 && w2.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(1);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createSouthPane(JidePopup w2) {
        if (w2.getGripperLocation() == 5 && w2.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(1);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createWestPane(JidePopup w2) {
        if (w2.getGripperLocation() == 7 && w2.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(0);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createEastPane(JidePopup w2) {
        if (w2.getGripperLocation() == 3 && w2.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(0);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingRegistered(boolean b2) {
        this.keyBindingRegistered = b2;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final void setKeyBindingActive(boolean b2) {
        this.keyBindingActive = b2;
    }

    protected void setupMenuOpenKey() {
        InputMap map = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this._popup, 2, map);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this._northPane;
    }

    protected void setNorthPane(JComponent c2) {
        this.replacePane(this._northPane, c2);
        this._northPane = c2;
    }

    public JComponent getSouthPane() {
        return this._southPane;
    }

    protected void setSouthPane(JComponent c2) {
        this.replacePane(this._southPane, c2);
        this._southPane = c2;
    }

    public JComponent getWestPane() {
        return this._westPane;
    }

    protected void setWestPane(JComponent c2) {
        this.replacePane(this._westPane, c2);
        this._westPane = c2;
    }

    public JComponent getEastPane() {
        return this._eastPane;
    }

    protected void setEastPane(JComponent c2) {
        this.replacePane(this._eastPane, c2);
        this._eastPane = c2;
    }

    public class PopupLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c2) {
        }

        public void removeLayoutComponent(Component c2) {
        }

        public Dimension preferredLayoutSize(Container c2) {
            Dimension d2;
            Insets i2 = BasicJidePopupUI.this._popup.getInsets();
            Dimension result = new Dimension(BasicJidePopupUI.this._popup.getRootPane().getPreferredSize());
            result.width += i2.left + i2.right;
            result.height += i2.top + i2.bottom;
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                d2 = BasicJidePopupUI.this.getNorthPane().getPreferredSize();
                result.width = Math.max(d2.width, result.width);
                result.height += d2.height;
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                d2 = BasicJidePopupUI.this.getSouthPane().getPreferredSize();
                result.width = Math.max(d2.width, result.width);
                result.height += d2.height;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                d2 = BasicJidePopupUI.this.getEastPane().getPreferredSize();
                result.width += d2.width;
                result.height = Math.max(d2.height, result.height);
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                d2 = BasicJidePopupUI.this.getWestPane().getPreferredSize();
                result.width += d2.width;
                result.height = Math.max(d2.height, result.height);
            }
            return result;
        }

        public Dimension minimumLayoutSize(Container c2) {
            Dimension minimumSize;
            Dimension result = new Dimension();
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                result = new Dimension(BasicJidePopupUI.this.getNorthPane().getMinimumSize());
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                minimumSize = BasicJidePopupUI.this.getSouthPane().getMinimumSize();
                result.width = Math.max(result.width, minimumSize.width);
                result.height += minimumSize.height;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                minimumSize = BasicJidePopupUI.this.getEastPane().getMinimumSize();
                result.width += minimumSize.width;
                result.height = Math.max(result.height, minimumSize.height);
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                minimumSize = BasicJidePopupUI.this.getWestPane().getMinimumSize();
                result.width = Math.max(result.width, minimumSize.width);
                result.height += minimumSize.height;
            }
            Dimension alter = BasicJidePopupUI.this._popup.getContentPane().getMinimumSize();
            if (alter.width > result.width) {
                result.width = alter.width;
            }
            result.height += alter.height;
            Insets i2 = BasicJidePopupUI.this._popup.getInsets();
            result.width += i2.left + i2.right;
            result.height += i2.top + i2.bottom;
            return result;
        }

        public void layoutContainer(Container c2) {
            Dimension size;
            Insets i2 = BasicJidePopupUI.this._popup.getInsets();
            int cx = i2.left;
            int cy = i2.top;
            int cw = BasicJidePopupUI.this._popup.getWidth() - i2.left - i2.right;
            int ch = BasicJidePopupUI.this._popup.getHeight() - i2.top - i2.bottom;
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                BasicJidePopupUI.this.getNorthPane().setVisible(true);
                size = BasicJidePopupUI.this.getNorthPane().getPreferredSize();
                BasicJidePopupUI.this.getNorthPane().setBounds(cx, cy, cw, size.height);
                cy += size.height;
                ch -= size.height;
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                size = BasicJidePopupUI.this.getSouthPane().getPreferredSize();
                BasicJidePopupUI.this.getSouthPane().setBounds(cx, BasicJidePopupUI.this._popup.getHeight() - i2.bottom - size.height, cw, size.height);
                ch -= size.height;
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                size = BasicJidePopupUI.this.getWestPane().getPreferredSize();
                BasicJidePopupUI.this.getWestPane().setBounds(cx, cy, size.width, ch);
                cw -= size.width;
                cx += size.width;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                size = BasicJidePopupUI.this.getEastPane().getPreferredSize();
                BasicJidePopupUI.this.getEastPane().setBounds(cw - size.width, cy, size.width, ch);
                cw -= size.width;
            }
            if (BasicJidePopupUI.this._popup.getRootPane() != null) {
                BasicJidePopupUI.this._popup.getRootPane().setBounds(cx, cy, cw, ch);
            }
        }
    }

    public class PopupPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            JidePopup f2 = (JidePopup)evt.getSource();
            Object newValue = evt.getNewValue();
            Object oldValue = evt.getOldValue();
            if ("movable".equals(prop)) {
                f2.updateUI();
            }
            if ("gripperLocation".equals(prop)) {
                f2.updateUI();
            }
        }
    }
}

